/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.unit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.AtlCodeFormatter;
import org.eclipse.m2m.atl.tests.unit.TestNonRegression;
import org.eclipse.m2m.atl.tests.unit.TestNonRegressionParser;
import org.eclipse.m2m.atl.tests.util.FileUtils;

public class TestNonRegressionFormatter
extends TestNonRegression {
    protected void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.load(TestNonRegressionParser.class.getResourceAsStream("TestNonRegressionFormatter.properties"));
        this.setProperties(properties);
    }

    protected void singleTest(File directory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith(".atl")) {
                File expected = new File(input.getPath().replaceFirst("inputs", "expected"));
                this.testFile(input, expected);
            }
            ++n2;
        }
    }

    private void testFile(File input, File expected) {
        String result = "";
        try {
            long startTime = System.currentTimeMillis();
            result = new AtlCodeFormatter().format((InputStream)new FileInputStream(input));
            long endTime = System.currentTimeMillis();
            System.err.println("Formatted " + input + ", took " + (double)(endTime - startTime) / 1000.0 + "s.");
            if (expected.exists()) {
                String expectedResult = FileUtils.readFileAsString(expected);
                expectedResult = expectedResult.replaceAll("\r\n", "\n");
                result = result.replaceAll("\r\n", "\n");
                TestNonRegressionFormatter.assertEquals((String)input.getName(), (String)expectedResult, (String)result);
            } else {
                FileWriter fw = new FileWriter(expected);
                fw.write(result);
                fw.close();
            }
        }
        catch (Exception e) {
            TestNonRegressionFormatter.fail(input.getName(), e);
        }
    }
}

