/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.util.LazyBag;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyOrderedSet<E>
extends LazyCollection<E>
implements Set<E>,
List<E> {
    public LazyOrderedSet() {
    }

    public LazyOrderedSet(Iterable<E> dataSource) {
        super(dataSource);
    }

    @Override
    protected void createCache() {
        super.createCache();
        if (this.cache == null) {
            this.cache = new ArrayList();
        }
        assert (this.cache instanceof List);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.dataSource == null) {
            return this.cache.iterator();
        }
        return new LazyCollection.CachingSetIterator(this);
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        if (index < this.cache.size()) {
            return ((List)this.cache).get(index);
        }
        int i = 0;
        for (E e : this) {
            if (i == index) {
                return e;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int indexOf(Object o) {
        int index = ((List)this.cache).indexOf(o);
        if (index > -1 || this.dataSource == null) {
            return index;
        }
        int i = 0;
        for (E e : this) {
            if (e == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        if (this.dataSource == null) {
            return Collections.unmodifiableList((List)this.cache).listIterator();
        }
        return new LazyCollection.IteratorToListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (this.dataSource == null) {
            return Collections.unmodifiableList((List)this.cache).listIterator(index);
        }
        return new LazyCollection.IteratorToListIterator((LazyCollection)this, index);
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubOrderedSet(fromIndex, toIndex, this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List) || !(o instanceof Set)) {
            return false;
        }
        Iterator<E> e1 = this.iterator();
        Iterator e2 = ((Collection)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        for (E obj : this) {
            if (obj == null) continue;
            hashCode += obj.hashCode();
        }
        return hashCode;
    }

    @Override
    public int count(E o) {
        return this.contains(o) ? 1 : 0;
    }

    public E at(int i) {
        return this.get(i - 1);
    }

    public int indexOf2(Object obj) throws IndexOutOfBoundsException {
        int i = this.indexOf(obj) + 1;
        if (i == 0) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    public int lastIndexOf2(Object obj) throws IndexOutOfBoundsException {
        int i = this.lastIndexOf(obj) + 1;
        if (i == 0) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    public E first() {
        if (this.cache.size() > 0) {
            return ((List)this.cache).get(0);
        }
        return this.iterator().next();
    }

    public E last() {
        if (this.dataSource == null) {
            int size = this.cache.size();
            if (size < 1) {
                throw new NoSuchElementException();
            }
            return ((List)this.cache).get(size - 1);
        }
        boolean lastSet = false;
        E last2 = null;
        for (E last2 : this) {
            lastSet = true;
        }
        if (!lastSet) {
            throw new NoSuchElementException();
        }
        return last2;
    }

    public LazyOrderedSet<E> union(final LazyOrderedSet<E> s) {
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.UnionSetIterator((LazyCollection)this, s);
            }
        };
    }

    public LazySet<E> union(final LazySet<E> s) {
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.UnionSetIterator((LazyCollection)this, s);
            }
        };
    }

    public LazyBag<E> union(LazyBag<E> bag) {
        return new LazyBag.UnionBag<E>(bag, this);
    }

    public LazyOrderedSet<E> intersection(final LazyOrderedSet<E> s) {
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.IntersectionIterator((LazyCollection)this, s);
            }
        };
    }

    public LazyOrderedSet<E> intersection(final LazySet<E> s) {
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.IntersectionIterator((LazyCollection)this, s);
            }
        };
    }

    public LazyOrderedSet<E> intersection(final LazyBag<E> s) {
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.IntersectionIterator((LazyCollection)this, s);
            }
        };
    }

    public LazyOrderedSet<E> subtract(final LazyOrderedSet<E> s) {
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SubtractionIterator((LazyCollection)this, s);
            }
        };
    }

    public LazyOrderedSet<E> subtract(final LazySet<E> s) {
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SubtractionIterator((LazyCollection)this, s);
            }
        };
    }

    @Override
    public LazyOrderedSet<E> including(E object) {
        return this.append(object);
    }

    public LazyOrderedSet<E> excluding(E object) {
        return new ExcludingOrderedSet<E>(object, this);
    }

    public LazyOrderedSet<E> symmetricDifference(LazyOrderedSet<E> s) {
        return this.union(s).subtract(this.intersection(s));
    }

    public LazyOrderedSet<?> flatten() {
        final LazyOrderedSet inner = this;
        return new LazyOrderedSet<Object>(new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new LazyCollection.FlattenSetIterator(inner);
            }
        });
    }

    public LazyOrderedSet<E> append(E object) {
        return new AppendOrderedSet<E>(object, this);
    }

    public LazyOrderedSet<E> prepend(E object) {
        return new PrependOrderedSet<E>(object, this);
    }

    public LazyOrderedSet<E> insertAt(int index, E object) {
        return new InsertAtOrderedSet<E>(object, index - 1, this);
    }

    public LazyOrderedSet<E> subSequence(int lower, int upper) {
        return new SubOrderedSet(lower - 1, upper, this);
    }

    public LazyOrderedSet<E> reverse() {
        return new ReverseOrderedSet(this);
    }

    @Override
    public LazyOrderedSet<E> asOrderedSet() {
        return this;
    }

    public LazyOrderedSet<E> select(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SelectIterator(this, condition, parentFrame);
            }
        };
    }

    public LazyOrderedSet<E> reject(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        return new LazyOrderedSet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.RejectIterator(this, condition, parentFrame);
            }
        };
    }

    public <T> LazyList<T> collect(final CodeBlock function) {
        final StackFrame parentFrame = function.getParentFrame();
        final LazyOrderedSet inner = this;
        return new LazyList(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LazyCollection.CollectIterator(inner, function, parentFrame);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AppendOrderedSet<E>
    extends NonCachingOrderedSet<E> {
        protected final E object;
        protected boolean containsObject;
        protected boolean containsObjectSet;

        public AppendOrderedSet(E object, LazyOrderedSet<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public boolean contains(Object o) {
            return !(this.object == null ? o != null : !this.object.equals(o)) || ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(E o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 1 : ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new AppendOrderedSetIterator();
        }

        @Override
        public int size() {
            int size = ((Collection)this.dataSource).size();
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            return size + (this.containsObject ? 0 : 1);
        }

        @Override
        public E last() {
            return ((List)this.dataSource).get(this.size() - 1);
        }

        @Override
        public E get(int index) {
            int size = ((Collection)this.dataSource).size();
            if (index < size) {
                return ((List)this.dataSource).get(index);
            }
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            if (index == size && !this.containsObject) {
                return this.object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int indexOf(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            if (index >= 0) {
                return index;
            }
            assert (index == -1);
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            if (!this.containsObject && (this.object == null ? o == null : this.object.equals(o))) {
                return ((Collection)this.dataSource).size();
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new AppendOrderedSetListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new AppendOrderedSetListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AppendOrderedSetIterator
        extends LazyCollection.WrappedIterator {
            protected boolean beforeTail;
            protected boolean innerNext;

            public AppendOrderedSetIterator() {
                super(AppendOrderedSet.this);
                this.beforeTail = true;
            }

            @Override
            public boolean hasNext() {
                if (!AppendOrderedSet.this.containsObjectSet) {
                    AppendOrderedSet.this.containsObject = ((Collection)AppendOrderedSet.this.dataSource).contains(AppendOrderedSet.this.object);
                    AppendOrderedSet.this.containsObjectSet = true;
                }
                assert (AppendOrderedSet.this.containsObjectSet);
                return this.beforeTail && !AppendOrderedSet.this.containsObject || (this.innerNext = this.inner.hasNext());
            }

            @Override
            public E next() {
                if (this.innerNext || this.inner.hasNext()) {
                    this.innerNext = false;
                    return this.inner.next();
                }
                if (this.beforeTail) {
                    if (!AppendOrderedSet.this.containsObjectSet) {
                        AppendOrderedSet.this.containsObject = ((Collection)AppendOrderedSet.this.dataSource).contains(AppendOrderedSet.this.object);
                        AppendOrderedSet.this.containsObjectSet = true;
                    }
                    assert (AppendOrderedSet.this.containsObjectSet);
                    if (!AppendOrderedSet.this.containsObject) {
                        this.beforeTail = false;
                        return AppendOrderedSet.this.object;
                    }
                }
                throw new NoSuchElementException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AppendOrderedSetListIterator
        extends LazyCollection.WrappedListIterator {
            protected boolean beforeTail;
            protected boolean innerNext;

            public AppendOrderedSetListIterator() {
                super(AppendOrderedSet.this);
                this.beforeTail = true;
            }

            public AppendOrderedSetListIterator(int index) {
                super(AppendOrderedSet.this, index > 0 ? index - 1 : index);
                this.beforeTail = true;
                if (index > 0) {
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                if (!AppendOrderedSet.this.containsObjectSet) {
                    AppendOrderedSet.this.containsObject = ((Collection)AppendOrderedSet.this.dataSource).contains(AppendOrderedSet.this.object);
                    AppendOrderedSet.this.containsObjectSet = true;
                }
                assert (AppendOrderedSet.this.containsObjectSet);
                return this.beforeTail && !AppendOrderedSet.this.containsObject || (this.innerNext = this.inner.hasNext());
            }

            @Override
            public E next() {
                if (this.innerNext || this.inner.hasNext()) {
                    this.innerNext = false;
                    return this.inner.next();
                }
                if (this.beforeTail) {
                    if (!AppendOrderedSet.this.containsObjectSet) {
                        AppendOrderedSet.this.containsObject = ((Collection)AppendOrderedSet.this.dataSource).contains(AppendOrderedSet.this.object);
                        AppendOrderedSet.this.containsObjectSet = true;
                    }
                    assert (AppendOrderedSet.this.containsObjectSet);
                    if (!AppendOrderedSet.this.containsObject) {
                        this.beforeTail = false;
                        return AppendOrderedSet.this.object;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                assert (this.beforeTail || AppendOrderedSet.this.containsObjectSet && !AppendOrderedSet.this.containsObject);
                return this.inner.nextIndex() + (this.beforeTail ? 0 : 1);
            }

            @Override
            public boolean hasPrevious() {
                assert (this.beforeTail || AppendOrderedSet.this.containsObjectSet && !AppendOrderedSet.this.containsObject);
                return !this.beforeTail || this.inner.hasPrevious();
            }

            @Override
            public E previous() {
                assert (this.beforeTail || AppendOrderedSet.this.containsObjectSet && !AppendOrderedSet.this.containsObject);
                if (!this.beforeTail) {
                    this.beforeTail = true;
                    return AppendOrderedSet.this.object;
                }
                return this.inner.previous();
            }

            @Override
            public int previousIndex() {
                assert (this.beforeTail || AppendOrderedSet.this.containsObjectSet && !AppendOrderedSet.this.containsObject);
                return this.inner.previousIndex() + (this.beforeTail ? 0 : 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcludingOrderedSet<E>
    extends NonCachingOrderedSet<E> {
        protected final E object;
        protected int excludedIndex;
        protected boolean excludedIndexSet;

        public ExcludingOrderedSet(E object, LazyOrderedSet<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public boolean contains(Object o) {
            return (this.object == null ? o != null : !this.object.equals(o)) && ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(E o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 0 : ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.excludedIndexSet && this.excludedIndex < 0) {
                return ((Collection)this.dataSource).iterator();
            }
            return new ExcludingOrderedSetIterator();
        }

        @Override
        public int size() {
            int size = ((Collection)this.dataSource).size();
            if (!this.excludedIndexSet) {
                this.excludedIndex = ((List)this.dataSource).indexOf(this.object);
                this.excludedIndexSet = true;
            }
            assert (this.excludedIndexSet);
            return size - (this.excludedIndex > -1 ? 1 : 0);
        }

        @Override
        public E first() {
            return this.iterator().next();
        }

        @Override
        public E last() {
            if (!this.excludedIndexSet) {
                this.excludedIndex = ((List)this.dataSource).indexOf(this.object);
                this.excludedIndexSet = true;
            }
            assert (this.excludedIndexSet);
            int size = ((Collection)this.dataSource).size();
            return ((List)this.dataSource).get(size - (this.excludedIndex == size - 1 ? 2 : 1));
        }

        @Override
        public E get(int index) {
            if (!this.excludedIndexSet) {
                this.excludedIndex = ((List)this.dataSource).indexOf(this.object);
                this.excludedIndexSet = true;
            }
            assert (this.excludedIndexSet);
            if (index < this.excludedIndex || this.excludedIndex < 0) {
                return ((List)this.dataSource).get(index);
            }
            assert (this.excludedIndex >= 0);
            return ((List)this.dataSource).get(index + 1);
        }

        @Override
        public int indexOf(Object o) {
            if (this.object == null ? o == null : this.object.equals(o)) {
                return -1;
            }
            if (!this.excludedIndexSet) {
                this.excludedIndex = ((List)this.dataSource).indexOf(this.object);
                this.excludedIndexSet = true;
            }
            assert (this.excludedIndexSet);
            int index = ((List)this.dataSource).indexOf(o);
            if (index < this.excludedIndex || this.excludedIndex < 0) {
                return index;
            }
            assert (this.excludedIndex >= 0);
            return index > -1 ? index - 1 : -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            if (this.excludedIndexSet && this.excludedIndex < 0) {
                return ((List)this.dataSource).listIterator();
            }
            return new ExcludingOrderedSetListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (this.excludedIndexSet && this.excludedIndex < 0) {
                return ((List)this.dataSource).listIterator(index);
            }
            return new ExcludingOrderedSetListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ExcludingOrderedSetIterator
        extends LazyCollection.WrappedIterator {
            protected int i;
            protected E next;
            protected boolean nextSet;

            public ExcludingOrderedSetIterator() {
                super(ExcludingOrderedSet.this);
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (ExcludingOrderedSet.this.excludedIndexSet) {
                    return this.i < ExcludingOrderedSet.this.excludedIndex || this.inner.hasNext();
                }
                if (!this.nextSet && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.nextSet = true;
                }
                if (this.nextSet && (ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next))) {
                    ExcludingOrderedSet.this.excludedIndex = this.i + 1;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                    if (this.inner.hasNext()) {
                        this.next = this.inner.next();
                        assert (!(ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next)));
                    }
                }
                boolean bl = this.nextSet && (ExcludingOrderedSet.this.object == null ? this.next != null : !ExcludingOrderedSet.this.object.equals(this.next)) ? true : (hasNext = false);
                if (!hasNext && !ExcludingOrderedSet.this.excludedIndexSet) {
                    ExcludingOrderedSet.this.excludedIndex = -1;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                }
                return hasNext;
            }

            @Override
            public E next() {
                ++this.i;
                if (ExcludingOrderedSet.this.excludedIndexSet) {
                    if (this.i == ExcludingOrderedSet.this.excludedIndex) {
                        if (this.nextSet) {
                            this.nextSet = false;
                        } else {
                            this.inner.next();
                        }
                        assert (!this.nextSet);
                    }
                    if (this.nextSet) {
                        this.nextSet = false;
                        return this.next;
                    }
                    return this.inner.next();
                }
                if (!this.nextSet) {
                    this.next = this.inner.next();
                } else {
                    this.nextSet = false;
                }
                if (ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next)) {
                    ExcludingOrderedSet.this.excludedIndex = this.i;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                    this.next = this.inner.next();
                }
                assert (!this.nextSet && !(ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next)));
                return this.next;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ExcludingOrderedSetListIterator
        extends LazyCollection.WrappedListIterator {
            protected int i;
            protected E next;
            protected boolean nextSet;
            protected E prev;
            protected boolean prevSet;

            public ExcludingOrderedSetListIterator() {
                super(ExcludingOrderedSet.this);
                this.i = -1;
            }

            public ExcludingOrderedSetListIterator(int index) {
                super(ExcludingOrderedSet.this, index > 0 ? index - 1 : index);
                this.i = -1;
                if (index > 0) {
                    this.i = index - 2;
                    this.next();
                } else {
                    this.i = index - 1;
                }
            }

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (ExcludingOrderedSet.this.excludedIndexSet) {
                    return this.i < ExcludingOrderedSet.this.excludedIndex || this.inner.hasNext();
                }
                if (!this.nextSet && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.nextSet = true;
                }
                if (this.nextSet && (ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next))) {
                    ExcludingOrderedSet.this.excludedIndex = this.i + 1;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                    if (this.inner.hasNext()) {
                        this.next = this.inner.next();
                        assert (!(ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next)));
                    }
                }
                boolean bl = this.nextSet && (ExcludingOrderedSet.this.object == null ? this.next != null : !ExcludingOrderedSet.this.object.equals(this.next)) ? true : (hasNext = false);
                if (!hasNext && !ExcludingOrderedSet.this.excludedIndexSet) {
                    ExcludingOrderedSet.this.excludedIndex = -1;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                }
                return hasNext;
            }

            @Override
            public E next() {
                ++this.i;
                if (ExcludingOrderedSet.this.excludedIndexSet) {
                    if (this.i == ExcludingOrderedSet.this.excludedIndex) {
                        if (this.nextSet) {
                            this.nextSet = false;
                            assert (!this.nextSet);
                        } else {
                            this.inner.next();
                        }
                    }
                    if (this.nextSet) {
                        this.nextSet = false;
                        return this.next;
                    }
                    return this.inner.next();
                }
                if (!this.nextSet) {
                    this.next = this.inner.next();
                } else {
                    this.nextSet = false;
                }
                if (ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next)) {
                    ExcludingOrderedSet.this.excludedIndex = this.i;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                    this.next = this.inner.next();
                }
                assert (!this.nextSet && !(ExcludingOrderedSet.this.object == null ? this.next == null : ExcludingOrderedSet.this.object.equals(this.next)));
                return this.next;
            }

            @Override
            public int nextIndex() {
                return this.i + 1;
            }

            @Override
            public boolean hasPrevious() {
                boolean hasPrev;
                if (ExcludingOrderedSet.this.excludedIndexSet) {
                    return this.i > ExcludingOrderedSet.this.excludedIndex || this.inner.hasPrevious();
                }
                if (!this.prevSet && this.inner.hasPrevious()) {
                    this.prev = this.inner.previous();
                    this.prevSet = true;
                }
                if (this.prevSet && (ExcludingOrderedSet.this.object == null ? this.prev == null : ExcludingOrderedSet.this.object.equals(this.prev))) {
                    ExcludingOrderedSet.this.excludedIndex = this.i;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                    if (this.inner.hasPrevious()) {
                        this.prev = this.inner.previous();
                        assert (!(ExcludingOrderedSet.this.object == null ? this.prev == null : ExcludingOrderedSet.this.object.equals(this.prev)));
                    }
                }
                boolean bl = this.prevSet && (ExcludingOrderedSet.this.object == null ? this.prev != null : !ExcludingOrderedSet.this.object.equals(this.prev)) ? true : (hasPrev = false);
                if (!hasPrev && !ExcludingOrderedSet.this.excludedIndexSet) {
                    ExcludingOrderedSet.this.excludedIndex = -1;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                }
                return hasPrev;
            }

            @Override
            public E previous() {
                if (ExcludingOrderedSet.this.excludedIndexSet) {
                    if (this.i == ExcludingOrderedSet.this.excludedIndex) {
                        if (this.prevSet) {
                            this.prevSet = false;
                            assert (!this.prevSet);
                        } else {
                            this.inner.previous();
                        }
                    }
                    --this.i;
                    if (this.prevSet) {
                        this.prevSet = false;
                        return this.prev;
                    }
                    return this.inner.previous();
                }
                if (!this.prevSet) {
                    this.prev = this.inner.previous();
                } else {
                    this.prevSet = false;
                }
                if (ExcludingOrderedSet.this.object == null ? this.prev == null : ExcludingOrderedSet.this.object.equals(this.prev)) {
                    ExcludingOrderedSet.this.excludedIndex = this.i;
                    ExcludingOrderedSet.this.excludedIndexSet = true;
                    this.prev = this.inner.previous();
                }
                assert (!this.prevSet && !(ExcludingOrderedSet.this.object == null ? this.prev == null : ExcludingOrderedSet.this.object.equals(this.prev)));
                --this.i;
                return this.prev;
            }

            @Override
            public int previousIndex() {
                return this.i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InsertAtOrderedSet<E>
    extends AppendOrderedSet<E> {
        protected final int index;

        public InsertAtOrderedSet(E object, int index, LazyOrderedSet<E> dataSource) {
            super(object, dataSource);
            this.index = index;
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new InsertAtOrderedSetIterator();
        }

        @Override
        public E first() {
            assert (this.index >= 0);
            if (this.index == 0) {
                if (!this.containsObjectSet) {
                    this.containsObject = ((Collection)this.dataSource).contains(this.object);
                    this.containsObjectSet = true;
                }
                assert (this.containsObjectSet);
                if (!this.containsObject) {
                    return (E)this.object;
                }
            }
            return ((LazyList)this.dataSource).first();
        }

        @Override
        public E last() {
            int size = ((Collection)this.dataSource).size();
            if (this.index < size) {
                return ((LazyList)this.dataSource).last();
            }
            if (this.index == size) {
                if (!this.containsObjectSet) {
                    this.containsObject = ((Collection)this.dataSource).contains(this.object);
                    this.containsObjectSet = true;
                }
                assert (this.containsObjectSet);
                if (!this.containsObject) {
                    return (E)this.object;
                }
                return ((LazyList)this.dataSource).last();
            }
            throw new IndexOutOfBoundsException(String.valueOf(this.index));
        }

        @Override
        public E get(int index) {
            int size = ((List)this.dataSource).size();
            if (index < size) {
                if (index < this.index) {
                    return ((List)this.dataSource).get(index);
                }
                if (index == this.index) {
                    if (!this.containsObjectSet) {
                        this.containsObject = ((Collection)this.dataSource).contains(this.object);
                        this.containsObjectSet = true;
                    }
                    assert (this.containsObjectSet);
                    if (!this.containsObject) {
                        return (E)this.object;
                    }
                    return ((List)this.dataSource).get(index);
                }
                assert (this.index >= 0);
                assert (index > this.index);
                if (!this.containsObjectSet) {
                    this.containsObject = ((Collection)this.dataSource).contains(this.object);
                    this.containsObjectSet = true;
                }
                assert (this.containsObjectSet);
                return ((List)this.dataSource).get(this.containsObject ? index : index - 1);
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public int indexOf(Object o) {
            int indexOf = ((List)this.dataSource).indexOf(o);
            if (indexOf > -1) {
                assert (this.index >= 0);
                if (indexOf > this.index && (this.object == null ? o == null : this.object.equals(o))) {
                    if (!this.containsObjectSet) {
                        this.containsObject = ((Collection)this.dataSource).contains(this.object);
                        this.containsObjectSet = true;
                    }
                    assert (this.containsObjectSet);
                    if (!this.containsObject) {
                        return this.index;
                    }
                }
                return indexOf;
            }
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            if (!this.containsObject && (this.object == null ? o == null : this.object.equals(o))) {
                if (this.index <= ((Collection)this.dataSource).size()) {
                    return this.index;
                }
                throw new IndexOutOfBoundsException(String.valueOf(this.index));
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new InsertAtOrderedSetListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new InsertAtOrderedSetListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InsertAtOrderedSetIterator
        extends LazyCollection.WrappedIterator {
            protected int i;

            public InsertAtOrderedSetIterator() {
                super(InsertAtOrderedSet.this);
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                return this.i < InsertAtOrderedSet.this.index || this.inner.hasNext();
            }

            @Override
            public E next() {
                if (++this.i == InsertAtOrderedSet.this.index) {
                    if (!InsertAtOrderedSet.this.containsObjectSet) {
                        InsertAtOrderedSet.this.containsObject = ((Collection)InsertAtOrderedSet.this.dataSource).contains(InsertAtOrderedSet.this.object);
                        InsertAtOrderedSet.this.containsObjectSet = true;
                    }
                    assert (InsertAtOrderedSet.this.containsObjectSet);
                    if (!InsertAtOrderedSet.this.containsObject) {
                        return InsertAtOrderedSet.this.object;
                    }
                }
                return this.inner.next();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InsertAtOrderedSetListIterator
        extends LazyCollection.WrappedListIterator {
            protected int i;
            protected boolean innerNext;

            public InsertAtOrderedSetListIterator() {
                super(InsertAtOrderedSet.this);
                this.i = -1;
            }

            public InsertAtOrderedSetListIterator(int index) {
                super(InsertAtOrderedSet.this, index > 0 ? index - 1 : index);
                this.i = -1;
                assert (index >= 0);
                if (index > 0) {
                    this.i = index - 2;
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.i < InsertAtOrderedSet.this.index || this.inner.hasNext();
            }

            @Override
            public E next() {
                if (++this.i == InsertAtOrderedSet.this.index) {
                    if (!InsertAtOrderedSet.this.containsObjectSet) {
                        InsertAtOrderedSet.this.containsObject = ((Collection)InsertAtOrderedSet.this.dataSource).contains(InsertAtOrderedSet.this.object);
                        InsertAtOrderedSet.this.containsObjectSet = true;
                    }
                    assert (InsertAtOrderedSet.this.containsObjectSet);
                    if (!InsertAtOrderedSet.this.containsObject) {
                        return InsertAtOrderedSet.this.object;
                    }
                }
                return this.inner.next();
            }

            @Override
            public int nextIndex() {
                return this.i + 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.i >= InsertAtOrderedSet.this.index || this.inner.hasPrevious();
            }

            @Override
            public E previous() {
                if (this.i-- == InsertAtOrderedSet.this.index) {
                    if (!InsertAtOrderedSet.this.containsObjectSet) {
                        InsertAtOrderedSet.this.containsObject = ((Collection)InsertAtOrderedSet.this.dataSource).contains(InsertAtOrderedSet.this.object);
                        InsertAtOrderedSet.this.containsObjectSet = true;
                    }
                    assert (InsertAtOrderedSet.this.containsObjectSet);
                    if (!InsertAtOrderedSet.this.containsObject) {
                        return InsertAtOrderedSet.this.object;
                    }
                }
                return this.inner.previous();
            }

            @Override
            public int previousIndex() {
                return this.i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NonCachingOrderedSet<E>
    extends LazyOrderedSet<E> {
        public NonCachingOrderedSet(LazyOrderedSet<E> dataSource) {
            super(dataSource);
            assert (dataSource != null);
        }

        @Override
        protected void createCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrependOrderedSet<E>
    extends AppendOrderedSet<E> {
        public PrependOrderedSet(E object, LazyOrderedSet<E> dataSource) {
            super(object, dataSource);
        }

        @Override
        public Iterator<E> iterator() {
            return new PrependOrderedSetIterator();
        }

        @Override
        public E first() {
            return ((List)this.dataSource).get(this.size() - 1);
        }

        @Override
        public E last() {
            if (!((LazyOrderedSet)this.dataSource).isEmpty()) {
                return ((LazyOrderedSet)this.dataSource).last();
            }
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            if (!this.containsObject) {
                return (E)this.object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public E get(int index) {
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            if (!this.containsObject) {
                if (index == 0) {
                    return (E)this.object;
                }
                return ((List)this.dataSource).get(index - 1);
            }
            return ((List)this.dataSource).get(index);
        }

        @Override
        public int indexOf(Object o) {
            if (!this.containsObjectSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsObjectSet = true;
            }
            assert (this.containsObjectSet);
            if (this.containsObject) {
                return ((List)this.dataSource).indexOf(o);
            }
            if (this.object == null ? o == null : this.object.equals(o)) {
                return 0;
            }
            int index = ((List)this.dataSource).indexOf(o);
            return index > -1 ? index + 1 : -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new PrependOrderedSetListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new PrependOrderedSetListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PrependOrderedSetIterator
        extends LazyCollection.WrappedIterator {
            protected boolean beforeHead;

            public PrependOrderedSetIterator() {
                super(PrependOrderedSet.this);
                if (!PrependOrderedSet.this.containsObjectSet) {
                    PrependOrderedSet.this.containsObject = ((Collection)PrependOrderedSet.this.dataSource).contains(PrependOrderedSet.this.object);
                    PrependOrderedSet.this.containsObjectSet = true;
                }
                assert (PrependOrderedSet.this.containsObjectSet);
                this.beforeHead = !PrependOrderedSet.this.containsObject;
            }

            @Override
            public boolean hasNext() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                return this.beforeHead || this.inner.hasNext();
            }

            @Override
            public E next() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                if (this.beforeHead) {
                    this.beforeHead = false;
                    return PrependOrderedSet.this.object;
                }
                return this.inner.next();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PrependOrderedSetListIterator
        extends LazyCollection.WrappedListIterator {
            protected boolean beforeHead;
            protected boolean innerPrev;

            public PrependOrderedSetListIterator() {
                super(PrependOrderedSet.this);
                if (!PrependOrderedSet.this.containsObjectSet) {
                    PrependOrderedSet.this.containsObject = ((Collection)PrependOrderedSet.this.dataSource).contains(PrependOrderedSet.this.object);
                    PrependOrderedSet.this.containsObjectSet = true;
                }
                assert (PrependOrderedSet.this.containsObjectSet);
                this.beforeHead = !PrependOrderedSet.this.containsObject;
            }

            public PrependOrderedSetListIterator(int index) {
                super(PrependOrderedSet.this, index > 0 ? index - 1 : index);
                if (!PrependOrderedSet.this.containsObjectSet) {
                    PrependOrderedSet.this.containsObject = ((Collection)PrependOrderedSet.this.dataSource).contains(PrependOrderedSet.this.object);
                    PrependOrderedSet.this.containsObjectSet = true;
                }
                assert (PrependOrderedSet.this.containsObjectSet);
                boolean bl = this.beforeHead = !PrependOrderedSet.this.containsObject && index == 0;
                if (index > 0) {
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                return this.beforeHead || this.inner.hasNext();
            }

            @Override
            public E next() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                if (this.beforeHead) {
                    this.beforeHead = false;
                    return PrependOrderedSet.this.object;
                }
                return this.inner.next();
            }

            @Override
            public int nextIndex() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                if (this.beforeHead) {
                    return 0;
                }
                return this.inner.nextIndex() + (PrependOrderedSet.this.containsObject ? 0 : 1);
            }

            @Override
            public boolean hasPrevious() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                assert (this.beforeHead || !this.inner.hasPrevious());
                return !this.beforeHead && (!PrependOrderedSet.this.containsObject || (this.innerPrev = this.inner.hasPrevious()));
            }

            @Override
            public E previous() {
                assert (PrependOrderedSet.this.containsObjectSet);
                if (this.innerPrev || this.inner.hasPrevious()) {
                    this.innerPrev = false;
                    return this.inner.previous();
                }
                if (!this.beforeHead && !PrependOrderedSet.this.containsObject) {
                    this.beforeHead = true;
                    return PrependOrderedSet.this.object;
                }
                throw new NoSuchElementException();
            }

            @Override
            public int previousIndex() {
                assert (PrependOrderedSet.this.containsObjectSet);
                assert (!this.beforeHead || !PrependOrderedSet.this.containsObject);
                if (this.beforeHead) {
                    return -1;
                }
                return this.inner.previousIndex() + (PrependOrderedSet.this.containsObject ? 0 : 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseOrderedSet<E>
    extends NonCachingOrderedSet<E> {
        protected final int last;

        public ReverseOrderedSet(LazyOrderedSet<E> dataSource) {
            super(dataSource);
            this.last = dataSource.size() - 1;
        }

        @Override
        public E first() {
            return ((List)this.dataSource).get(this.last);
        }

        @Override
        public E last() {
            return ((List)this.dataSource).get(0);
        }

        @Override
        public E get(int index) {
            return ((List)this.dataSource).get(this.last - index);
        }

        @Override
        public int indexOf(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            if (index > -1) {
                return this.last - index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = ((List)this.dataSource).lastIndexOf(o);
            if (index > -1) {
                return this.last - index;
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return ((List)this.dataSource).contains(o);
        }

        @Override
        public boolean isEmpty() {
            return ((List)this.dataSource).isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.ReverseIterator(this, this.last);
        }

        @Override
        public int size() {
            return this.last + 1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new LazyCollection.ReverseListIterator(this, this.last);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new LazyCollection.ReverseListIterator(this, this.last, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubOrderedSet<E>
    extends NonCachingOrderedSet<E> {
        protected final int fromIndex;
        protected final int toIndex;

        public SubOrderedSet(int fromIndex, int toIndex, LazyOrderedSet<E> dataSource) {
            super(dataSource);
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            if (fromIndex < 0 || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(fromIndex)) + " - " + String.valueOf(toIndex));
            }
        }

        @Override
        public E first() {
            return ((List)this.dataSource).get(this.fromIndex);
        }

        @Override
        public E last() {
            return ((List)this.dataSource).get(this.toIndex - 1);
        }

        @Override
        public E get(int index) {
            return ((List)this.dataSource).get(index + this.fromIndex);
        }

        @Override
        public int indexOf(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            if (index >= this.fromIndex && index < this.toIndex) {
                return index - this.fromIndex;
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            return index >= this.fromIndex && index < this.toIndex;
        }

        @Override
        public boolean isEmpty() {
            return this.fromIndex < this.toIndex;
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.SubListIterator(this, this.fromIndex, this.toIndex);
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new LazyCollection.SubListListIterator(this, this.fromIndex, this.toIndex);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new LazyCollection.SubListListIterator(this, this.fromIndex, this.toIndex, index);
        }
    }
}

