/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.LocalVariable;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TargetElement;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyBagOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazySetOnSet;
import org.eclipse.m2m.atl.emftvm.util.NativeCodeBlock;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.ResourceIterable;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;

public final class OCLOperations {
    public static final String OCL_MODEL = "#native";
    public static final String ECORE_MODEL = "ecore".toUpperCase();
    public static final String EMFTVM_MODEL = "emftvm".toUpperCase();
    static final String[] OCL_ANY_TYPE = new String[]{"#native", NativeTypes.NativeType.OBJECT.getName()};
    static final String[] BOOLEAN_TYPE = new String[]{"#native", NativeTypes.NativeType.BOOLEAN.getName()};
    static final String[] REAL_TYPE = new String[]{"#native", NativeTypes.NativeType.REAL.getName()};
    static final String[] INTEGER_TYPE = new String[]{"#native", NativeTypes.NativeType.INTEGER.getName()};
    static final String[] STRING_TYPE = new String[]{"#native", NativeTypes.NativeType.STRING.getName()};
    static final String[] JAVA_CLASS_TYPE = new String[]{"#native", "java.lang.Class"};
    static final String[] JAVA_COLLECTION_TYPE = new String[]{"#native", "java.util.Collection"};
    static final String[] JAVA_LIST_TYPE = new String[]{"#native", "java.util.List"};
    static final String[] COLLECTION_TYPE = new String[]{"#native", NativeTypes.NativeType.COLLECTION.getName()};
    static final String[] BAG_TYPE = new String[]{"#native", NativeTypes.NativeType.BAG.getName()};
    static final String[] SEQUENCE_TYPE = new String[]{"#native", NativeTypes.NativeType.SEQUENCE.getName()};
    static final String[] SET_TYPE = new String[]{"#native", NativeTypes.NativeType.SET.getName()};
    static final String[] ORDERED_SET_TYPE = new String[]{"#native", NativeTypes.NativeType.ORDERED_SET.getName()};
    static final String[] MAP_TYPE = new String[]{"#native", NativeTypes.NativeType.MAP.getName()};
    static final String[] CLASSIFIER_TYPE = new String[]{ECORE_MODEL, "EClassifier"};
    static final String[] CLASS_TYPE = new String[]{ECORE_MODEL, "EClass"};
    static final String[] EXEC_ENV_TYPE = new String[]{EMFTVM_MODEL, "ExecEnv"};
    private static OCLOperations instance;
    private final EmftvmFactory factory = EmftvmFactory.eINSTANCE;
    private final Module oclModule = this.factory.createModule();

    private OCLOperations() {
        this.oclModule.setName("OCL");
        this.createOperations();
    }

    public static OCLOperations getInstance() {
        if (instance == null) {
            instance = new OCLOperations();
        }
        return instance;
    }

    private void createOperations() {
        this.createOperation(false, "debug", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"message"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                StringBuffer buf = new StringBuffer((String)frame.getLocal(0, 1));
                buf.append(": ");
                if (object instanceof String) {
                    buf.append('\'');
                    buf.append((String)object);
                    buf.append('\'');
                } else if (object instanceof LazyCollection) {
                    buf.append(((LazyCollection)object).asString());
                } else {
                    buf.append(object);
                }
                ATLLogger.info((String)buf.toString());
                frame.push(object);
                return frame;
            }
        });
        this.createOperation(false, "oclAsType", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"type"}, CLASSIFIER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                EClassifier type = (EClassifier)frame.getLocal(0, 1);
                if (!type.isInstance(object)) {
                    throw new IllegalArgumentException(String.format("%s is not an instance of %s", object, type));
                }
                frame.push(object);
                return frame;
            }
        });
        this.createOperation(false, "oclAsType", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"type"}, JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                Class type = (Class)frame.getLocal(0, 1);
                if (!type.isInstance(object)) {
                    throw new IllegalArgumentException(String.format("%s is not an instance of %s", object, type));
                }
                frame.push(object);
                return frame;
            }
        });
        this.createOperation(false, "oclIsTypeOf", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, CLASSIFIER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                EClassifier type = (EClassifier)frame.getLocal(0, 1);
                if (type instanceof EClass && o instanceof EObject) {
                    frame.push(((EObject)o).eClass() == type);
                } else if (o != null) {
                    Class ic = type.getInstanceClass();
                    if (ic == null) {
                        throw new IllegalArgumentException(String.format("EClassifier %s must have an instance class", type));
                    }
                    frame.push(o.getClass() == ic);
                } else {
                    frame.push(false);
                }
                return frame;
            }
        });
        this.createOperation(false, "oclIsTypeOf", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Class type = (Class)frame.getLocal(0, 1);
                frame.push(o != null ? o.getClass() == type : false);
                return frame;
            }
        });
        this.createOperation(false, "oclIsKindOf", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, CLASSIFIER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                EClassifier type = (EClassifier)frame.getLocal(0, 1);
                frame.push(type.isInstance(o));
                return frame;
            }
        });
        this.createOperation(false, "oclIsKindOf", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Class type = (Class)frame.getLocal(0, 1);
                frame.push(type.isInstance(o));
                return frame;
            }
        });
        this.createOperation(false, "oclType", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                if (o instanceof EObject) {
                    frame.push(((EObject)o).eClass());
                } else if (o != null) {
                    frame.push(o.getClass());
                } else {
                    frame.push(Void.TYPE);
                }
                return frame;
            }
        });
        this.createOperation(false, "=", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                frame.push(o == null ? o2 == null : o.equals(o2));
                return frame;
            }
        });
        this.createOperation(false, "=~", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                frame.push(o == null ? o2 == null : o.equals(o2));
                return frame;
            }
        });
        this.createOperation(false, "=~|", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                frame.push(o == null ? o2 == null : o.equals(o2));
                return frame;
            }
        });
        this.createOperation(false, "<>", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                frame.push(!(o == null ? o2 == null : o.equals(o2)));
                return frame;
            }
        });
        this.createOperation(false, "isInModel", OCL_ANY_TYPE, BOOLEAN_TYPE, new String[][][]{{{"model"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                if (o instanceof EObject) {
                    String mName = (String)frame.getLocal(0, 1);
                    ExecEnv env = frame.getEnv();
                    Model model = env.getInputModels().get(mName);
                    if (model == null) {
                        model = env.getInoutModels().get(mName);
                    }
                    if (model == null) {
                        model = env.getOutputModels().get(mName);
                    }
                    if (model != null) {
                        frame.push(model.getResource() == ((EObject)o).eResource());
                    } else {
                        frame.push(false);
                    }
                } else {
                    frame.push(false);
                }
                return frame;
            }
        });
        this.createOperation(false, "refImmediateComposite", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    frame.push(((EObject)object).eContainer());
                    return frame;
                }
                throw new VMException(frame, String.format("Cannot retrieve immediate composite for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refGetValue", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"propname"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    String propname = (String)frame.getLocal(0, 1);
                    EObject eo = (EObject)object;
                    EClass ecls = eo.eClass();
                    EStructuralFeature sf = ecls.getEStructuralFeature(propname);
                    if (sf == null) {
                        throw new VMException(frame, String.format("Cannot find property %s::%s", ecls.getName(), propname));
                    }
                    frame.push(((EObject)object).eGet(sf));
                    return frame;
                }
                throw new VMException(frame, String.format("Cannot retrieve properties for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refSetValue", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"propname"}, STRING_TYPE}, {{"value"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    String propname = (String)frame.getLocal(0, 1);
                    Object value = frame.getLocal(0, 2);
                    EObject eo = (EObject)object;
                    EClass ecls = eo.eClass();
                    EStructuralFeature sf = ecls.getEStructuralFeature(propname);
                    if (sf == null) {
                        throw new VMException(frame, String.format("Cannot find property %s::%s", ecls.getName(), propname));
                    }
                    ((EObject)object).eSet(sf, value);
                    frame.push(null);
                    return frame;
                }
                throw new VMException(frame, String.format("Cannot set properties for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refUnsetValue", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"propname"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    String propname = (String)frame.getLocal(0, 1);
                    EObject eo = (EObject)object;
                    EClass ecls = eo.eClass();
                    EStructuralFeature sf = ecls.getEStructuralFeature(propname);
                    if (sf == null) {
                        throw new VMException(frame, String.format("Cannot find property %s::%s", ecls.getName(), propname));
                    }
                    ((EObject)object).eUnset(sf);
                    frame.push(null);
                    return frame;
                }
                throw new VMException(frame, String.format("Cannot set properties for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refInvokeOperation", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"opname"}, STRING_TYPE}, {{"arguments"}, SEQUENCE_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                String opname = (String)frame.getLocal(0, 1);
                List args = (List)frame.getLocal(0, 2);
                frame.push(EMFTVMUtil.invokeNative(frame, object, opname, args.toArray()));
                return frame;
            }
        });
        this.createOperation(false, "resolve", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                ExecEnv env;
                Field traces;
                TraceLinkSet tls;
                SourceElement se;
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject && (se = (tls = (TraceLinkSet)(traces = (env = frame.getEnv()).findStaticField(env.eClass(), "traces")).getStaticValue(frame)).getDefaultSourceElement((EObject)object)) != null) {
                    EList seMapsTo = se.getMapsTo();
                    if (!seMapsTo.isEmpty()) {
                        if (!$assertionsDisabled && ((TargetElement)seMapsTo.get(0)).getObject().eResource() == null) {
                            throw new AssertionError();
                        }
                        frame.push(((TargetElement)seMapsTo.get(0)).getObject());
                        return frame;
                    }
                    for (TargetElement te : se.getSourceOf().getTargetElements()) {
                        if (!te.getMapsTo().isEmpty()) continue;
                        if (!$assertionsDisabled && te.getObject().eResource() == null) {
                            throw new AssertionError();
                        }
                        frame.push(te.getObject());
                        return frame;
                    }
                }
                frame.push(object);
                return frame;
            }
        });
        this.createOperation(false, "remap", OCL_ANY_TYPE, OCL_ANY_TYPE, new String[][][]{{{"to"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Object source = frame.getLocal(0, 0);
                Object target = frame.getLocal(0, 1);
                if (source instanceof EObject && source != target) {
                    if (!$assertionsDisabled && !(target instanceof EObject)) {
                        throw new AssertionError();
                    }
                    ExecEnv env = frame.getEnv();
                    for (Model m : env.getInoutModels().values()) {
                        for (EObject o : new ResourceIterable(m.eResource())) {
                            for (EReference ref : o.eClass().getEAllReferences()) {
                                if (!ref.isChangeable()) continue;
                                Object val = o.eGet((EStructuralFeature)ref);
                                if (val instanceof EList) {
                                    int index = ((EList)val).indexOf(source);
                                    if (index <= -1) continue;
                                    EMFTVMUtil.remove(env, o, (EStructuralFeature)ref, source);
                                    EMFTVMUtil.add(env, o, (EStructuralFeature)ref, target, index);
                                    continue;
                                }
                                if (val != source) continue;
                                EMFTVMUtil.set(env, o, (EStructuralFeature)ref, target);
                            }
                        }
                    }
                }
                frame.push(target);
                return frame;
            }
        });
        this.createOperation(false, "toString", COLLECTION_TYPE, STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                LazyCollection coll = (LazyCollection)frame.getLocal(0, 0);
                frame.push(coll.asString());
                return frame;
            }
        });
        this.createOperation(false, "resolve", JAVA_COLLECTION_TYPE, SEQUENCE_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Collection object = (Collection)frame.getLocal(0, 0);
                frame.push(new ResolveList(object, frame));
                return frame;
            }
        });
        this.createOperation(false, "=~", JAVA_COLLECTION_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Collection o = (Collection)frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                if (o2 instanceof Collection) {
                    frame.push(o.containsAll((Collection)o2));
                } else {
                    frame.push(o.contains(o2));
                }
                return frame;
            }
        });
        this.createOperation(false, "=~|", JAVA_COLLECTION_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Collection o = (Collection)frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                if (o2 instanceof Collection) {
                    frame.push(o.containsAll((Collection)o2));
                } else {
                    frame.push(o.contains(o2));
                }
                return frame;
            }
        });
        this.createOperation(false, "=~|", JAVA_LIST_TYPE, BOOLEAN_TYPE, new String[][][]{{{"o"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                List o = (List)frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                if (o2 instanceof Collection) {
                    Collection coll2 = (Collection)o2;
                    int sizediff = o.size() - coll2.size();
                    if (sizediff < 0) {
                        frame.push(false);
                    } else {
                        frame.push(o.subList(sizediff, o.size()).containsAll(coll2));
                    }
                } else if (o.size() > 0) {
                    Object last = o.get(o.size() - 1);
                    frame.push(last == null ? o2 == null : last.equals(o2));
                } else {
                    frame.push(false);
                }
                return frame;
            }
        });
        this.createOperation(false, "including", MAP_TYPE, SET_TYPE, new String[][][]{{{"key"}, OCL_ANY_TYPE}, {{"value"}, OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                HashMap<Object, Object> o = new HashMap<Object, Object>((Map)frame.getLocal(0, 0));
                Object key = frame.getLocal(0, 1);
                Object value = frame.getLocal(0, 2);
                o.put(key, value);
                frame.push(o);
                return frame;
            }
        });
        this.createOperation(false, "getKeys", MAP_TYPE, SET_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Map o = (Map)frame.getLocal(0, 0);
                frame.push(new LazySetOnSet(o.keySet()));
                return frame;
            }
        });
        this.createOperation(false, "getValues", MAP_TYPE, SET_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Map o = (Map)frame.getLocal(0, 0);
                frame.push(new LazyBagOnCollection(o.values()));
                return frame;
            }
        });
        this.createOperation(false, "union", MAP_TYPE, SET_TYPE, new String[][][]{{{"m"}, MAP_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                HashMap o = new HashMap((Map)frame.getLocal(0, 0));
                Map m = (Map)frame.getLocal(0, 1);
                o.putAll(m);
                frame.push(o);
                return frame;
            }
        });
        this.createOperation(true, "resolveTemp", EXEC_ENV_TYPE, OCL_ANY_TYPE, new String[][][]{{{"var"}, OCL_ANY_TYPE}, {{"target_pattern_name"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                ExecEnv env;
                Field traces;
                TraceLinkSet tls;
                SourceElementList sel;
                Object object = frame.getLocal(0, 0);
                String name = (String)frame.getLocal(0, 1);
                if (object instanceof EObject) {
                    TargetElement te;
                    ExecEnv env2 = frame.getEnv();
                    Field traces2 = env2.findStaticField(env2.eClass(), "traces");
                    TraceLinkSet tls2 = (TraceLinkSet)traces2.getStaticValue(frame);
                    SourceElement se = tls2.getDefaultSourceElement((EObject)object);
                    if (se != null && (te = se.getSourceOf().getTargetElement(name)) != null) {
                        frame.push(te.getObject());
                        return frame;
                    }
                } else if (object instanceof List && (sel = (tls = (TraceLinkSet)(traces = (env = frame.getEnv()).findStaticField(env.eClass(), "traces")).getStaticValue(frame)).getDefaultSourceElements((List)object)) != null) {
                    if (!$assertionsDisabled && sel.getSourceElements().isEmpty()) {
                        throw new AssertionError();
                    }
                    TargetElement te = ((SourceElement)sel.getSourceElements().get(0)).getSourceOf().getTargetElement(name);
                    if (te != null) {
                        frame.push(te.getObject());
                        return frame;
                    }
                }
                throw new VMException(frame, String.format("Cannot resolve default trace target '%s' for %s", name, EMFTVMUtil.toPrettyString(object, frame.getEnv())));
            }
        });
        this.createOperation(false, "allInstances", CLASS_TYPE, SEQUENCE_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                frame.push(EMFTVMUtil.findAllInstances(frame.getEnv(), c));
                return frame;
            }
        });
        this.createOperation(false, "allInstancesFrom", CLASS_TYPE, SEQUENCE_TYPE, new String[][][]{{{"metamodel"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                String mm = (String)frame.getLocal(0, 1);
                frame.push(EMFTVMUtil.findAllInstIn(frame.getEnv(), c, mm));
                return frame;
            }
        });
        this.createOperation(false, "conformsTo", CLASS_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                EClass c2 = (EClass)frame.getLocal(0, 1);
                frame.push(c2.isSuperTypeOf(c));
                return frame;
            }
        });
        this.createOperation(false, "conformsTo", CLASS_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                Class c2 = (Class)frame.getLocal(0, 1);
                Class ic = c.getInstanceClass();
                if (ic != null) {
                    frame.push(c2.isAssignableFrom(ic));
                } else {
                    frame.push(c2 == Object.class);
                }
                return frame;
            }
        });
        this.createOperation(false, "newInstance", CLASS_TYPE, OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                frame.push(type.getEPackage().getEFactoryInstance().create(type));
                return frame;
            }
        });
        this.createOperation(false, "newInstanceIn", CLASS_TYPE, OCL_ANY_TYPE, new String[][][]{{{"modelname"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                String modelname = (String)frame.getLocal(0, 1);
                ExecEnv env = frame.getEnv();
                Model model = env.getOutputModels().get(modelname);
                if (model == null) {
                    model = env.getInoutModels().get(modelname);
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Inout/output model %s not found", modelname));
                }
                frame.push(model.newElement(type));
                return frame;
            }
        });
        this.createOperation(false, "getInstanceById", CLASS_TYPE, OCL_ANY_TYPE, new String[][][]{{{"id"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                String id = (String)frame.getLocal(0, 1);
                ExecEnv env = frame.getEnv();
                LazyList<Model> models = new LazyListOnCollection<Model>(env.getInputModels().values()).union(new LazyListOnCollection<Model>(env.getInoutModels().values()));
                for (Model model : models) {
                    EObject instance = model.getResource().getEObject(id);
                    if (!type.isInstance((Object)instance)) continue;
                    frame.push(instance);
                    return frame;
                }
                frame.push(null);
                return frame;
            }
        });
        this.createOperation(false, "getInstanceById", CLASS_TYPE, OCL_ANY_TYPE, new String[][][]{{{"modelname"}, STRING_TYPE}, {{"id"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                String modelname = (String)frame.getLocal(0, 1);
                String id = (String)frame.getLocal(0, 2);
                ExecEnv env = frame.getEnv();
                Model model = env.getInputModels().get(modelname);
                if (model == null) {
                    model = env.getInoutModels().get(modelname);
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Input/inout model %s not found", modelname));
                }
                EObject instance = model.getResource().getEObject(id);
                if (type.isInstance((Object)instance)) {
                    frame.push(instance);
                } else {
                    frame.push(null);
                }
                return frame;
            }
        });
        this.createOperation(false, "conformsTo", JAVA_CLASS_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                EClass c2 = (EClass)frame.getLocal(0, 1);
                Class ic2 = c2.getInstanceClass();
                if (ic2 != null) {
                    frame.push(ic2.isAssignableFrom(c));
                } else {
                    frame.push(false);
                }
                return frame;
            }
        });
        this.createOperation(false, "conformsTo", JAVA_CLASS_TYPE, BOOLEAN_TYPE, new String[][][]{{{"type"}, JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                Class c2 = (Class)frame.getLocal(0, 1);
                frame.push(c2.isAssignableFrom(c));
                return frame;
            }
        });
        this.createOperation(false, "getName", JAVA_CLASS_TYPE, STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                frame.push(NativeTypes.typeName(c));
                return frame;
            }
        });
        this.createOperation(false, "+", REAL_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) + (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "+", REAL_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) + (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "-", REAL_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) - (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "-", REAL_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) - (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "*", REAL_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) * (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "*", REAL_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) * (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "neg", REAL_TYPE, REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(-((Double)frame.getLocal(0, 0)).doubleValue());
                return frame;
            }
        });
        this.createOperation(false, "/", REAL_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) / (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "/", REAL_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) / (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "abs", REAL_TYPE, REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.abs((Double)frame.getLocal(0, 0)));
                return frame;
            }
        });
        this.createOperation(false, "floor", REAL_TYPE, INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Double.valueOf(Math.floor((Double)frame.getLocal(0, 0))).intValue());
                return frame;
            }
        });
        this.createOperation(false, "round", REAL_TYPE, INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Double.valueOf(Math.round((Double)frame.getLocal(0, 0))).intValue());
                return frame;
            }
        });
        this.createOperation(false, "max", REAL_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.max((Double)frame.getLocal(0, 0), (Double)frame.getLocal(0, 1)));
                return frame;
            }
        });
        this.createOperation(false, "max", REAL_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.max((Double)frame.getLocal(0, 0), (double)((Integer)frame.getLocal(0, 1)).intValue()));
                return frame;
            }
        });
        this.createOperation(false, "min", REAL_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.min((Double)frame.getLocal(0, 0), (Double)frame.getLocal(0, 1)));
                return frame;
            }
        });
        this.createOperation(false, "min", REAL_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.min((Double)frame.getLocal(0, 0), (double)((Integer)frame.getLocal(0, 1)).intValue()));
                return frame;
            }
        });
        this.createOperation(false, "<", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) < (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "<", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) < (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, ">", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) > (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, ">", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) > (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "<=", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) <= (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "<=", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) <= (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, ">=", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) >= (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, ">=", REAL_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Double)frame.getLocal(0, 0) >= (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "neg", INTEGER_TYPE, INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(-((Integer)frame.getLocal(0, 0)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "+", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() + (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "+", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) + (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "-", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() - (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "-", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) - (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "*", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() * (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "*", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) * (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "/", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() / (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "/", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((Integer)frame.getLocal(0, 0)).doubleValue() / (double)((Integer)frame.getLocal(0, 1)).intValue());
                return frame;
            }
        });
        this.createOperation(false, "abs", INTEGER_TYPE, INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.abs((Integer)frame.getLocal(0, 0)));
                return frame;
            }
        });
        this.createOperation(false, "div", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) / (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "mod", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) % (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "max", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.max((double)((Integer)frame.getLocal(0, 0)).intValue(), (Double)frame.getLocal(0, 1)));
                return frame;
            }
        });
        this.createOperation(false, "max", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.max((Integer)frame.getLocal(0, 0), (Integer)frame.getLocal(0, 1)));
                return frame;
            }
        });
        this.createOperation(false, "min", INTEGER_TYPE, REAL_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.min((double)((Integer)frame.getLocal(0, 0)).intValue(), (Double)frame.getLocal(0, 1)));
                return frame;
            }
        });
        this.createOperation(false, "min", INTEGER_TYPE, INTEGER_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Math.min((Integer)frame.getLocal(0, 0), (Integer)frame.getLocal(0, 1)));
                return frame;
            }
        });
        this.createOperation(false, "<", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() < (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "<", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) < (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, ">", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() > (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, ">", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) > (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "<=", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() <= (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "<=", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) <= (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, ">=", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"r"}, REAL_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((double)((Integer)frame.getLocal(0, 0)).intValue() >= (Double)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, ">=", INTEGER_TYPE, BOOLEAN_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push((Integer)frame.getLocal(0, 0) >= (Integer)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "+", STRING_TYPE, STRING_TYPE, new String[][][]{{{"s"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(String.valueOf((String)frame.getLocal(0, 0)) + (String)frame.getLocal(0, 1));
                return frame;
            }
        });
        this.createOperation(false, "size", STRING_TYPE, INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).length());
                return frame;
            }
        });
        this.createOperation(false, "substring", STRING_TYPE, STRING_TYPE, new String[][][]{{{"lower"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).substring((Integer)frame.getLocal(0, 1) - 1));
                return frame;
            }
        });
        this.createOperation(false, "substring", STRING_TYPE, STRING_TYPE, new String[][][]{{{"lower"}, INTEGER_TYPE}, {{"upper"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).substring((Integer)frame.getLocal(0, 1) - 1, (Integer)frame.getLocal(0, 2)));
                return frame;
            }
        });
        this.createOperation(false, "toInteger", STRING_TYPE, INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Integer.parseInt((String)frame.getLocal(0, 0)));
                return frame;
            }
        });
        this.createOperation(false, "toReal", STRING_TYPE, REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Double.parseDouble((String)frame.getLocal(0, 0)));
                return frame;
            }
        });
        this.createOperation(false, "indexOf", STRING_TYPE, INTEGER_TYPE, new String[][][]{{{"s"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).indexOf((String)frame.getLocal(0, 1)) + 1);
                return frame;
            }
        });
        this.createOperation(false, "lastIndexOf", STRING_TYPE, INTEGER_TYPE, new String[][][]{{{"s"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).lastIndexOf((String)frame.getLocal(0, 1)) + 1);
                return frame;
            }
        });
        this.createOperation(false, "at", STRING_TYPE, STRING_TYPE, new String[][][]{{{"i"}, INTEGER_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(String.valueOf(((String)frame.getLocal(0, 0)).charAt((Integer)frame.getLocal(0, 1) - 1)));
                return frame;
            }
        });
        this.createOperation(false, "characters", STRING_TYPE, SEQUENCE_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                LazyList<String> seq = new LazyList<String>();
                char[] cArray = ((String)frame.getLocal(0, 0)).toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    seq = seq.append(String.valueOf(c));
                    ++n2;
                }
                frame.push(seq);
                return frame;
            }
        });
        this.createOperation(false, "toBoolean", STRING_TYPE, BOOLEAN_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(Boolean.parseBoolean((String)frame.getLocal(0, 0)));
                return frame;
            }
        });
        this.createOperation(false, "toUpper", STRING_TYPE, STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).toUpperCase());
                return frame;
            }
        });
        this.createOperation(false, "toLower", STRING_TYPE, STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                frame.push(((String)frame.getLocal(0, 0)).toLowerCase());
                return frame;
            }
        });
        this.createOperation(false, "writeTo", STRING_TYPE, BOOLEAN_TYPE, new String[][][]{{{"path"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                try {
                    frame.push(EMFTVMUtil.writeToWithCharset((String)frame.getLocal(0, 0), (String)frame.getLocal(0, 1), null));
                    return frame;
                }
                catch (IOException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "writeToWithCharset", STRING_TYPE, BOOLEAN_TYPE, new String[][][]{{{"path"}, STRING_TYPE}, {{"charset"}, STRING_TYPE}}, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                try {
                    frame.push(EMFTVMUtil.writeToWithCharset((String)frame.getLocal(0, 0), (String)frame.getLocal(0, 1), (String)frame.getLocal(0, 2)));
                    return frame;
                }
                catch (IOException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
    }

    private Operation createOperation(boolean isStatic, String name, String[] context, String[] returnType, String[][][] parameters, CodeBlock body) {
        Operation op = this.factory.createOperation();
        op.setStatic(isStatic);
        op.setName(name);
        op.setContextModel(context[0]);
        op.setContext(context[1]);
        op.setTypeModel(returnType[0]);
        op.setType(returnType[1]);
        EList<Parameter> pars = op.getParameters();
        EList<LocalVariable> locals = body.getLocalVariables();
        if (!isStatic) {
            LocalVariable self = this.factory.createLocalVariable();
            self.setName("self");
            self.setTypeModel(context[0]);
            self.setType(context[1]);
            locals.add((Object)self);
        }
        String[][][] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] par = stringArray[n2];
            Parameter p = this.factory.createParameter();
            p.setName(par[0][0]);
            p.setTypeModel(par[1][0]);
            p.setType(par[1][1]);
            pars.add((Object)p);
            LocalVariable lv = this.factory.createLocalVariable();
            lv.setName(par[0][0]);
            lv.setTypeModel(par[1][0]);
            lv.setType(par[1][1]);
            locals.add((Object)lv);
            ++n2;
        }
        op.setBody(body);
        this.oclModule.getFeatures().add((Object)op);
        return op;
    }

    public Module getOclModule() {
        return this.oclModule;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResolveList
    extends LazyList<Object> {
        protected final StackFrame frame;
        protected final ExecEnv env;
        protected final Field traces;
        protected final TraceLinkSet tls;

        public ResolveList(Collection<Object> dataSource, StackFrame frame) {
            super(dataSource);
            this.frame = frame;
            this.env = frame.getEnv();
            this.traces = this.env.findStaticField(this.env.eClass(), "traces");
            this.tls = (TraceLinkSet)this.traces.getStaticValue(frame);
        }

        @Override
        public Iterator<Object> iterator() {
            if (this.dataSource == null) {
                return Collections.unmodifiableCollection(this.cache).iterator();
            }
            return new ResolveIterator();
        }

        @Override
        public int size() {
            if (this.dataSource == null) {
                return this.cache.size();
            }
            return ((Collection)this.dataSource).size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResolveIterator
        extends LazyCollection.CachingIterator {
            public ResolveIterator() {
                super(ResolveList.this.dataSource.iterator());
            }

            @Override
            public Object next() {
                SourceElement se;
                Object next = this.inner.next();
                if (next instanceof EObject && (se = ResolveList.this.tls.getDefaultSourceElement((EObject)next)) != null) {
                    EList seMapsTo = se.getMapsTo();
                    if (!seMapsTo.isEmpty()) {
                        assert (((TargetElement)seMapsTo.get(0)).getObject().eResource() != null);
                        next = ((TargetElement)seMapsTo.get(0)).getObject();
                    } else {
                        for (TargetElement te : se.getSourceOf().getTargetElements()) {
                            if (!te.getMapsTo().isEmpty()) continue;
                            assert (te.getObject().eResource() != null);
                            next = te.getObject();
                            break;
                        }
                    }
                }
                this.updateCache(next);
                return next;
            }
        }
    }
}

