/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlResourceImpl
extends ResourceImpl {
    protected final AtlParser parser = AtlParser.getDefault();
    protected final EMFModelWrapper modelWrapper = new EMFModelWrapper();

    public AtlResourceImpl() {
    }

    public AtlResourceImpl(URI uri) {
        super(uri);
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            this.parser.inject((IModel)this.modelWrapper, inputStream, options);
            this.registerEPackages(this.modelWrapper.getReferenceModel().getResource());
        }
        catch (ATLCoreException e) {
            throw new ATLIOException(e);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        try {
            this.parser.extract((IModel)this.modelWrapper, outputStream, options);
        }
        catch (ATLCoreException e) {
            throw new ATLIOException(e);
        }
    }

    protected void registerEPackages(Resource res) {
        ResourceSet rs = this.getResourceSet();
        EPackage.Registry r = rs.getPackageRegistry();
        for (EObject o : res.getContents()) {
            if (!(o instanceof EPackage)) continue;
            EPackage p = (EPackage)o;
            r.put((Object)p.getNsURI(), (Object)p);
        }
    }

    public static class ATLIOException
    extends IOException {
        private static final long serialVersionUID = -6673120460005697460L;

        public ATLIOException() {
        }

        public ATLIOException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }

        public ATLIOException(String message) {
            super(message);
        }

        public ATLIOException(Throwable cause) {
            this.initCause(cause);
        }
    }

    public class EMFModelWrapper
    extends EMFModel {
        public EMFModelWrapper() {
            super((EMFReferenceModel)AtlResourceImpl.this.parser.getAtlMetamodel(), (EMFModelFactory)AtlResourceImpl.this.parser.getModelFactory());
            this.setResource((Resource)AtlResourceImpl.this);
        }
    }
}

