/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.channel.overflow.BeanUsingBufferOverflowStrategy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class BufferOverflowStrategyTest
extends TckBase {
    @Inject
    private BeanUsingBufferOverflowStrategy bean;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        return BufferOverflowStrategyTest.getBaseArchive().addClasses(new Class[]{BeanUsingBufferOverflowStrategy.class});
    }

    @Test
    public void testNormal() {
        this.bean.tryEmitThree();
        Assertions.assertThat(this.bean.accepted()).containsExactly((Object[])new String[]{"0", "1", "2"});
        Assertions.assertThat(this.bean.rejected()).isEmpty();
        Awaitility.await().until(() -> this.bean.output().size() == 3);
        Assertions.assertThat(this.bean.output()).containsExactly((Object[])new String[]{"0", "1", "2"});
        Assertions.assertThat((Throwable)this.bean.failure()).isNull();
    }
}

