/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InvalidTokenTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = InvalidTokenTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = InvalidTokenTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"InvalidTokenTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(RolesEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with expired token fails with HTTP_UNAUTHORIZED")
    public void callEchoExpiredToken() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.EXP);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.callEchoAndExpectUnauthorized(token);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with an non-matching issuer fails with HTTP_UNAUTHORIZED")
    public void callEchoBadIssuer() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ISSUER);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.callEchoAndExpectUnauthorized(token);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with an incorrect signer fails with HTTP_UNAUTHORIZED")
    public void callEchoBadSigner() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.SIGNER);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.callEchoAndExpectUnauthorized(token);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with an incorrect signature algorithm fails with HTTP_UNAUTHORIZED")
    public void callEchoBadSignerAlg() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ALG);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.callEchoAndExpectUnauthorized(token);
    }

    private void callEchoAndExpectUnauthorized(String token) throws Exception {
        System.out.printf("jwt: %s\n", token);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
        String reply = (String)response.readEntity(String.class);
        System.out.printf("Reply: %s\n", reply);
    }
}

