/*
 * Decompiled with CFR 0.152.
 */
package timing.distribution;

import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import timing.distribution.ModeDistribution;

public class PertDistribution
extends BetaDistribution
implements ModeDistribution {
    private static final long serialVersionUID = -6681144758330302722L;
    private final double min;
    private final double max;
    private final double mode;
    private final double gamma;
    private final Double itsDefault;

    public PertDistribution(RandomGenerator rng, double min, double max, double mode, double gamma, Double _default) {
        super(rng, (mode - min) / (max - min) * gamma + 1.0, (max - mode) / (max - min) * gamma + 1.0, 1.0E-9);
        this.min = min;
        this.max = max;
        this.mode = mode;
        this.gamma = gamma;
        this.itsDefault = _default;
    }

    @Override
    public double getDefault() {
        if (this.itsDefault != null) {
            return this.itsDefault;
        }
        return this.getMode();
    }

    @Override
    public double getMode() {
        return this.mode;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double density(double x) {
        return super.density(this.toBeta(x));
    }

    public double getNumericalMean() {
        return this.toPert(super.getNumericalMean());
    }

    public double getSupportLowerBound() {
        return this.toPert(super.getSupportLowerBound());
    }

    public double getSupportUpperBound() {
        return this.toPert(super.getSupportUpperBound());
    }

    public double sample() {
        return this.toPert(super.sample());
    }

    protected double toPert(double beta) {
        if (Double.isNaN(beta)) {
            return beta;
        }
        return beta * (this.max - this.min) + this.min;
    }

    protected double toBeta(double pert) {
        if (Double.isNaN(pert)) {
            return pert;
        }
        return (pert - this.min) / (this.max - this.min);
    }
}

