/*
 * Decompiled with CFR 0.152.
 */
package setting;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;
import machine.Import;
import machine.ImportContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import setting.SettingActivator;
import setting.Settings;

public final class SettingUtil {
    private SettingUtil() {
    }

    public static Settings getSettings(ImportContainer importContainer) throws IOException {
        Optional<Settings> settings = importContainer.loadAll().stream().filter(Settings.class::isInstance).map(Settings.class::cast).findFirst();
        if (settings.isPresent()) {
            return settings.get();
        }
        return SettingUtil.getSettings(importContainer.eResource());
    }

    public static Settings getSettings(Resource context) throws IOException {
        return SettingUtil.getSettings(context, null);
    }

    public static Settings getSettings(Resource context, IResource settingIResource) throws IOException {
        if (settingIResource == null) {
            URI contextURI = context.getURI();
            try {
                LinkedHashSet<Settings> matches = new LinkedHashSet<Settings>();
                for (IResource potentialMatch : SettingActivator.getDefault().getSettingIResources(URIHelper.asIResource((URI)contextURI))) {
                    Settings setting = SettingUtil.loadSettings(URIHelper.asURI((IResource)potentialMatch), context.getResourceSet());
                    for (Import imp : setting.getImports()) {
                        URI uri = URI.createURI((String)imp.getImportURI()).resolve(setting.eResource().getURI());
                        if (!uri.equals(contextURI)) continue;
                        matches.add(setting);
                    }
                }
                if (matches.size() == 1) {
                    return (Settings)matches.iterator().next();
                }
                IResource configuredSettingsResource = SettingActivator.getDefault().getSettingIResource(URIHelper.asIResource((URI)contextURI));
                Settings defaultSettings = SettingUtil.loadSettings(URIHelper.asURI((IResource)configuredSettingsResource), context.getResourceSet());
                if (matches.isEmpty()) {
                    return defaultSettings;
                }
                for (Settings match : matches) {
                    if (!EcoreUtil.equals((EObject)defaultSettings, (EObject)match)) continue;
                    return match;
                }
                return (Settings)matches.iterator().next();
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
        return SettingUtil.loadSettings(URIHelper.asURI((IResource)settingIResource), context.getResourceSet());
    }

    private static Settings loadSettings(URI settingURI, ResourceSet resourceSet) {
        Resource settingResource = resourceSet.getResource(settingURI, true);
        return settingResource.getContents().isEmpty() ? null : (Settings)settingResource.getContents().get(0);
    }
}

