/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.zwick;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Triple;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.MeanPayoffGame;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.zwick.ZPSolverInt;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTGraph;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.meanpayoff.MPGIntImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class SolverZPInt {
    private SolverZPInt() {
    }

    public static StrategyVector<JGraphTVertex, JGraphTEdge> getOptimalStrategy(RGIntImplJGraphT game) {
        Map<JGraphTVertex, Fraction> values = SolverZPInt.getValues(game);
        StrategyVector<JGraphTVertex, JGraphTEdge> strategyVector = new StrategyVector<JGraphTVertex, JGraphTEdge>();
        for (JGraphTVertex vertex : game.getVertices()) {
            HashSet<JGraphTEdge> outgoing = new HashSet<JGraphTEdge>(game.outgoingEdgesOf(vertex));
            JGraphTEdge edge = SolverZPInt.findOutgoingEdge(game, vertex, values.get(vertex), outgoing);
            strategyVector.setSuccessor(vertex, game.getEdgeTarget(edge));
        }
        return strategyVector;
    }

    private static JGraphTEdge findOutgoingEdge(RGIntImplJGraphT game, JGraphTVertex vertex, Fraction oldValue, Set<JGraphTEdge> outgoing) {
        if (outgoing.size() < 2) {
            return outgoing.iterator().next();
        }
        Double halve = Math.ceil((float)outgoing.size() / 2.0f);
        Integer leftHalveSize = halve.intValue();
        Iterator<JGraphTEdge> outgoingEdgeIterator = outgoing.iterator();
        HashSet<JGraphTEdge> outgoingLeftHalve = new HashSet<JGraphTEdge>();
        HashSet<JGraphTEdge> outgoingRightHalve = new HashSet<JGraphTEdge>();
        int i = 0;
        while (i < outgoing.size()) {
            if (i < leftHalveSize) {
                outgoingLeftHalve.add(outgoingEdgeIterator.next());
            } else {
                outgoingRightHalve.add(outgoingEdgeIterator.next());
            }
            ++i;
        }
        HashSet<JGraphTEdge> subGraphEdges = new HashSet<JGraphTEdge>(game.getEdges());
        subGraphEdges.removeAll(outgoingRightHalve);
        RGIntImplJGraphT subGraph = game.getSubGraphEdges(subGraphEdges);
        Map<JGraphTVertex, Fraction> newValues = SolverZPInt.getValues(subGraph);
        Fraction newValue = newValues.get(vertex);
        if (newValue.equals((Object)oldValue)) {
            return SolverZPInt.findOutgoingEdge(game, vertex, newValue, outgoingLeftHalve);
        }
        return SolverZPInt.findOutgoingEdge(game, vertex, newValue, outgoingRightHalve);
    }

    public static Map<JGraphTVertex, Fraction> getValues(RGIntImplJGraphT game) {
        HashMap<JGraphTVertex, Fraction> valueMap = new HashMap<JGraphTVertex, Fraction>();
        Integer vSize = game.getVertices().size();
        Integer w = game.getMaxAbsValue();
        Fraction lowerBound = Fraction.ZERO;
        Fraction upperBound = new Fraction(vSize * w, 1);
        for (JGraphTVertex v : game.getVertices()) {
            Fraction value = SolverZPInt.getValue(game, v, vSize, w, lowerBound, upperBound);
            valueMap.put(v, value);
        }
        return valueMap;
    }

    private static Fraction getValue(RGIntImplJGraphT game, JGraphTVertex vertex, Integer v, Integer w, Fraction lowerBoundRatio, Fraction upperBoundRatio) {
        Fraction middleFraction = lowerBoundRatio.add(upperBoundRatio).multiply(Fraction.ONE_HALF);
        Fraction middleMax = SolverZPInt.findMaxInRange(v, w, lowerBoundRatio, middleFraction);
        Fraction middleMin = SolverZPInt.findMinInRange(v, w, middleFraction, upperBoundRatio);
        MeanPayoffGame<JGraphTVertex, JGraphTEdge, Integer> mpg = SolverZPInt.convertToMeanPayoffGame(game, middleMax);
        Triple<Set<JGraphTVertex>, Set<JGraphTVertex>, Set<JGraphTVertex>> split = ZPSolverInt.getThreeWayPartition(mpg, Fraction.ZERO);
        if (split.getMiddle().contains(vertex)) {
            return middleMax;
        }
        if (split.getLeft().contains(vertex)) {
            return SolverZPInt.getValue(game, vertex, v, w, lowerBoundRatio, middleMax);
        }
        return SolverZPInt.getValue(game, vertex, v, w, middleMin, upperBoundRatio);
    }

    private static Fraction findMaxInRange(Integer vertexSize, Integer maxWeight, Fraction lowerBound, Fraction upperBound) {
        Fraction min;
        Fraction max = min = lowerBound;
        int nom = 1;
        while (nom <= vertexSize * maxWeight) {
            int denom = vertexSize * maxWeight;
            while (denom >= 1) {
                Fraction frac = new Fraction(nom, denom);
                if (frac.compareTo(lowerBound) != -1 && frac.compareTo(upperBound) != 1 && frac.compareTo(max) > 0) {
                    max = frac;
                }
                --denom;
            }
            ++nom;
        }
        return max;
    }

    private static Fraction findMinInRange(Integer vertexSize, Integer maxWeight, Fraction lowerBound, Fraction upperBound) {
        Fraction max;
        Fraction min = max = upperBound;
        int nom = 1;
        while (nom <= vertexSize * maxWeight) {
            int denom = vertexSize * maxWeight;
            while (denom >= 1) {
                Fraction frac = new Fraction(nom, denom);
                if (frac.compareTo(lowerBound) != -1 && frac.compareTo(upperBound) != 1 && frac.compareTo(min) < 0) {
                    min = frac;
                }
                --denom;
            }
            ++nom;
        }
        return min;
    }

    private static MeanPayoffGame<JGraphTVertex, JGraphTEdge, Integer> convertToMeanPayoffGame(RGIntImplJGraphT game, Fraction value) {
        JGraphTGraph graph = game.getGraph();
        SingleWeightFunctionInt<JGraphTEdge> wf = new SingleWeightFunctionInt<JGraphTEdge>();
        for (JGraphTEdge e : graph.getEdges()) {
            wf.addWeight(e, value.getDenominator() * game.getWeight1(e) - value.getNumerator() * game.getWeight2(e));
        }
        return new MPGIntImplJGraphT(graph, wf);
    }
}

