/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.ode;

import java.util.List;
import org.apache.commons.math3.analysis.solvers.BaseSecantSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.sampling.FixedStepHandler;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.ode.sampling.StepNormalizer;
import org.apache.commons.math3.ode.sampling.StepNormalizerBounds;
import org.apache.commons.math3.ode.sampling.StepNormalizerMode;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorAbsTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorAlgo;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorAlgoOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorMaxStepOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorMinStepOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorNumStepsOption;
import org.eclipse.escet.cif.simulator.runtime.ode.IntegratorRelTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.OdeSolverOutStepOption;
import org.eclipse.escet.cif.simulator.runtime.ode.OdeStateEvent;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderAbsTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderAlgo;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderAlgoOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderMaxCheckOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderMaxIterOption;
import org.eclipse.escet.cif.simulator.runtime.ode.RootFinderRelTolOption;
import org.eclipse.escet.cif.simulator.runtime.ode.Trajectories;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public abstract class OdeSolver<S extends RuntimeState>
implements FirstOrderDifferentialEquations,
StepHandler,
FixedStepHandler {
    public CifSimulatorContext ctxt;
    public boolean debug;
    public AppStream dbg;
    protected final boolean useDummyVar;
    private S state0;
    private S state0copy;
    private Trajectories trajectories;

    protected OdeSolver(boolean useDummyVar) {
        this.useDummyVar = useDummyVar;
    }

    protected abstract double[] initY(S var1);

    public abstract void checkValues(double var1, double[] var3);

    protected boolean isValidValue(double value) {
        return !Double.isInfinite(value) && !Double.isNaN(value);
    }

    public void throwValueError(double value, String varName) {
        String valueTxt;
        if (Double.isNaN(value)) {
            valueTxt = "NaN";
        } else if (value == Double.POSITIVE_INFINITY) {
            valueTxt = "+inf";
        } else {
            Assert.check((value == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
            valueTxt = "-inf";
        }
        String msg = Strings.fmt((String)"The value of variable \"%s\" has become \"%s\", which is not supported. This may indicate an overflow. It might be possible to prevent this by setting a maximum delay for time transitions, or by shortening it. Alternatively, try restricting passage of time in the CIF specification itself.", (Object[])new Object[]{varName, valueTxt});
        throw new UnsupportedException(msg);
    }

    public Trajectories solveIVP(S state, List<OdeStateEvent<S>> events, double maxTime) {
        double tLast;
        Double outStep;
        double time0 = ((RuntimeState)state).getTime();
        this.state0 = state;
        this.state0copy = null;
        if (this.debug) {
            this.dbg.printfln("ODE solver: ODE solver started.", new Object[0]);
            this.dbg.printfln("ODE solver: initial state: %s", new Object[]{((RuntimeState)this.state0).toSingleLineString(null, false, false)});
        }
        double[] y = this.initY(state);
        if (this.debug) {
            if (this.useDummyVar) {
                this.dbg.printfln("ODE solver: no continuous variables, using dummy variable.", new Object[0]);
            } else {
                this.dbg.printfln("ODE solver: %d continuous variable(s).", new Object[]{y.length});
            }
        }
        this.trajectories = new Trajectories();
        this.addToTrajs(time0, y);
        int intNumSteps = IntegratorNumStepsOption.getIntNumSteps();
        double intMinStep = IntegratorMinStepOption.getIntMinStep();
        double intMaxStep = IntegratorMaxStepOption.getIntMaxStep();
        double intAbsTol = IntegratorAbsTolOption.getIntAbsTol();
        double intRelTol = IntegratorRelTolOption.getIntRelTol();
        IntegratorAlgo intAlgo = IntegratorAlgoOption.getIntAlgo();
        FirstOrderIntegrator integrator = intAlgo.create(intNumSteps, intMinStep, intMaxStep, intAbsTol, intRelTol);
        if (this.debug) {
            this.dbg.printfln("ODE solver: integrator algorithm: %s.", new Object[]{intAlgo.name});
            this.dbg.printfln("ODE solver: integrator minimum step size: %s.", new Object[]{CifSimulatorMath.realToStr(intMinStep)});
            this.dbg.printfln("ODE solver: integrator maximum step size: %s.", new Object[]{CifSimulatorMath.realToStr(intMaxStep)});
            this.dbg.printfln("ODE solver: integrator absolute tolerance: %s.", new Object[]{CifSimulatorMath.realToStr(intAbsTol)});
            this.dbg.printfln("ODE solver: integrator relative tolerance: %s.", new Object[]{CifSimulatorMath.realToStr(intRelTol)});
            this.dbg.printfln("ODE solver: integrator number of steps: %d.", new Object[]{intNumSteps});
        }
        OdeSolver<S> stepHandler = (outStep = OdeSolverOutStepOption.getSolverOutStep()) == null ? this : new StepNormalizer(outStep.doubleValue(), (FixedStepHandler)this, StepNormalizerMode.MULTIPLES, StepNormalizerBounds.LAST);
        integrator.addStepHandler((StepHandler)stepHandler);
        if (this.debug) {
            String stepTxt = outStep == null ? "disabled" : CifSimulatorMath.realToStr(outStep);
            this.dbg.printfln("ODE solver: fixed output step size: %s.", new Object[]{stepTxt});
        }
        double rootAbsTol = RootFinderAbsTolOption.getRootAbsTol();
        double rootRelTol = RootFinderRelTolOption.getRootRelTol();
        double rootMaxChk = RootFinderMaxCheckOption.getRootMaxChk();
        int rootMaxIter = RootFinderMaxIterOption.getRootMaxIter();
        RootFinderAlgo rootAlgo = RootFinderAlgoOption.getRootAlgo();
        if (this.debug) {
            this.dbg.printfln("ODE solver: root finder algorithm: %s.", new Object[]{rootAlgo.name});
            this.dbg.printfln("ODE solver: root finder maximum check interval: %s.", new Object[]{CifSimulatorMath.realToStr(rootMaxChk)});
            this.dbg.printfln("ODE solver: root finder maximum iterations: %d.", new Object[]{rootMaxIter});
            this.dbg.printfln("ODE solver: root finder absolute tolerance: %s.", new Object[]{CifSimulatorMath.realToStr(rootAbsTol)});
            this.dbg.printfln("ODE solver: root finder relative tolerance: %s.", new Object[]{CifSimulatorMath.realToStr(rootRelTol)});
        }
        if (this.debug) {
            this.dbg.printfln("ODE solver: state event guard predicates: %d.", new Object[]{events.size()});
        }
        int i = 0;
        while (i < events.size()) {
            OdeStateEvent<S> event = events.get(i);
            BaseSecantSolver solver = rootAlgo.create(rootAbsTol, rootRelTol);
            integrator.addEventHandler(event, rootMaxChk, rootAbsTol, rootMaxIter, (UnivariateSolver)solver);
            if (this.debug) {
                this.dbg.printfln("ODE solver: state event guard predicate (%d/%d): %s.", new Object[]{i + 1, events.size(), event.getPredText()});
            }
            ++i;
        }
        double tEnd = maxTime;
        if (tEnd - time0 < intAbsTol) {
            double newEnd;
            double delta = intAbsTol;
            while (!((newEnd = time0 + delta) - time0 >= intAbsTol)) {
                delta *= 2.0;
            }
            tEnd = newEnd;
        }
        if (this.debug) {
            this.dbg.printfln("ODE solver: maximum end time (original): %s.", new Object[]{CifSimulatorMath.realToStr(maxTime)});
            this.dbg.printfln("ODE solver: maximum end time (corrected): %s.", new Object[]{CifSimulatorMath.realToStr(tEnd)});
        }
        if (this.debug) {
            this.dbg.printfln("ODE solver: trajectories calculation started.", new Object[0]);
        }
        try {
            tLast = integrator.integrate((FirstOrderDifferentialEquations)this, time0, y, tEnd, y);
        }
        catch (MathIllegalArgumentException e) {
            String msg = "ODE solver failed to compute the trajectories of the continuous variables. The problem (your specification) may be too complicated. You could try modifying the ODE solver options.";
            throw new UnsupportedException(msg, (Throwable)e);
        }
        catch (MathIllegalStateException e) {
            String msg = "ODE solver failed to compute the trajectories of the continuous variables. The problem (your specification) may be too complicated. You could try modifying the ODE solver options.";
            throw new UnsupportedException(msg, (Throwable)e);
        }
        Assert.check((tLast >= time0 ? 1 : 0) != 0);
        Assert.check((tLast == this.trajectories.getLastTime() ? 1 : 0) != 0);
        if (this.debug) {
            this.dbg.printfln("ODE solver: trajectories calculation finished.", new Object[0]);
            this.dbg.printfln("ODE solver: trajectories end time: %s.", new Object[]{CifSimulatorMath.realToStr(tLast)});
        }
        Trajectories trajs = this.trajectories;
        this.state0 = null;
        this.state0copy = null;
        this.trajectories = null;
        if (this.debug) {
            this.dbg.printfln("ODE solver: trajectories contain %d time point(s).", new Object[]{trajs.getCount()});
            this.dbg.printfln("ODE solver: a time transition is%s possible.", new Object[]{trajs.getCount() < 2 ? " not" : ""});
            this.dbg.printfln("ODE solver: ODE solver finished.", new Object[0]);
            this.dbg.println();
        }
        if (trajs.getCount() < 2) {
            return null;
        }
        return trajs;
    }

    public String valuesToStr(double time, double[] y, boolean derivatives) {
        StringBuilder txt = new StringBuilder();
        txt.append("time=");
        txt.append(CifSimulatorMath.realToStr(time));
        int i = 0;
        while (i < y.length) {
            txt.append(", ");
            txt.append(this.getContVarName(i));
            if (derivatives) {
                txt.append("'");
            }
            txt.append("=");
            txt.append(CifSimulatorMath.realToStr(y[i]));
            ++i;
        }
        return txt.toString();
    }

    private void addToTrajs(double time, double[] y) {
        this.checkValues(time, y);
        this.trajectories.add(time, y);
        if (this.debug) {
            String valuesTxt = this.valuesToStr(time, y, false);
            this.dbg.printfln("ODE solver: add to trajectories: %s", new Object[]{valuesTxt});
        }
    }

    public abstract int getDimension();

    protected abstract String getContVarName(int var1);

    public void computeDerivatives(double t, double[] y, double[] yDot) {
        String valuesTxt;
        this.ctxt.checkTermination();
        this.checkValues(t, y);
        S state = this.updateState(t, y);
        if (this.debug) {
            valuesTxt = this.valuesToStr(t, y, false);
            this.dbg.printfln("ODE solver: computing derivatives: %s", new Object[]{valuesTxt});
        }
        try {
            this.computeDerivatives(state, yDot);
        }
        catch (CifSimulatorException e) {
            String msg = Strings.fmt((String)"Evaluation of a derivative at time %s failed.", (Object[])new Object[]{CifSimulatorMath.realToStr(t)});
            throw new CifSimulatorException(msg, e, (RuntimeState)state);
        }
        if (this.debug) {
            valuesTxt = this.valuesToStr(t, y, true);
            this.dbg.printfln("ODE solver: computed derivatives: %s", new Object[]{valuesTxt});
        }
    }

    public abstract S makeState(S var1, double var2, double[] var4, boolean var5);

    public S updateState(double t, double[] y) {
        if (this.state0copy != null) {
            return this.makeState(this.state0copy, t, y, false);
        }
        this.state0copy = this.makeState(this.state0, t, y, true);
        return this.state0copy;
    }

    protected abstract void computeDerivatives(S var1, double[] var2);

    public void init(double t0, double[] y0, double t) {
    }

    public void handleStep(StepInterpolator interpolator, boolean isLast) {
        double t = interpolator.getCurrentTime();
        double[] y = interpolator.getInterpolatedState();
        this.addToTrajs(t, y);
    }

    public void handleStep(double t, double[] y, double[] yDot, boolean isLast) {
        this.addToTrajs(t, y);
    }
}

