/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.escet.cif.simulator.input.AutomaticInputComponent;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InputComponent;
import org.eclipse.escet.cif.simulator.output.svgviz.RuntimeCifSvgDecls;
import org.eclipse.escet.cif.simulator.output.svgviz.SvgOutputComponent;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.svg.selector.SvgSelector;

public final class SvgInputComponent<S extends RuntimeState>
extends InputComponent<S> {
    private final List<SvgOutputComponent> outputComponents = Lists.list();
    private final Map<SvgSelector, RuntimeCifSvgDecls> svgSelectMap = Maps.map();
    private boolean[] interactiveEvents = null;
    private boolean[] lastDisabledEvents = null;
    private final AutomaticInputComponent<S> deferInputComp;
    public final Queue<Pair<SvgSelector, String>> queue = new ConcurrentLinkedQueue<Pair<SvgSelector, String>>();

    public SvgInputComponent(RuntimeSpec<S> spec) {
        super(spec);
        this.deferInputComp = new AutomaticInputComponent<S>(spec);
    }

    public void initialize(SvgOutputComponent component) {
        RuntimeCifSvgDecls cifSvgDecls = component.cifSvgDecls;
        this.outputComponents.add(component);
        boolean[] interactiveEvents = cifSvgDecls.getInteractiveEvents();
        if (this.interactiveEvents == null) {
            this.interactiveEvents = interactiveEvents;
        } else {
            Assert.check((this.interactiveEvents.length == interactiveEvents.length ? 1 : 0) != 0);
            int i = 0;
            while (i < interactiveEvents.length) {
                int n = i;
                this.interactiveEvents[n] = this.interactiveEvents[n] | interactiveEvents[i];
                ++i;
            }
        }
        SvgSelector selector = new SvgSelector(component.canvas, cifSvgDecls.getInteractiveIds(), this.queue);
        this.svgSelectMap.put(selector, cifSvgDecls);
        component.renderThread.selector = selector;
    }

    @Override
    public void updateDisabledEvents(S state, boolean[] disabled) {
        if (this.queue.isEmpty()) {
            System.arraycopy(this.interactiveEvents, 0, disabled, 0, disabled.length);
        } else {
            Pair<SvgSelector, String> idPair = this.queue.peek();
            SvgSelector selector = (SvgSelector)idPair.left;
            String id = (String)idPair.right;
            RuntimeCifSvgDecls cifSvgDecls = this.svgSelectMap.get(selector);
            int eventIdx = cifSvgDecls.applyInput(id, (RuntimeState)state);
            Arrays.fill(disabled, true);
            disabled[eventIdx] = false;
        }
        this.lastDisabledEvents = disabled;
    }

    @Override
    public Transition<S> chooseTransition(S state, List<Transition<S>> transitions, SimulationResult result) {
        if (transitions.isEmpty()) {
            throw new SimulatorExitException(result);
        }
        Pair<SvgSelector, String> idPair = this.queue.peek();
        RuntimeCifSvgDecls cifSvgDecls = null;
        String id = null;
        int eventIdx = -1;
        if (idPair != null) {
            SvgSelector selector = (SvgSelector)idPair.left;
            id = (String)idPair.right;
            cifSvgDecls = this.svgSelectMap.get(selector);
            eventIdx = cifSvgDecls.applyInput(id, (RuntimeState)state);
            if (this.lastDisabledEvents[eventIdx]) {
                idPair = null;
            } else {
                this.queue.poll();
            }
        }
        if (idPair == null) {
            List transitions2 = Lists.list();
            for (Transition<S> trans : transitions) {
                int idx;
                if (trans instanceof EventTransition && this.interactiveEvents[idx = ((EventTransition)trans).event.idx]) continue;
                transitions2.add(trans);
            }
            if (transitions2.isEmpty()) {
                throw new SimulatorExitException(SimulationResult.DEADLOCK);
            }
            Assert.check((result == null ? 1 : 0) != 0);
            return this.deferInputComp.chooseTransition(state, transitions2, result);
        }
        if (cifSvgDecls.debug) {
            String msg = Strings.fmt((String)"SVG input (\"%s\") id \"%s\": event \"%s\"", (Object[])new Object[]{cifSvgDecls.getSvgRelPath(), id, this.spec.events.get((int)eventIdx).name});
            cifSvgDecls.dbg.println(msg);
        }
        List matches = Lists.list();
        for (Transition<S> trans : transitions) {
            if (!(trans instanceof EventTransition) || ((EventTransition)trans).event.idx != eventIdx) continue;
            matches.add(trans);
        }
        if (matches.isEmpty()) {
            OutputProvider.warn((String)"The SVG element (\"%s\") with id \"%s\" was clicked, but the corresponding event \"%s\" is not enabled in the current state, leading to deadlock.", (Object[])new Object[]{cifSvgDecls.getSvgRelPath(), id, this.spec.events.get((int)eventIdx).name});
            throw new SimulatorExitException(SimulationResult.DEADLOCK);
        }
        Assert.check((result == null ? 1 : 0) != 0);
        return this.deferInputComp.chooseTransition(state, matches, result);
    }

    @Override
    public Double getNextMaxEndTime(S state) {
        return this.deferInputComp.getNextMaxEndTime(state);
    }

    @Override
    public ChosenTargetTime chooseTargetTime(S state, double maxTargetTime) {
        return this.deferInputComp.chooseTargetTime(state, maxTargetTime);
    }

    @Override
    public boolean interruptTimeTrans() {
        return !this.queue.isEmpty();
    }
}

