/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.DerivativeCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.PairTextComparer;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SolverCodeGenerator {
    private SolverCodeGenerator() {
    }

    public static void gencodeSolver(Specification spec, CifCompilerContext ctxt) {
        ContVariable var;
        boolean useDummyVar;
        JavaCodeFile file = ctxt.addCodeFile("Solver");
        CodeBox h = file.header;
        h.add("/** Runtime ODE solver. */");
        h.add("public final class Solver extends OdeSolver<State> {");
        CodeBox c = file.body;
        List vars = Lists.list();
        DerivativeCodeGenerator.collectContVars((ComplexComponent)spec, vars);
        List contNamesVars = Lists.list();
        for (ContVariable var2 : vars) {
            contNamesVars.add(Pair.pair((Object)CifTextUtils.getAbsName((PositionObject)var2, (boolean)false), (Object)var2));
        }
        Collections.sort(contNamesVars, new PairTextComparer());
        int i = 0;
        while (i < contNamesVars.size()) {
            vars.set(i, (ContVariable)((Pair)contNamesVars.get((int)i)).right);
            ++i;
        }
        int count = vars.size();
        boolean bl = useDummyVar = count == 0;
        if (useDummyVar) {
            count = 1;
        }
        c.add("private static Solver SOLVER;");
        c.add();
        c.add("public static String[] CONT_VAR_NAMES = {");
        c.indent();
        for (ContVariable var3 : vars) {
            c.add("\"%s\",", new Object[]{CifTextUtils.getAbsName((PositionObject)var3)});
        }
        if (useDummyVar) {
            c.add("\"<dummy>\",");
        }
        c.dedent();
        c.add("};");
        c.add();
        c.add("public Solver() {");
        c.indent();
        c.add("super(%s);", new Object[]{Strings.str((Object)useDummyVar)});
        c.dedent();
        c.add("}");
        c.add();
        c.add("public static Solver getSolver() {");
        c.indent();
        c.add("if (SOLVER == null) SOLVER = new Solver();");
        c.add("return SOLVER;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected double[] initY(State state) {");
        c.indent();
        c.add("double[] y = new double[%d];", new Object[]{count});
        if (useDummyVar) {
            c.add("y[0] = 0.0; // dummy variable");
        } else {
            int i2 = 0;
            while (i2 < count) {
                var = (ContVariable)vars.get(i2);
                c.add("y[%d] = state.%s.%s;", new Object[]{i2, ctxt.getContVarSubStateName(var), ctxt.getContVarFieldName(var)});
                ++i2;
            }
        }
        c.add("return y;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void checkValues(double time, double[] values) {");
        c.indent();
        c.add("if (!isValidValue(time)) throwValueError(time, \"time\");");
        if (!useDummyVar) {
            int i3 = 0;
            while (i3 < count) {
                var = (ContVariable)vars.get(i3);
                c.add("if (!isValidValue(values[%d])) throwValueError(values[%d], \"%s\");", new Object[]{i3, i3, CifTextUtils.getAbsName((PositionObject)var)});
                ++i3;
            }
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public int getDimension() {");
        c.indent();
        c.add("return %d;", new Object[]{count});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected String getContVarName(int idx) {");
        c.indent();
        c.add("return CONT_VAR_NAMES[idx];");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public State makeState(State state, double t, double[] y, boolean copy) {");
        c.indent();
        c.add("State rslt = copy ? State.copy(state) : state;");
        c.add("if (copy) rslt.%s = rslt.%s.copy();", new Object[]{"s", "s"});
        c.add("rslt.%s.time = t;", new Object[]{"s"});
        if (!useDummyVar) {
            Set automata = Sets.set();
            int i4 = 0;
            while (i4 < count) {
                ContVariable var4 = (ContVariable)vars.get(i4);
                EObject parent = var4.eContainer();
                if (parent instanceof Automaton && !automata.contains(parent)) {
                    Automaton aut = (Automaton)parent;
                    automata.add(aut);
                    c.add("if (copy) rslt.%s = rslt.%s.copy();", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getAutSubStateFieldName(aut)});
                }
                c.add("rslt.%s.%s = (y[%d] == -0.0) ? 0.0 : y[%d];", new Object[]{ctxt.getContVarSubStateName(var4), ctxt.getContVarFieldName(var4), i4, i4});
                ++i4;
            }
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("protected void computeDerivatives(State state, double[] yDot) {");
        c.indent();
        if (useDummyVar) {
            c.add("yDot[0] = 1.0; // dummy variable");
        } else {
            int i5 = 0;
            while (i5 < count) {
                ContVariable var5 = (ContVariable)vars.get(i5);
                c.add("yDot[%d] = %s(state);", new Object[]{i5, ctxt.getDerivativeMethodName(var5)});
                ++i5;
            }
        }
        c.dedent();
        c.add("}");
    }
}

