/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.common.app.framework.exceptions.UnsupportedException;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InputVariableChecker {
    private InputVariableChecker() {
    }

    public static void checkInputVars(ComplexComponent comp) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof InputVariable)) continue;
            String msg = Strings.fmt((String)"Input variable \"%s\" is currently not supported by the CIF simulator.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)decl)});
            throw new UnsupportedException(msg);
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                InputVariableChecker.checkInputVars((ComplexComponent)child);
            }
        }
    }
}

