/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.debug;

import com.google.common.base.Throwables;
import com.google.inject.Singleton;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.internal.Activator;

public class XtextBuildConsole
extends IOConsole {
    private final PrintStream out = new PrintStream((OutputStream)this.newOutputStream(), true);

    public XtextBuildConsole() {
        super("Xtext Build", "xtextBuildConsole", ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getEntry("icons/console.png")), true);
    }

    public void println(String s) {
        this.out.println(s);
    }

    public static class Factory
    implements IConsoleFactory {
        public void openConsole() {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.addConsoles(new IConsole[]{new XtextBuildConsole()});
        }
    }

    @Singleton
    public static class Logger
    implements IBuildLogger {
        private static IBuildLogger delegate;

        @Override
        public void log(Object obj) {
            if (delegate != null) {
                delegate.log(obj);
            }
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            XtextBuildConsole console = null;
            IConsole[] iConsoleArray = consoleManager.getConsoles();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole c = iConsoleArray[n2];
                if (c instanceof XtextBuildConsole) {
                    console = (XtextBuildConsole)c;
                    break;
                }
                ++n2;
            }
            if (console != null) {
                String str = null;
                str = obj instanceof Throwable ? Throwables.getStackTraceAsString((Throwable)((Throwable)obj)) : obj.toString();
                console.println("[" + Thread.currentThread().getName() + "] " + str);
                consoleManager.showConsoleView((IConsole)console);
            }
        }

        public IBuildLogger registerDelegate(IBuildLogger delegate) {
            Logger.delegate = delegate;
            return delegate;
        }
    }
}

