/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.CifPackage;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.automata.AutomataPackage;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DeclarationsPackage;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.ReturnFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.DistType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.cif.types.VoidType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;

public class CifValueUtils {
    private CifValueUtils() {
    }

    public static boolean isTriviallyTrue(Expression expr, boolean initial, boolean checkRefs) {
        Object value;
        if (!CifValueUtils.hasSingleValue(expr, initial, checkRefs)) {
            return false;
        }
        try {
            value = CifEvalUtils.eval(expr, initial);
        }
        catch (CifEvalException e) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static boolean isTriviallyTrue(List<Expression> exprs, boolean initial, boolean checkRefs) {
        for (Expression expr : exprs) {
            if (CifValueUtils.isTriviallyTrue(expr, initial, checkRefs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTriviallyFalse(Expression expr, boolean initial, boolean checkRefs) {
        Object value;
        if (!CifValueUtils.hasSingleValue(expr, initial, checkRefs)) {
            return false;
        }
        try {
            value = CifEvalUtils.eval(expr, initial);
        }
        catch (CifEvalException e) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        return false;
    }

    public static boolean isTriviallyFalse(List<Expression> exprs, boolean initial, boolean checkRefs) {
        for (Expression expr : exprs) {
            if (!CifValueUtils.isTriviallyFalse(expr, initial, checkRefs)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSingleValue(Expression expr, boolean initial, boolean checkRefs) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof TimeExpression) {
            return initial;
        }
        if (expr instanceof CastExpression) {
            Expression child = ((CastExpression)expr).getChild();
            if (CifTypeUtils.isAutRefExpr(child)) {
                Automaton aut;
                if (!checkRefs) {
                    return false;
                }
                CifType ctype = child.getType();
                CifType nctype = CifTypeUtils.normalizeType(ctype);
                if (nctype instanceof ComponentType) {
                    Component comp = ((ComponentType)nctype).getComponent();
                    aut = CifScopeUtils.getAutomaton(comp);
                } else {
                    Assert.check((boolean)(nctype instanceof ComponentDefType));
                    ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                    aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
                }
                return aut.getLocations().size() == 1;
            }
            CastExpression cexpr = (CastExpression)expr;
            return CifValueUtils.hasSingleValue(cexpr.getChild(), initial, checkRefs);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            if (uexpr.getOperator() == UnaryOperator.SAMPLE) {
                return false;
            }
            return CifValueUtils.hasSingleValue(uexpr.getChild(), initial, checkRefs);
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            return CifValueUtils.hasSingleValue(bexpr.getLeft(), initial, checkRefs) && CifValueUtils.hasSingleValue(bexpr.getRight(), initial, checkRefs);
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            boolean guardsValue = true;
            for (Expression guard : ifExpr.getGuards()) {
                boolean guardValue;
                if (!CifValueUtils.hasSingleValue(guard, initial, checkRefs)) {
                    return false;
                }
                try {
                    guardValue = (Boolean)CifEvalUtils.eval(guard, initial);
                }
                catch (CifEvalException e) {
                    return false;
                }
                boolean bl = guardsValue = guardsValue && guardValue;
            }
            if (guardsValue) {
                return CifValueUtils.hasSingleValue(ifExpr.getThen(), initial, checkRefs);
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                guardsValue = true;
                for (Expression guard : elif.getGuards()) {
                    boolean guardValue;
                    if (!CifValueUtils.hasSingleValue(guard, initial, checkRefs)) {
                        return false;
                    }
                    try {
                        guardValue = (Boolean)CifEvalUtils.eval(guard, initial);
                    }
                    catch (CifEvalException e) {
                        return false;
                    }
                    boolean bl = guardsValue = guardsValue && guardValue;
                }
                if (!guardsValue) continue;
                return CifValueUtils.hasSingleValue(elif.getThen(), initial, checkRefs);
            }
            return CifValueUtils.hasSingleValue(ifExpr.getElse(), initial, checkRefs);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            if (CifTypeUtils.isAutRefExpr(value)) {
                Automaton aut;
                if (!checkRefs) {
                    return false;
                }
                CifType ctype = value.getType();
                CifType nctype = CifTypeUtils.normalizeType(ctype);
                if (nctype instanceof ComponentType) {
                    Component comp = ((ComponentType)nctype).getComponent();
                    aut = CifScopeUtils.getAutomaton(comp);
                } else {
                    Assert.check((boolean)(nctype instanceof ComponentDefType));
                    ComponentDef cdef = ((ComponentDefType)nctype).getDefinition();
                    aut = CifScopeUtils.getAutomaton((Component)cdef.getBody());
                }
                if (aut.getLocations().size() != 1) {
                    return false;
                }
            } else if (!CifValueUtils.hasSingleValue(value, initial, checkRefs)) {
                return false;
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null && !CifValueUtils.hasSingleValue(cse.getKey(), initial, checkRefs)) {
                    return false;
                }
                if (CifValueUtils.hasSingleValue(cse.getValue(), initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            if (!CifValueUtils.hasSingleValue(pexpr.getChild(), initial, checkRefs)) {
                return false;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return true;
            }
            return CifValueUtils.hasSingleValue(pexpr.getIndex(), initial, checkRefs);
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (!CifValueUtils.hasSingleValue(sexpr.getChild(), initial, checkRefs)) {
                return false;
            }
            if (sexpr.getBegin() != null && !CifValueUtils.hasSingleValue(sexpr.getBegin(), initial, checkRefs)) {
                return false;
            }
            return sexpr.getEnd() == null || CifValueUtils.hasSingleValue(sexpr.getEnd(), initial, checkRefs);
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (fcexpr.getFunction() instanceof StdLibFunctionExpression) {
                StdLibFunctionExpression stdlib = (StdLibFunctionExpression)fcexpr.getFunction();
                StdLibFunction func = stdlib.getFunction();
                if (CifTypeUtils.isDistFunction(func)) {
                    return false;
                }
            } else {
                return false;
            }
            for (Expression param : fcexpr.getParams()) {
                if (CifValueUtils.hasSingleValue(param, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.hasSingleValue(elem, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.hasSingleValue(elem, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                if (CifValueUtils.hasSingleValue(elem, initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.hasSingleValue(pair.getKey(), initial, checkRefs)) {
                    return false;
                }
                if (CifValueUtils.hasSingleValue(pair.getValue(), initial, checkRefs)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ConstantExpression) {
            if (!checkRefs) {
                return false;
            }
            Constant constant = ((ConstantExpression)expr).getConstant();
            return CifValueUtils.hasSingleValue(constant.getValue(), initial, checkRefs);
        }
        if (expr instanceof DiscVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            if (CifValueUtils.hasSingleValue(var.getType())) {
                return true;
            }
            if (var.eContainer() instanceof FunctionParameter) {
                return false;
            }
            if (!initial) {
                return false;
            }
            if (var.getValue() == null) {
                if (CifTypeUtils.hasFunctionType(var.getType())) {
                    return false;
                }
                return !CifTypeUtils.hasDistType(var.getType());
            }
            if (var.getValue().getValues().size() != 1) {
                return false;
            }
            Expression value = (Expression)Lists.first((List)var.getValue().getValues());
            return CifValueUtils.hasSingleValue(value, initial, checkRefs);
        }
        if (expr instanceof AlgVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifValueUtils.hasSingleValue(value, initial, checkRefs);
            }
            if (var.eContainer() instanceof Parameter) {
                return CifValueUtils.hasSingleValue(var.getType());
            }
            ComplexComponent comp = (ComplexComponent)var.eContainer();
            for (Equation eq : comp.getEquations()) {
                if (eq.getVariable() != var) continue;
                return CifValueUtils.hasSingleValue(eq.getValue(), initial, checkRefs);
            }
            return false;
        }
        if (expr instanceof ContVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            ContVariable var = cexpr.getVariable();
            boolean isDer = cexpr.isDerivative();
            if (isDer) {
                Expression der = var.getDerivative();
                if (der != null) {
                    return CifValueUtils.hasSingleValue(der, initial, checkRefs);
                }
                ComplexComponent comp = (ComplexComponent)var.eContainer();
                for (Equation eq : comp.getEquations()) {
                    if (eq.getVariable() != var) continue;
                    return CifValueUtils.hasSingleValue(eq.getValue(), initial, checkRefs);
                }
                return false;
            }
            if (!initial) {
                return false;
            }
            if (var.getValue() == null) {
                return true;
            }
            return CifValueUtils.hasSingleValue(var.getValue(), initial, checkRefs);
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau expression in value context.");
        }
        if (expr instanceof LocationExpression) {
            if (!checkRefs) {
                return false;
            }
            Location loc = ((LocationExpression)expr).getLocation();
            EObject parent = loc.eContainer();
            if (parent instanceof Parameter) {
                return false;
            }
            Automaton aut = (Automaton)parent;
            return aut.getLocations().size() == 1;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event expression in value context.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Stdlib functions can not be used as values.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            return checkRefs;
        }
        if (expr instanceof InputVariableExpression) {
            if (!checkRefs) {
                return false;
            }
            InputVariable var = ((InputVariableExpression)expr).getVariable();
            return CifValueUtils.hasSingleValue(var.getType());
        }
        if (expr instanceof ComponentExpression) {
            return false;
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifValueUtils.hasSingleValue(rexpr, initial, checkRefs);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifValueUtils.hasSingleValue(rexpr, initial, checkRefs);
        }
        if (expr instanceof ReceivedExpression) {
            if (!checkRefs) {
                return false;
            }
            return CifValueUtils.hasSingleValue(expr.getType());
        }
        if (expr instanceof SelfExpression) {
            return false;
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    public static boolean hasSingleValue(CifType type) {
        if (type instanceof BoolType) {
            return false;
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            if (CifTypeUtils.isRangeless(itype)) {
                return false;
            }
            return itype.getLower().equals(itype.getUpper());
        }
        if (type instanceof RealType) {
            return false;
        }
        if (type instanceof StringType) {
            return false;
        }
        if (type instanceof VoidType) {
            return false;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            if (CifTypeUtils.isRangeless(ltype)) {
                return false;
            }
            if (!ltype.getLower().equals(ltype.getUpper())) {
                return false;
            }
            return CifValueUtils.hasSingleValue(ltype.getElementType());
        }
        if (type instanceof SetType) {
            return false;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                if (CifValueUtils.hasSingleValue(field.getType())) continue;
                return false;
            }
            return true;
        }
        if (type instanceof DictType) {
            return false;
        }
        if (type instanceof CompInstWrapType) {
            CifType rtype = ((CompInstWrapType)type).getReference();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof CompParamWrapType) {
            CifType rtype = ((CompParamWrapType)type).getReference();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof ComponentDefType) {
            return false;
        }
        if (type instanceof ComponentType) {
            return true;
        }
        if (type instanceof EnumType) {
            return ((EnumType)type).getEnum().getLiterals().size() == 1;
        }
        if (type instanceof TypeRef) {
            CifType rtype = ((TypeRef)type).getType().getType();
            return CifValueUtils.hasSingleValue(rtype);
        }
        if (type instanceof FuncType) {
            return false;
        }
        if (type instanceof DistType) {
            return false;
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public static Expression getDefaultValue(CifType type, List<InternalFunction> funcs) {
        if (type instanceof BoolType) {
            return CifValueUtils.makeFalse();
        }
        if (type instanceof IntType) {
            IntExpression rslt = CifConstructors.newIntExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            IntType itype = (IntType)type;
            if (CifTypeUtils.isRangeless(itype)) {
                rslt.setValue(0);
            } else if (itype.getLower() <= 0 && itype.getUpper() >= 0) {
                rslt.setValue(0);
            } else {
                int uDistanceToZero;
                int lDistanceToZero = Math.abs(itype.getLower());
                rslt.setValue((lDistanceToZero < (uDistanceToZero = Math.abs(itype.getUpper())) ? itype.getLower() : itype.getUpper()).intValue());
            }
            return rslt;
        }
        if (type instanceof TypeRef) {
            return CifValueUtils.getDefaultValue(((TypeRef)type).getType().getType(), funcs);
        }
        if (type instanceof EnumType) {
            EnumLiteralExpression rslt = CifConstructors.newEnumLiteralExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            rslt.setLiteral((EnumLiteral)Lists.first((List)enumDecl.getLiterals()));
            return rslt;
        }
        if (type instanceof RealType) {
            RealExpression rslt = CifConstructors.newRealExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setValue("0.0");
            return rslt;
        }
        if (type instanceof StringType) {
            StringExpression rslt = CifConstructors.newStringExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setValue("");
            return rslt;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            ListExpression rslt = CifConstructors.newListExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            if (!CifTypeUtils.isRangeless(ltype)) {
                int lower = ltype.getLower();
                int i = 0;
                while (i < lower) {
                    Expression elem = CifValueUtils.getDefaultValue(ltype.getElementType(), funcs);
                    rslt.getElements().add((Object)elem);
                    ++i;
                }
            }
            return rslt;
        }
        if (type instanceof SetType) {
            SetExpression rslt = CifConstructors.newSetExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rslt;
        }
        if (type instanceof FuncType) {
            FuncType ftype = (FuncType)type;
            ftype.getReturnType();
            InternalFunction function = null;
            for (InternalFunction func : funcs) {
                FuncType t = CifConstructors.newFuncType();
                CifType rt = CifTypeUtils.makeTupleType((List<CifType>)func.getReturnTypes());
                t.setReturnType((CifType)EMFHelper.deepclone((EObject)rt));
                for (FunctionParameter param : func.getParameters()) {
                    CifType pt = param.getParameter().getType();
                    t.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)pt)));
                }
                if (!CifTypeUtils.checkTypeCompat((CifType)t, (CifType)ftype, RangeCompat.EQUAL)) continue;
                function = func;
                break;
            }
            if (function == null) {
                function = CifConstructors.newInternalFunction();
                int i = 0;
                while (i < ftype.getParamTypes().size()) {
                    CifType ptype = (CifType)ftype.getParamTypes().get(i);
                    DiscVariable pvar = CifConstructors.newDiscVariable();
                    pvar.setName("p" + i);
                    pvar.setType((CifType)EMFHelper.deepclone((EObject)ptype));
                    FunctionParameter param = CifConstructors.newFunctionParameter();
                    param.setParameter(pvar);
                    function.getParameters().add((Object)param);
                    ++i;
                }
                CifType rtype = ftype.getReturnType();
                function.getReturnTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)rtype)));
                Expression retValue = CifValueUtils.getDefaultValue(ftype.getReturnType(), funcs);
                ReturnFuncStatement stat = CifConstructors.newReturnFuncStatement();
                stat.getValues().add((Object)retValue);
                function.getStatements().add((Object)stat);
                funcs.add(function);
            }
            FunctionExpression rslt = CifConstructors.newFunctionExpression();
            rslt.setFunction((Function)function);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)ftype));
            return rslt;
        }
        if (type instanceof DictType) {
            DictExpression rslt = CifConstructors.newDictExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            return rslt;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            TupleExpression rslt = CifConstructors.newTupleExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            for (Field field : ttype.getFields()) {
                Expression value = CifValueUtils.getDefaultValue(field.getType(), funcs);
                rslt.getFields().add((Object)value);
            }
            return rslt;
        }
        if (type instanceof DistType) {
            DistType dtype = (DistType)type;
            FuncType ftype = CifConstructors.newFuncType();
            ftype.setReturnType((CifType)EMFHelper.deepclone((EObject)type));
            ftype.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)dtype.getSampleType())));
            StdLibFunctionExpression func = CifConstructors.newStdLibFunctionExpression();
            func.setFunction(StdLibFunction.CONSTANT);
            func.setType((CifType)ftype);
            Expression param = CifValueUtils.getDefaultValue(dtype.getSampleType(), funcs);
            FunctionCallExpression rslt = CifConstructors.newFunctionCallExpression();
            rslt.setType((CifType)EMFHelper.deepclone((EObject)type));
            rslt.setFunction((Expression)func);
            rslt.getParams().add((Object)param);
            return rslt;
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    public static boolean isInitialExpr(Expression expr) {
        Expression parent = expr;
        EStructuralFeature feat = null;
        while (parent instanceof Expression) {
            feat = parent.eContainingFeature();
            parent = parent.eContainer();
        }
        Assert.notNull(feat);
        if (parent instanceof VariableValue) {
            DiscVariable var = (DiscVariable)parent.eContainer();
            return var.eContainer() instanceof ComplexComponent;
        }
        if (parent instanceof ContVariable && feat == DeclarationsPackage.Literals.CONT_VARIABLE__VALUE) {
            return true;
        }
        if (parent instanceof ComplexComponent && feat == CifPackage.Literals.COMPLEX_COMPONENT__INITIALS) {
            return true;
        }
        return parent instanceof Location && feat == AutomataPackage.Literals.LOCATION__INITIALS;
    }

    public static boolean isTimeConstant(Expression expr) {
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof TimeExpression) {
            return false;
        }
        if (expr instanceof CastExpression) {
            CastExpression cexpr = (CastExpression)expr;
            return CifValueUtils.isTimeConstant(cexpr.getChild());
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression uexpr = (UnaryExpression)expr;
            return CifValueUtils.isTimeConstant(uexpr.getChild());
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            return CifValueUtils.isTimeConstant(bexpr.getLeft()) && CifValueUtils.isTimeConstant(bexpr.getRight());
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            for (Expression guard : ifExpr.getGuards()) {
                if (CifValueUtils.isTimeConstant(guard)) continue;
                return false;
            }
            if (!CifValueUtils.isTimeConstant(ifExpr.getThen())) {
                return false;
            }
            for (ElifExpression elif : ifExpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    if (CifValueUtils.isTimeConstant(guard)) continue;
                    return false;
                }
                if (CifValueUtils.isTimeConstant(elif.getThen())) continue;
                return false;
            }
            return CifValueUtils.isTimeConstant(ifExpr.getElse());
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            if (!CifValueUtils.isTimeConstant(switchExpr.getValue())) {
                return false;
            }
            for (SwitchCase cse : switchExpr.getCases()) {
                if (cse.getKey() != null && !CifValueUtils.isTimeConstant(cse.getKey())) {
                    return false;
                }
                if (CifValueUtils.isTimeConstant(cse.getValue())) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            if (!CifValueUtils.isTimeConstant(pexpr.getChild())) {
                return false;
            }
            if (pexpr.getIndex() instanceof FieldExpression) {
                return true;
            }
            return CifValueUtils.isTimeConstant(pexpr.getIndex());
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            if (!CifValueUtils.isTimeConstant(sexpr.getChild())) {
                return false;
            }
            if (sexpr.getBegin() != null && !CifValueUtils.isTimeConstant(sexpr.getBegin())) {
                return false;
            }
            return sexpr.getEnd() == null || CifValueUtils.isTimeConstant(sexpr.getEnd());
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fcexpr = (FunctionCallExpression)expr;
            if (!(fcexpr.getFunction() instanceof StdLibFunctionExpression) && !CifValueUtils.isTimeConstant(fcexpr.getFunction())) {
                return false;
            }
            for (Expression param : fcexpr.getParams()) {
                if (CifValueUtils.isTimeConstant(param)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.isTimeConstant(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.isTimeConstant(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression elem : texpr.getFields()) {
                if (CifValueUtils.isTimeConstant(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.isTimeConstant(pair.getKey())) {
                    return false;
                }
                if (CifValueUtils.isTimeConstant(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ConstantExpression) {
            return true;
        }
        if (expr instanceof DiscVariableExpression) {
            return true;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            Expression value = var.getValue();
            if (value != null) {
                return CifValueUtils.isTimeConstant(value);
            }
            if (var.eContainer() instanceof Parameter) {
                throw new RuntimeException("unsupported alg param: " + var);
            }
            List<Expression> values = CifEquationUtils.getValuesForAlgVar(var, false);
            for (Expression val : values) {
                if (CifValueUtils.isTimeConstant(val)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            if (cexpr.isDerivative()) {
                ContVariable var = cexpr.getVariable();
                Expression deriv = var.getDerivative();
                if (deriv != null) {
                    return CifValueUtils.isTimeConstant(deriv);
                }
                List<Expression> derivs = CifEquationUtils.getDerivativesForContVar(var, false);
                for (Expression d : derivs) {
                    if (CifValueUtils.isTimeConstant(d)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expr instanceof TauExpression) {
            throw new RuntimeException("Tau expression in value context.");
        }
        if (expr instanceof LocationExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof EventExpression) {
            throw new RuntimeException("Event expression in value context.");
        }
        if (expr instanceof FieldExpression) {
            String msg = "Unexpected field expr: proj expr should handle it.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof StdLibFunctionExpression) {
            String msg = "Stdlib functions can not be used as values.";
            throw new RuntimeException(msg);
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof InputVariableExpression) {
            return false;
        }
        if (expr instanceof ComponentExpression) {
            return true;
        }
        if (expr instanceof CompInstWrapExpression) {
            Expression rexpr = ((CompInstWrapExpression)expr).getReference();
            return CifValueUtils.isTimeConstant(rexpr);
        }
        if (expr instanceof CompParamWrapExpression) {
            Expression rexpr = ((CompParamWrapExpression)expr).getReference();
            return CifValueUtils.isTimeConstant(rexpr);
        }
        if (expr instanceof ReceivedExpression) {
            return true;
        }
        if (expr instanceof SelfExpression) {
            return true;
        }
        throw new RuntimeException("Unknown expr: " + expr);
    }

    public static Expression createConjunction(List<Expression> exprs) {
        return CifValueUtils.createConjunction(exprs, false);
    }

    public static Expression createConjunction(List<Expression> exprs, boolean optimize) {
        if (exprs.isEmpty()) {
            return CifValueUtils.makeTrue();
        }
        BinaryOperator operator = BinaryOperator.CONJUNCTION;
        List flattenedChildren = CifValueUtils.flattenBinExpr(exprs, operator);
        if (optimize) {
            List children = Lists.listc((int)flattenedChildren.size());
            for (Expression child : flattenedChildren) {
                boolean add = true;
                if (child instanceof BoolExpression) {
                    boolean value = ((BoolExpression)child).isValue();
                    if (!value) {
                        return child;
                    }
                    add = false;
                }
                if (!add) continue;
                children.add(child);
            }
            if (children.isEmpty()) {
                return CifValueUtils.makeTrue();
            }
            flattenedChildren = children;
        }
        int treeSize = flattenedChildren.size();
        return CifValueUtils.createBalancedBinaryTree(flattenedChildren, 0, treeSize, operator);
    }

    public static Expression createDisjunction(List<Expression> exprs) {
        return CifValueUtils.createDisjunction(exprs, false);
    }

    public static Expression createDisjunction(List<Expression> exprs, boolean optimize) {
        if (exprs.isEmpty()) {
            return CifValueUtils.makeFalse();
        }
        BinaryOperator operator = BinaryOperator.DISJUNCTION;
        List flattenedChildren = CifValueUtils.flattenBinExpr(exprs, operator);
        if (optimize) {
            List children = Lists.listc((int)flattenedChildren.size());
            for (Expression child : flattenedChildren) {
                boolean add = true;
                if (child instanceof BoolExpression) {
                    boolean value = ((BoolExpression)child).isValue();
                    if (value) {
                        return child;
                    }
                    add = false;
                }
                if (!add) continue;
                children.add(child);
            }
            if (children.isEmpty()) {
                return CifValueUtils.makeFalse();
            }
            flattenedChildren = children;
        }
        int treeSize = flattenedChildren.size();
        return CifValueUtils.createBalancedBinaryTree(flattenedChildren, 0, treeSize, operator);
    }

    public static List<Expression> flattenBinExpr(List<Expression> exprs, BinaryOperator operator) {
        if (exprs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<Expression> todos = new ArrayDeque<Expression>(exprs);
        List children = Lists.listc((int)todos.size());
        while (!todos.isEmpty()) {
            BinaryExpression btodo;
            Expression todo = todos.pollFirst();
            if (todo instanceof BinaryExpression && (btodo = (BinaryExpression)todo).getOperator() == operator) {
                todos.addFirst(btodo.getRight());
                todos.addFirst(btodo.getLeft());
                continue;
            }
            children.add(todo);
        }
        return children;
    }

    public static Expression createBalancedBinaryTree(List<Expression> exprs, int lower, int upper, BinaryOperator operator) {
        Assert.check((lower < upper ? 1 : 0) != 0);
        if (lower + 1 == upper) {
            return exprs.get(lower);
        }
        int size = upper - lower;
        int left = size / 2;
        int mid = lower + left;
        BinaryExpression rslt = CifConstructors.newBinaryExpression();
        rslt.setOperator(operator);
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setLeft(CifValueUtils.createBalancedBinaryTree(exprs, lower, mid, operator));
        rslt.setRight(CifValueUtils.createBalancedBinaryTree(exprs, mid, upper, operator));
        return rslt;
    }

    public static Expression makeInverse(Expression expr) {
        UnaryExpression rslt = CifConstructors.newUnaryExpression();
        rslt.setOperator(UnaryOperator.INVERSE);
        rslt.setType((CifType)CifConstructors.newBoolType());
        rslt.setChild(expr);
        return rslt;
    }

    public static BoolExpression makeFalse() {
        BoolExpression rslt = CifConstructors.newBoolExpression();
        rslt.setValue(false);
        rslt.setType((CifType)CifConstructors.newBoolType());
        return rslt;
    }

    public static BoolExpression makeTrue() {
        BoolExpression rslt = CifConstructors.newBoolExpression();
        rslt.setValue(true);
        rslt.setType((CifType)CifConstructors.newBoolType());
        return rslt;
    }

    public static Expression makeInt(int value) {
        if (value == Integer.MIN_VALUE) {
            Expression left = CifValueUtils.makeInt(value + 1);
            Expression right = CifValueUtils.makeInt(1);
            IntType binType = CifConstructors.newIntType();
            binType.setLower(Integer.valueOf(value));
            binType.setUpper(Integer.valueOf(value));
            BinaryExpression bin = CifConstructors.newBinaryExpression();
            bin.setOperator(BinaryOperator.SUBTRACTION);
            bin.setLeft(left);
            bin.setRight(right);
            bin.setType((CifType)binType);
            return bin;
        }
        int absValue = Math.abs(value);
        IntType absType = CifConstructors.newIntType();
        absType.setLower(Integer.valueOf(absValue));
        absType.setUpper(Integer.valueOf(absValue));
        IntExpression absExpr = CifConstructors.newIntExpression();
        absExpr.setValue(absValue);
        absExpr.setType((CifType)absType);
        if (value >= 0) {
            return absExpr;
        }
        IntType unType = CifConstructors.newIntType();
        unType.setLower(Integer.valueOf(value));
        unType.setUpper(Integer.valueOf(value));
        UnaryExpression un = CifConstructors.newUnaryExpression();
        un.setOperator(UnaryOperator.NEGATE);
        un.setChild((Expression)absExpr);
        un.setType((CifType)unType);
        return un;
    }

    public static Expression makeTuple(List<Expression> elements) {
        Assert.check((!elements.isEmpty() ? 1 : 0) != 0);
        if (elements.size() == 1) {
            return (Expression)Lists.first(elements);
        }
        TupleType tupleType = CifConstructors.newTupleType();
        for (Expression element : elements) {
            Field field = CifConstructors.newField();
            field.setType((CifType)EMFHelper.deepclone((EObject)element.getType()));
            tupleType.getFields().add((Object)field);
        }
        TupleExpression tuple = CifConstructors.newTupleExpression();
        tuple.getFields().addAll(elements);
        tuple.setType((CifType)tupleType);
        return tuple;
    }

    public static Field getTupleProjField(ProjectionExpression pexpr) {
        int idx;
        Expression iexpr = pexpr.getIndex();
        if (iexpr instanceof FieldExpression) {
            return ((FieldExpression)iexpr).getField();
        }
        try {
            idx = (Integer)CifEvalUtils.eval(iexpr, false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
        CifType ctype = CifTypeUtils.normalizeType(pexpr.getChild().getType());
        return (Field)((TupleType)ctype).getFields().get(idx);
    }

    public static double getPossibleValueCount(CifType type) {
        if ((type = CifTypeUtils.normalizeType(type)) instanceof BoolType) {
            return 2.0;
        }
        if (type instanceof RealType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof StringType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            return enumDecl.getLiterals().size();
        }
        if (type instanceof IntType) {
            IntType itype = (IntType)type;
            int lower = CifTypeUtils.getLowerBound(itype);
            int upper = CifTypeUtils.getUpperBound(itype);
            return (double)upper - (double)lower + 1.0;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            double ecnt = CifValueUtils.getPossibleValueCount(stype.getElementType());
            return Math.pow(2.0, ecnt);
        }
        if (type instanceof DictType) {
            DictType dtype = (DictType)type;
            double kcnt = CifValueUtils.getPossibleValueCount(dtype.getKeyType());
            double vcnt = CifValueUtils.getPossibleValueCount(dtype.getValueType());
            return Math.pow(vcnt + 1.0, kcnt);
        }
        if (type instanceof ListType) {
            int upper;
            ListType ltype = (ListType)type;
            double ecnt = CifValueUtils.getPossibleValueCount(ltype.getElementType());
            int lower = CifTypeUtils.getLowerBound(ltype);
            if (lower == (upper = CifTypeUtils.getUpperBound(ltype))) {
                return Math.pow(ecnt, lower);
            }
            if (Double.isInfinite(ecnt)) {
                return ecnt;
            }
            double cnt = CifValueUtils.expSum(ecnt, (double)upper + 1.0);
            if (lower > 0) {
                cnt -= CifValueUtils.expSum(ecnt, lower);
            }
            return cnt;
        }
        if (type instanceof TupleType) {
            double cnt = 1.0;
            TupleType ttype = (TupleType)type;
            for (Field field : ttype.getFields()) {
                cnt *= CifValueUtils.getPossibleValueCount(field.getType());
            }
            return cnt;
        }
        if (type instanceof FuncType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type instanceof DistType) {
            return Double.POSITIVE_INFINITY;
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    public static double expSum(double n, double m) {
        Assert.check((n >= 0.0 || Double.isInfinite(n) ? 1 : 0) != 0);
        Assert.check((m >= 0.0 || Double.isInfinite(m) ? 1 : 0) != 0);
        return n == 1.0 ? m : (1.0 - Math.pow(n, m)) / (1.0 - n);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Expression> getPossibleValues(CifType type) {
        block20: {
            if ((type = CifTypeUtils.normalizeType(type)) instanceof BoolType) {
                return Lists.list((Object[])new BoolExpression[]{CifValueUtils.makeFalse(), CifValueUtils.makeTrue()});
            }
            if (type instanceof EnumType) {
                enumDecl = ((EnumType)type).getEnum();
                lits = enumDecl.getLiterals();
                values = Lists.listc((int)lits.size());
                for (EnumLiteral lit : lits) {
                    litRef = CifConstructors.newEnumLiteralExpression();
                    litRef.setLiteral(lit);
                    litRef.setType((CifType)EMFHelper.deepclone((EObject)type));
                    values.add(litRef);
                }
                return values;
            }
            if (type instanceof IntType) {
                itype = (IntType)type;
                lower = CifTypeUtils.getLowerBound(itype);
                upper = CifTypeUtils.getUpperBound(itype);
                cnt = (long)upper - (long)lower + 1L;
                values = Lists.listc((int)((int)cnt));
                i = lower;
                while (i <= upper) {
                    values.add(CifValueUtils.makeInt(i));
                    ++i;
                }
                return values;
            }
            if (!(type instanceof ListType)) break block20;
            ltype = (ListType)type;
            elemValues = CifValueUtils.getPossibleValues(ltype.getElementType());
            lower = CifTypeUtils.getLowerBound(ltype);
            upper = CifTypeUtils.getUpperBound(ltype);
            lists = Lists.listc((int)((int)CifValueUtils.getPossibleValueCount(type)));
            if (lower == 0) {
                emptyList = CifConstructors.newListExpression();
                emptyList.setType((CifType)EMFHelper.deepclone((EObject)type));
                lists.add(emptyList);
            }
            elemsValues = Lists.listc((int)upper);
            len = lower;
            ** GOTO lbl59
            {
                elemsValues.add(elemValues);
                do {
                    if (elemsValues.size() < len) continue block2;
                    iter = new ListProductIterator(elemsValues);
                    while (iter.hasNext()) {
                        elems = iter.next();
                        array = CifConstructors.newListExpression();
                        for (Expression elem : elems) {
                            array.getElements().add((Object)((Expression)EMFHelper.deepclone((EObject)elem)));
                        }
                        array.setType((CifType)EMFHelper.deepclone((EObject)ltype));
                        lists.add(array);
                    }
                    ++len;
lbl59:
                    // 2 sources

                } while (len <= upper);
            }
            return lists;
        }
        if (type instanceof SetType) {
            stype = (SetType)type;
            elemValues = CifValueUtils.getPossibleValues(stype.getElementType());
            powerset = CifValueUtils.powerSet(elemValues);
            sets = Lists.listc((int)powerset.size());
            for (List<Expression> elems : powerset) {
                sets.add(CifConstructors.newSetExpression(elems, null, (CifType)((CifType)EMFHelper.deepclone((EObject)type))));
            }
            return sets;
        }
        if (type instanceof DictType) {
            dtype = (DictType)type;
            keyValues = CifValueUtils.getPossibleValues(dtype.getKeyType());
            valueValues = CifValueUtils.getPossibleValues(dtype.getValueType());
            powerset = CifValueUtils.powerSet(keyValues);
            dicts = Lists.listc((int)((int)CifValueUtils.getPossibleValueCount(type)));
            emptyDict = CifConstructors.newDictExpression();
            emptyDict.setType((CifType)EMFHelper.deepclone((EObject)type));
            dicts.add(emptyDict);
            for (List<Expression> keys : powerset) {
                if (keys.isEmpty()) continue;
                combis = Lists.listc((int)keys.size());
                i = 0;
                while (i < keys.size()) {
                    combis.add(EMFHelper.deepclone(valueValues));
                    ++i;
                }
                iter = new ListProductIterator(combis);
                while (iter.hasNext()) {
                    singleDict = CifConstructors.newDictExpression();
                    singleDict.setType((CifType)EMFHelper.deepclone((EObject)type));
                    values = iter.next();
                    i = 0;
                    while (i < keys.size()) {
                        key = (Expression)EMFHelper.deepclone((EObject)keys.get(i));
                        value = (Expression)EMFHelper.deepclone((EObject)((Expression)values.get(i)));
                        pair = CifConstructors.newDictPair((Expression)key, null, (Expression)value);
                        singleDict.getPairs().add((Object)pair);
                        ++i;
                    }
                    dicts.add(singleDict);
                }
            }
            return dicts;
        }
        if (type instanceof TupleType) {
            ttype = (TupleType)type;
            fieldsValues = Lists.listc((int)ttype.getFields().size());
            cnt = 1;
            for (Field field : ttype.getFields()) {
                fieldValues = CifValueUtils.getPossibleValues(field.getType());
                fieldsValues.add(fieldValues);
                cnt *= fieldValues.size();
            }
            values = Lists.listc((int)cnt);
            iter = new ListProductIterator(fieldsValues);
            while (iter.hasNext()) {
                elems = iter.next();
                values.add(CifValueUtils.makeTuple(EMFHelper.deepclone((List)elems)));
            }
            return values;
        }
        throw new RuntimeException("Unexpected type: " + type);
    }

    private static List<List<Expression>> powerSet(List<Expression> set) {
        int cnt = (int)Math.pow(2.0, set.size());
        List powerset = Lists.listc((int)cnt);
        BitSet combinations = new BitSet(set.size());
        do {
            List singleSet = Lists.listc((int)combinations.cardinality());
            int i = 0;
            while (i < set.size()) {
                if (combinations.get(i)) {
                    singleSet.add((Expression)EMFHelper.deepclone((EObject)set.get(i)));
                }
                ++i;
            }
            powerset.add(singleSet);
        } while (CifValueUtils.incBitSet(combinations, set.size()));
        return powerset;
    }

    private static boolean incBitSet(BitSet bitset, int bitCnt) {
        int i = 0;
        while (i < bitCnt) {
            boolean b = bitset.get(i);
            bitset.set(i, !b);
            if (!b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLiteralExpr(Expression expr) {
        UnaryExpression uexpr;
        if (expr instanceof BoolExpression) {
            return true;
        }
        if (expr instanceof IntExpression) {
            return true;
        }
        if (expr instanceof RealExpression) {
            return true;
        }
        if (expr instanceof StringExpression) {
            return true;
        }
        if (expr instanceof EnumLiteralExpression) {
            return true;
        }
        if (expr instanceof FunctionExpression) {
            return true;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                if (CifValueUtils.isLiteralExpr(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                if (CifValueUtils.isLiteralExpr(elem)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                if (!CifValueUtils.isLiteralExpr(pair.getKey())) {
                    return false;
                }
                if (CifValueUtils.isLiteralExpr(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                if (CifValueUtils.isLiteralExpr(field)) continue;
                return false;
            }
            return true;
        }
        if (expr instanceof UnaryExpression && (uexpr = (UnaryExpression)expr).getOperator() == UnaryOperator.NEGATE) {
            Expression child = uexpr.getChild();
            if (child instanceof IntExpression) {
                return ((IntExpression)child).getValue() >= 0;
            }
            if (child instanceof RealExpression) {
                return true;
            }
        }
        return false;
    }
}

