/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;

public class SwitchesToIfs
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        this.walkSpecification(spec);
    }

    protected void walkSwitchExpression(SwitchExpression switchExpr) {
        EList cases = switchExpr.getCases();
        if (cases.size() == 1) {
            EMFHelper.updateParentContainment((EObject)switchExpr, (EObject)((SwitchCase)Lists.first((List)cases)).getValue());
            return;
        }
        Expression value = switchExpr.getValue();
        boolean isAutRef = CifTypeUtils.isAutRefExpr((Expression)value);
        for (SwitchCase cse : switchExpr.getCases()) {
            Expression key = cse.getKey();
            if (key == null || isAutRef) continue;
            BinaryExpression bexpr = CifConstructors.newBinaryExpression();
            bexpr.setOperator(BinaryOperator.EQUAL);
            bexpr.setType((CifType)CifConstructors.newBoolType());
            bexpr.setLeft((Expression)EMFHelper.deepclone((EObject)value));
            bexpr.setRight(key);
            cse.setKey((Expression)bexpr);
        }
        IfExpression ifExpr = CifConstructors.newIfExpression();
        ifExpr.setType(switchExpr.getType());
        ifExpr.getGuards().add((Object)((SwitchCase)Lists.first((List)cases)).getKey());
        ifExpr.setThen(((SwitchCase)Lists.first((List)cases)).getValue());
        EList elifs = ifExpr.getElifs();
        int i = 1;
        while (i < cases.size() - 1) {
            ElifExpression elifExpr = CifConstructors.newElifExpression();
            elifs.add(elifExpr);
            SwitchCase cse = (SwitchCase)cases.get(i);
            elifExpr.getGuards().add((Object)cse.getKey());
            elifExpr.setThen(cse.getValue());
            ++i;
        }
        ifExpr.setElse(((SwitchCase)Lists.last((List)cases)).getValue());
        EMFHelper.updateParentContainment((EObject)switchExpr, (EObject)ifExpr);
    }
}

