/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceNodeQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.RangeSetter;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CombinedFragment
extends AbstractFrame {
    public static final int VISUAL_ID = 2002;
    public static final int COMPARTMENT_VISUAL_ID = 7001;

    CombinedFragment(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)CombinedFragment.notationPredicate().apply((Object)node), (Object)Messages.CombinedFragment_nonCombinedFragmentNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 2002, CombinedFragment.viewpointElementPredicate());
    }

    public static Predicate<View> compartmentNotationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 7001, CombinedFragment.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    @Override
    public Range getVerticalRange() {
        return new SequenceNodeQuery(this.getNotationNode()).getVerticalRange();
    }

    @Override
    public void setVerticalRange(Range range) throws IllegalStateException {
        RangeSetter.setVerticalRange(this, range);
    }

    @Override
    public List<ISequenceEvent> getSubEvents() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getOperands(), ISequenceEvent.class));
    }

    public List<Operand> getOperands() {
        ArrayList<Operand> result = new ArrayList<Operand>();
        Predicate<View> compartementView = new Predicate<View>(){

            public boolean apply(View input) {
                return input.getType().equals(Integer.toString(7001));
            }
        };
        for (View view : Iterables.filter((Iterable)Iterables.filter((Iterable)this.view.eContents(), View.class), (Predicate)compartementView)) {
            for (View viewChild : Iterables.filter((Iterable)view.eContents(), View.class)) {
                Option<Operand> operand = ISequenceElementAccessor.getOperand(viewChild);
                if (!operand.some()) continue;
                result.add((Operand)operand.get());
            }
        }
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return result;
    }

    public Option<Operand> getOperand(int index) {
        try {
            return Options.newSome((Object)this.getOperands().get(index));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return Options.newNone();
        }
    }

    public int getIndexOfOperand(Operand operand) {
        return this.getOperands().lastIndexOf(operand);
    }

    public Operand getFirstOperand() {
        return (Operand)this.getOperand(0).get();
    }

    public Operand getLastOperand() {
        int lastIndex = this.getOperands().size() - 1;
        return (Operand)this.getOperand(lastIndex).get();
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getCombinedFragmentMapping());
        }
    }
}

