/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class JavaClassPrepareBreakpoint
extends JavaBreakpoint
implements IJavaClassPrepareBreakpoint {
    public static final String JAVA_CLASS_PREPARE_BREAKPOINT = "org.eclipse.jdt.debug.javaClassPrepareBreakpointMarker";
    protected static final String MEMBER_TYPE = "org.eclipse.jdt.debug.core.memberType";
    private Pattern pattern = null;

    public JavaClassPrepareBreakpoint(final IResource resource, final String typeName, final int memberType, final int charStart, final int charEnd, final boolean add, final Map<String, Object> attributes) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaClassPrepareBreakpoint.this.setMarker(resource.createMarker(JavaClassPrepareBreakpoint.JAVA_CLASS_PREPARE_BREAKPOINT));
                attributes.put("org.eclipse.debug.core.id", JavaClassPrepareBreakpoint.this.getModelIdentifier());
                attributes.put("charStart", charStart);
                attributes.put("charEnd", charEnd);
                attributes.put("org.eclipse.jdt.debug.core.typeName", typeName);
                attributes.put(JavaClassPrepareBreakpoint.MEMBER_TYPE, memberType);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", JavaClassPrepareBreakpoint.this.getDefaultSuspendPolicy());
                JavaClassPrepareBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaClassPrepareBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public JavaClassPrepareBreakpoint() {
    }

    @Override
    protected void createRequests(JDIDebugTarget target) throws CoreException {
        if (target.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        String referenceTypeName = this.getTypeName();
        if (referenceTypeName == null) {
            return;
        }
        ClassPrepareRequest request = target.createClassPrepareRequest(referenceTypeName, null, false);
        this.configureRequestHitCount(request);
        this.updateEnabledState(request, target);
        this.registerRequest(request, target);
        this.incrementInstallCount();
    }

    @Override
    protected void deregisterRequest(EventRequest request, JDIDebugTarget target) throws CoreException {
        target.removeJDIEventListener(this, request);
        if (this.getMarker().exists()) {
            this.decrementInstallCount();
        }
    }

    @Override
    protected void addInstanceFilter(EventRequest request, ObjectReference object) {
    }

    @Override
    protected EventRequest[] newRequests(JDIDebugTarget target, ReferenceType type) throws CoreException {
        return null;
    }

    @Override
    protected void setRequestThreadFilter(EventRequest request, ThreadReference thread) {
    }

    @Override
    public boolean handleClassPrepareEvent(ClassPrepareEvent event, JDIDebugTarget target, boolean suspendVote) {
        block4: {
            JDIThread thread;
            block5: {
                try {
                    if (this.pattern == null) {
                        String typeName = ".*";
                        String breakpointName = this.ensureMarker().getAttribute("org.eclipse.jdt.debug.core.typeName", null);
                        typeName = String.valueOf(typeName) + breakpointName.replaceAll("\\.", "\\\\.");
                        typeName = typeName.replaceAll("\\$", "\\\\\\$");
                        typeName = typeName.concat(".*");
                        this.pattern = Pattern.compile(typeName);
                    }
                    if (!this.isEnabled() || !this.pattern.matcher(event.referenceType().name()).find()) break block4;
                    ThreadReference threadRef = event.thread();
                    thread = target.findThread(threadRef);
                    if (thread != null && !thread.isIgnoringBreakpoints()) break block5;
                    return true;
                }
                catch (CoreException coreException) {}
            }
            this.fInstalledTypeName = event.referenceType().name();
            return this.handleBreakpointEvent(event, thread, suspendVote);
        }
        return true;
    }

    @Override
    protected void classPrepareComplete(Event event, JDIThread thread, boolean suspend, EventSet eventSet) {
        thread.completeBreakpointHandling(this, suspend, true, eventSet);
    }

    @Override
    public int getMemberType() throws CoreException {
        return this.ensureMarker().getAttribute(MEMBER_TYPE, 0);
    }

    @Override
    public boolean supportsInstanceFilters() {
        return false;
    }

    @Override
    public void addInstanceFilter(IJavaObject object) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, JDIDebugBreakpointMessages.JavaClassPrepareBreakpoint_2, null));
    }

    @Override
    public void setThreadFilter(IJavaThread thread) throws CoreException {
        throw new CoreException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, JDIDebugBreakpointMessages.JavaClassPrepareBreakpoint_3, null));
    }

    @Override
    public boolean supportsThreadFilters() {
        return false;
    }
}

