/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates.tree;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.FindDeclarationUsage;
import org.eclipse.escet.cif.codegen.updates.ReadWriteDeclarations;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.codegen.updates.tree.UpdateData;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class AssignmentUpdate
extends UpdateData {
    public final Expression addressable;
    public final Expression value;

    public AssignmentUpdate(Expression addressable, Expression value) {
        this.addressable = addressable;
        this.value = value;
    }

    @Override
    public ReadWriteDeclarations collectVariableUsage(CodeContext ctxt) {
        Set read = Sets.set();
        Set written = Sets.set();
        ReadWriteDeclarations rwDecls = new ReadWriteDeclarations(read, written);
        FindDeclarationUsage.collectUse(this.value, (Set<VariableWrapper>)read);
        FindDeclarationUsage.collectAssign(this.addressable, rwDecls);
        for (VariableWrapper wVar : Sets.copy((Set)written)) {
            written.addAll(ctxt.getAffectedAlgebraicDerivativeExpressions(wVar));
        }
        return rwDecls;
    }

    @Override
    protected void addLocalCopies(Set<VariableWrapper> copiedVars) {
    }

    @Override
    public void genCode(CodeBox code, boolean safeScope, CodeContext readCtxt, CodeContext writeCtxt) {
        List<SingleVariableAssignment> assigns = this.getSingleAssignments(this.addressable, this.value.getType(), null);
        int reservedRange = readCtxt.reserveTempVariables();
        MemoryCodeBox localCode = readCtxt.makeCodeBox();
        if (assigns.size() == 1) {
            SingleVariableAssignment asg = assigns.get(0);
            if (asg.lhsProjections == null && !asg.needsRangeBoundCheck()) {
                writeCtxt.performSingleAssign((CodeBox)localCode, assigns.get(0), this.value, readCtxt);
                if (readCtxt.countCreatedTempVariables() > 0) {
                    if (!safeScope) {
                        readCtxt.addUpdatesBeginScope(code);
                    }
                    code.add((Box)localCode);
                    if (!safeScope) {
                        readCtxt.addUpdatesEndScope(code);
                    }
                } else {
                    code.add((Box)localCode);
                }
                readCtxt.unreserveTempVariables(reservedRange);
                return;
            }
        }
        VariableInformation tmpVar = writeCtxt.makeTempVariable(this.value.getType(), "rhs");
        Destination dest = writeCtxt.makeDestination(tmpVar);
        ExprCode rhsCode = readCtxt.exprToTarget(this.value, null);
        localCode.add((Box)rhsCode.getCode());
        tmpVar.typeInfo.declareInit((CodeBox)localCode, rhsCode.getRawDataValue(), dest);
        for (SingleVariableAssignment varAsgn : assigns) {
            String rhsText = tmpVar.targetName;
            if (varAsgn.rhsProjections != null) {
                TypeInfo rhsTi = tmpVar.typeInfo;
                boolean safe = false;
                int[] nArray = varAsgn.rhsProjections;
                int n = varAsgn.rhsProjections.length;
                int n2 = 0;
                while (n2 < n) {
                    int fieldNumber = nArray[n2];
                    TupleTypeInfo tIt = (TupleTypeInfo)rhsTi;
                    rhsText = tIt.appendProjection(rhsText, safe, fieldNumber);
                    safe = true;
                    ++n2;
                }
            }
            writeCtxt.performAssign((CodeBox)localCode, varAsgn, rhsText, readCtxt);
        }
        if (readCtxt.countCreatedTempVariables() > 0) {
            if (!safeScope) {
                readCtxt.addUpdatesBeginScope(code);
            }
            code.add((Box)localCode);
            if (!safeScope) {
                readCtxt.addUpdatesEndScope(code);
            }
        } else {
            code.add((Box)localCode);
        }
        readCtxt.unreserveTempVariables(reservedRange);
    }

    private List<SingleVariableAssignment> getSingleAssignments(Expression addressable, CifType valueType, List<Integer> projections) {
        if (addressable instanceof TupleExpression) {
            if (projections == null) {
                projections = Lists.list();
            }
            TupleExpression lhsTuple = (TupleExpression)addressable;
            TupleType valueTupleType = (TupleType)valueType;
            List result = Lists.list();
            int projIndex = projections.size();
            projections.add(0);
            int i = 0;
            while (i < lhsTuple.getFields().size()) {
                projections.set(projIndex, i);
                Expression fieldValue = (Expression)lhsTuple.getFields().get(i);
                CifType fieldType = ((Field)valueTupleType.getFields().get(i)).getType();
                result.addAll(this.getSingleAssignments(fieldValue, fieldType, projections));
                ++i;
            }
            projections.remove(projIndex);
            return result;
        }
        int[] rhsProjections = null;
        if (projections != null) {
            rhsProjections = new int[projections.size()];
            int i = 0;
            while (i < projections.size()) {
                rhsProjections[i] = (Integer)projections.get(i);
                ++i;
            }
        }
        return Lists.list((Object)new SingleVariableAssignment(addressable, valueType, rhsProjections));
    }

    public static List<UpdateData> newAssignmentUpdate(Assignment asg) {
        List updates = Lists.list();
        AssignmentUpdate.newAssignmentUpdate(asg.getAddressable(), asg.getValue(), updates);
        Assert.check((!updates.isEmpty() ? 1 : 0) != 0);
        return updates;
    }

    public static List<UpdateData> newAssignmentUpdate(AssignmentFuncStatement asg) {
        List updates = Lists.list();
        AssignmentUpdate.newAssignmentUpdate(asg.getAddressable(), asg.getValue(), updates);
        Assert.check((!updates.isEmpty() ? 1 : 0) != 0);
        return updates;
    }

    private static void newAssignmentUpdate(Expression addressable, Expression value, List<UpdateData> updates) {
        if (addressable instanceof TupleExpression && value instanceof TupleExpression) {
            TupleExpression addrTuple = (TupleExpression)addressable;
            TupleExpression valTuple = (TupleExpression)value;
            int i = 0;
            while (i < addrTuple.getFields().size()) {
                AssignmentUpdate.newAssignmentUpdate((Expression)addrTuple.getFields().get(i), (Expression)valTuple.getFields().get(i), updates);
                ++i;
            }
            return;
        }
        updates.add(new AssignmentUpdate(addressable, value));
    }
}

