/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89.typeinfos;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprProperties;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RealTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class C89RealTypeInfo
extends RealTypeInfo
implements C89TypeInfo {
    private static final Map<StdLibFunction, String> STANDARD_FUNCTIONS = Maps.mapc((int)9);
    public final boolean genLocalFunctions;

    static {
        STANDARD_FUNCTIONS.put(StdLibFunction.ACOS, "RealAcos(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.ASIN, "RealAsin(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.ATAN, "RealAtan(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.COS, "RealCos(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.SIN, "RealSin(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.TAN, "RealTan(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.EXP, "RealExp(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.LOG, "RealLog(${args})");
        STANDARD_FUNCTIONS.put(StdLibFunction.LN, "RealLn(${args})");
    }

    public C89RealTypeInfo(boolean genLocalFunctions, CifType cifType) {
        super(cifType);
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return true;
    }

    @Override
    public boolean useValues() {
        return true;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return "RealTypePrint";
    }

    @Override
    public ExprCode convertNegate(UnaryExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(expr.getChild(), null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeValue(Strings.fmt((String)"RealNegate(%s)", (Object[])new Object[]{childCode.getData()})));
        return result;
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "(${left-value}) == (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "(${left-value}) != (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_THAN)) {
            return "(${left-value}) < (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_EQUAL)) {
            return "(${left-value}) <= (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_THAN)) {
            return "(${left-value}) > (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_EQUAL)) {
            return "(${left-value}) >= (${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public ExprCode convertLiteral(String value, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeLiteral(value));
        return result;
    }

    @Override
    public ExprCode convertTimeExpression(Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeValue("model_time"));
        return result;
    }

    @Override
    public ExprCode convertAddition(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, "RealAdd(${left-value}, ${right-value})", dest, ctxt);
    }

    @Override
    public ExprCode convertSubtraction(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, "RealSubtract(${left-value}, ${right-value})", dest, ctxt);
    }

    @Override
    public ExprCode convertMultiplication(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, "RealMultiply(${left-value}, ${right-value})", dest, ctxt);
    }

    @Override
    protected ExprCode convertDivision(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern;
        if (properties.contains((Object)ExprProperties.RANGE_FAILURE) || properties.contains((Object)ExprProperties.ZERO_DIVIDE_FAILURE)) {
            pattern = "RealDivision(${left-value}, ${right-value})";
        } else {
            Assert.check((properties.size() == 1 && properties.contains((Object)ExprProperties.INT_INT_DIVIDE) ? 1 : 0) != 0);
            pattern = "(double)(${left-value}) / (${right-value})";
        }
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    public ExprCode convertAbsStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealAbs(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertMaximumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealMax(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertMinimumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealMin(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertSignStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealSign(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertPowerStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealMax(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertSqrtStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealSqrt(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertCbrtStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RealCbrt(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertScaleStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("ScaleFunction(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertTrigonometryStdLib(StdLibFunction stdLib, Expression expr, Destination dest, CodeContext ctxt) {
        String pattern = STANDARD_FUNCTIONS.get(stdLib);
        Assert.notNull((Object)pattern);
        return TypeInfoHelper.convertFunctionCallPattern(pattern, Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode convertLogarithmicStdLib(StdLibFunction stdLib, Expression expr, Destination dest, CodeContext ctxt) {
        String pattern = STANDARD_FUNCTIONS.get(stdLib);
        Assert.notNull((Object)pattern);
        return TypeInfoHelper.convertFunctionCallPattern(pattern, Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public String getTargetType() {
        return "RealType";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof C89RealTypeInfo;
    }

    @Override
    public int hashCode() {
        return C89RealTypeInfo.class.hashCode();
    }
}

