/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.events.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractSocketWrapper
extends Socket {
    private Socket socket;

    protected void checkCancel() throws IOException {
    }

    public Socket getSocket() {
        return this.socket;
    }

    public AbstractSocketWrapper(Socket socket) {
        Assert.isNotNull((Object)socket);
        this.socket = socket;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.checkCancel();
        this.socket.bind(bindpoint);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.checkCancel();
        this.socket.connect(endpoint, timeout);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.checkCancel();
        this.socket.connect(endpoint);
    }

    public boolean equals(Object obj) {
        return this.socket.equals(obj);
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        this.checkCancel();
        return this.socket.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkCancel();
        return this.socket.getOutputStream();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public int hashCode() {
        return this.socket.hashCode();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        this.checkCancel();
        this.socket.sendUrgentData(data);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return this.socket.toString();
    }
}

