/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;

class SweepCopy {
    private final LNode[][] nodeOrder;
    private final List<List<List<LPort>>> portOrders;

    SweepCopy(LNode[][] nodeOrderIn) {
        this.nodeOrder = this.deepCopy(nodeOrderIn);
        this.portOrders = new ArrayList<List<List<LPort>>>();
        LNode[][] lNodeArray = nodeOrderIn;
        int n = nodeOrderIn.length;
        int n2 = 0;
        while (n2 < n) {
            LNode[] lNodes = lNodeArray[n2];
            ArrayList<ArrayList<LPort>> layer = new ArrayList<ArrayList<LPort>>();
            this.portOrders.add(layer);
            LNode[] lNodeArray2 = lNodes;
            int n3 = lNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray2[n4];
                layer.add(new ArrayList<LPort>(node.getPorts()));
                ++n4;
            }
            ++n2;
        }
    }

    SweepCopy(SweepCopy sc) {
        this.nodeOrder = this.deepCopy(sc.nodeOrder);
        this.portOrders = new ArrayList<List<List<LPort>>>(sc.portOrders);
    }

    private LNode[][] deepCopy(LNode[][] currentlyBestNodeOrder) {
        if (currentlyBestNodeOrder == null) {
            return null;
        }
        LNode[][] result = new LNode[currentlyBestNodeOrder.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = Arrays.copyOf(currentlyBestNodeOrder[i], currentlyBestNodeOrder[i].length);
            ++i;
        }
        return result;
    }

    public LNode[][] nodes() {
        return this.nodeOrder;
    }

    public void transferNodeAndPortOrdersToGraph(LGraph lGraph) {
        List<Layer> layers = lGraph.getLayers();
        int i = 0;
        while (i < layers.size()) {
            List<LNode> nodes = layers.get(i).getNodes();
            int j = 0;
            while (j < nodes.size()) {
                LNode node = this.nodeOrder[i][j];
                lGraph.getLayers().get(i).getNodes().set(j, node);
                node.getPorts().clear();
                node.getPorts().addAll((Collection<LPort>)this.portOrders.get(i).get(j));
                ++j;
            }
            ++i;
        }
    }
}

