/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonKind;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.AutomatonBuilder;
import org.eclipse.escet.cif.eventbased.builders.State;
import org.eclipse.escet.cif.eventbased.builders.StateEdges;
import org.eclipse.escet.common.app.framework.exceptions.InvalidModelException;

public class SynchronousProduct {
    private SynchronousProduct() {
    }

    public static Automaton product(List<Automaton> automs) {
        if (automs.isEmpty()) {
            String msg = "Cannot compute the product of 0 automata.";
            throw new InvalidModelException(msg);
        }
        AutomatonKind akind = null;
        for (Automaton a : automs) {
            if (akind == null) {
                akind = a.kind;
                continue;
            }
            if (akind.equals((Object)a.kind)) continue;
            akind = AutomatonKind.UNKNOWN;
            break;
        }
        AutomatonBuilder builder = new AutomatonBuilder(automs);
        for (State srcState : builder) {
            Location srcLoc = builder.getLocation(srcState);
            builder.edgeBuilder.setupStateEdges(srcState);
            for (StateEdges stateEdges : builder.edgeBuilder.getStateEdges()) {
                for (State destState : stateEdges) {
                    Location destLoc = builder.getLocation(destState);
                    Edge.addEdge(stateEdges.event, srcLoc, destLoc);
                }
            }
        }
        builder.destAut.kind = akind;
        return builder.destAut;
    }
}

