/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompInstWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CompParamWrapExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.CompInstWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.CompParamWrapType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TypeRef;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.declwrap.AlgVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.ConstDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.ContVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.DiscVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EnumLiteralDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.EventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalAlgDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalEventDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FormalLocationDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncParamDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.FuncVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.InputVariableDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.LocationDeclWrap;
import org.eclipse.escet.cif.typechecker.declwrap.TypeDeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.AutScope;
import org.eclipse.escet.cif.typechecker.scopes.CompInstScope;
import org.eclipse.escet.cif.typechecker.scopes.CompParamScope;
import org.eclipse.escet.cif.typechecker.scopes.FunctionScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SpecScope;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public abstract class SymbolScope<T extends PositionObject>
extends SymbolTableEntry
implements Boxable {
    protected final T obj;
    protected ParentScope<?> parent;

    public SymbolScope(T obj, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(tchecker);
        this.obj = obj;
        this.parent = parent;
        Assert.ifAndOnlyIf((boolean)this.isRootScope(), (parent == null ? 1 : 0) != 0);
        if (parent != null) {
            parent.addChildScope(this);
        }
    }

    public T getObject() {
        return this.obj;
    }

    @Override
    public Position getPosition() {
        return this.obj.getPosition();
    }

    public ParentScope<?> getParent() {
        return this.parent;
    }

    @Override
    public void changeParent(ParentScope<?> parent) {
        this.parent = parent;
    }

    protected abstract boolean isSubScope();

    protected abstract boolean isRootScope();

    public abstract String getAbsText();

    public SymbolTableEntry resolve(Position position, String name, CifTypeChecker tchecker) {
        if (name.startsWith("^")) {
            if (this.isRootScope()) {
                return this.resolve(position, name.substring(1), "^", tchecker, null);
            }
            return this.parent.resolve(position, name, tchecker);
        }
        if (name.startsWith(".")) {
            if (!this.isSubScope()) {
                return this.resolve(position, name.substring(1), ".", tchecker, null);
            }
            Assert.check((boolean)this.isSubScope());
            return this.parent.resolve(position, name, tchecker);
        }
        return this.resolve(position, name, "", tchecker, this);
    }

    private SymbolTableEntry resolve(Position position, String name, String done, CifTypeChecker tchecker, SymbolScope<?> origScope) {
        boolean isViaResolve = !done.isEmpty();
        Assert.ifAndOnlyIf((origScope == null ? 1 : 0) != 0, (boolean)isViaResolve);
        int idx = name.indexOf(46);
        String id = idx == -1 ? name : name.substring(0, idx);
        SymbolTableEntry entry = this.resolve1(position, id, done, tchecker, origScope);
        if (idx != -1) {
            name = name.substring(idx + 1);
            done = String.valueOf(done) + id + ".";
            if (!(entry instanceof SymbolScope)) {
                tchecker.addProblem(ErrMsg.RESOLVE_VIA_NON_SCOPE, position, name, entry.getAbsName());
                throw new SemanticException();
            }
            if (entry instanceof AutDefScope || entry instanceof GroupDefScope) {
                tchecker.addProblem(ErrMsg.RESOLVE_VIA_COMPDEF, position, name, entry.getAbsName());
                throw new SemanticException();
            }
            if (entry instanceof FunctionScope) {
                tchecker.addProblem(ErrMsg.RESOLVE_VIA_FUNC, position, name, entry.getAbsName());
                throw new SemanticException();
            }
            SymbolScope scope = (SymbolScope)entry;
            entry = scope.resolve(position, name, done, tchecker, null);
        }
        return entry;
    }

    protected abstract SymbolTableEntry resolve1(Position var1, String var2, String var3, CifTypeChecker var4, SymbolScope<?> var5);

    public Expression resolveAsExpr(String name, Position position, String done, CifTypeChecker tchecker) {
        if (name.startsWith("^")) {
            Assert.check((boolean)done.isEmpty());
            if (this.isRootScope()) {
                return this.resolveAsExpr(name.substring(1), position, "^", tchecker);
            }
            return this.parent.resolveAsExpr(name, position, "", tchecker);
        }
        if (name.startsWith(".")) {
            Assert.check((boolean)done.isEmpty());
            if (!this.isSubScope()) {
                return this.resolveAsExpr(name.substring(1), position, ".", tchecker);
            }
            return this.parent.resolveAsExpr(name, position, "", tchecker);
        }
        int idx = name.indexOf(46);
        String id = idx == -1 ? name : name.substring(0, idx);
        SymbolTableEntry entry = ((SymbolScope)this).resolve1(null, id, done, tchecker, null);
        if (idx != -1) {
            name = name.substring(idx + 1);
            done = String.valueOf(done) + id + ".";
            SymbolScope scope = (SymbolScope)entry;
            Expression rslt = scope.resolveAsExpr(name, position, done, tchecker);
            if ((scope instanceof CompInstScope || scope instanceof CompParamScope) && CifScopeUtils.isParamRefExpr((Expression)rslt)) {
                int nextIdx = name.indexOf(46);
                String nextId = nextIdx == -1 ? name : name.substring(0, nextIdx);
                tchecker.addProblem(ErrMsg.COMP_PARAM_NOT_IN_SCOPE, position, String.valueOf(id) + '.' + nextId);
                throw new SemanticException();
            }
            if (scope instanceof CompInstScope || scope instanceof CompParamScope) {
                CompInstWrapType wrapType;
                CompInstWrapExpression wrap;
                ParentScope<?> origScope;
                CifType rsltType = rslt.getType();
                if (scope instanceof CompInstScope) {
                    CompInstScope iscope = (CompInstScope)scope;
                    origScope = iscope.getCompDefScope();
                    wrap = CifConstructors.newCompInstWrapExpression();
                    wrap.setPosition(PositionUtils.copyPosition((Position)position));
                    wrap.setInstantiation((ComponentInst)iscope.getObject());
                    wrap.setReference(rslt);
                    rslt = wrap;
                    CompInstWrapType instWrapType = CifConstructors.newCompInstWrapType();
                    instWrapType.setPosition(PositionUtils.copyPosition((Position)position));
                    instWrapType.setInstantiation((ComponentInst)iscope.getObject());
                    wrapType = instWrapType;
                } else {
                    Assert.check((boolean)(scope instanceof CompParamScope));
                    CompParamScope pscope = (CompParamScope)scope;
                    origScope = pscope.getCompDefScope();
                    wrap = CifConstructors.newCompParamWrapExpression();
                    wrap.setPosition(PositionUtils.copyPosition((Position)position));
                    wrap.setParameter((ComponentParameter)pscope.getObject());
                    wrap.setReference(rslt);
                    rslt = wrap;
                    CompParamWrapType paramWrapType = CifConstructors.newCompParamWrapType();
                    paramWrapType.setPosition(PositionUtils.copyPosition((Position)position));
                    paramWrapType.setParameter((ComponentParameter)pscope.getObject());
                    wrapType = paramWrapType;
                }
                ParentScope<?> newScope = this;
                if (newScope instanceof CompInstScope) {
                    newScope = ((CompInstScope)((Object)newScope)).getCompDefScope();
                } else if (newScope instanceof CompParamScope) {
                    newScope = ((CompParamScope)((Object)newScope)).getCompDefScope();
                }
                rslt.setType(rsltType);
                CifScopeUtils.changeTypeScope((CifType)rsltType, (CifType)wrapType, (PositionObject)origScope.obj, newScope.obj);
                rsltType = rslt.getType();
                Expression expr = rslt;
                while (expr instanceof CompParamWrapExpression || expr instanceof CompInstWrapExpression) {
                    if (expr instanceof CompParamWrapExpression) {
                        expr = ((CompParamWrapExpression)expr).getReference();
                    } else {
                        Assert.check((boolean)(expr instanceof CompInstWrapExpression));
                        expr = ((CompInstWrapExpression)expr).getReference();
                    }
                    expr.setType((CifType)EMFHelper.deepclone((EObject)rsltType));
                }
            }
            return rslt;
        }
        if (entry instanceof AlgVariableDeclWrap) {
            AlgVariable a = (AlgVariable)((AlgVariableDeclWrap)entry).getObject();
            AlgVariableExpression rslt = CifConstructors.newAlgVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(a);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)a.getType()));
            return rslt;
        }
        if (entry instanceof ConstDeclWrap) {
            Constant c = (Constant)((ConstDeclWrap)entry).getObject();
            ConstantExpression rslt = CifConstructors.newConstantExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setConstant(c);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)c.getType()));
            return rslt;
        }
        if (entry instanceof ContVariableDeclWrap) {
            ContVariable v = (ContVariable)((ContVariableDeclWrap)entry).getObject();
            RealType t = CifConstructors.newRealType();
            t.setPosition(PositionUtils.copyPosition((Position)position));
            ContVariableExpression rslt = CifConstructors.newContVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(v);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof DiscVariableDeclWrap) {
            DiscVariable v = (DiscVariable)((DiscVariableDeclWrap)entry).getObject();
            DiscVariableExpression rslt = CifConstructors.newDiscVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(v);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)v.getType()));
            return rslt;
        }
        if (entry instanceof EnumDeclWrap) {
            throw new RuntimeException("Can't ref enum decl in expr.");
        }
        if (entry instanceof EnumLiteralDeclWrap) {
            EnumLiteral l = (EnumLiteral)((EnumLiteralDeclWrap)entry).getObject();
            EnumDecl e = (EnumDecl)l.eContainer();
            EnumType t = CifConstructors.newEnumType();
            t.setEnum(e);
            t.setPosition(PositionUtils.copyPosition((Position)position));
            EnumLiteralExpression rslt = CifConstructors.newEnumLiteralExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setLiteral(l);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof EventDeclWrap) {
            Event e = (Event)((EventDeclWrap)entry).getObject();
            BoolType t = CifConstructors.newBoolType();
            t.setPosition(PositionUtils.copyPosition((Position)position));
            EventExpression rslt = CifConstructors.newEventExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setEvent(e);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof FormalAlgDeclWrap) {
            AlgVariable a = ((AlgParameter)((FormalAlgDeclWrap)entry).getObject()).getVariable();
            AlgVariableExpression rslt = CifConstructors.newAlgVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(a);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)a.getType()));
            return rslt;
        }
        if (entry instanceof FormalEventDeclWrap) {
            Event e = ((EventParameter)((FormalEventDeclWrap)entry).getObject()).getEvent();
            BoolType t = CifConstructors.newBoolType();
            t.setPosition(PositionUtils.copyPosition((Position)position));
            EventExpression rslt = CifConstructors.newEventExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setEvent(e);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof FormalLocationDeclWrap) {
            Location l = ((LocationParameter)((FormalLocationDeclWrap)entry).getObject()).getLocation();
            BoolType t = CifConstructors.newBoolType();
            t.setPosition(PositionUtils.copyPosition((Position)position));
            LocationExpression rslt = CifConstructors.newLocationExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setLocation(l);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof FuncParamDeclWrap) {
            DiscVariable v = ((FunctionParameter)((FuncParamDeclWrap)entry).getObject()).getParameter();
            DiscVariableExpression rslt = CifConstructors.newDiscVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(v);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)v.getType()));
            return rslt;
        }
        if (entry instanceof FuncVariableDeclWrap) {
            DiscVariable v = (DiscVariable)((FuncVariableDeclWrap)entry).getObject();
            DiscVariableExpression rslt = CifConstructors.newDiscVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(v);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)v.getType()));
            return rslt;
        }
        if (entry instanceof InputVariableDeclWrap) {
            InputVariable v = (InputVariable)((InputVariableDeclWrap)entry).getObject();
            InputVariableExpression rslt = CifConstructors.newInputVariableExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setVariable(v);
            rslt.setType((CifType)EMFHelper.deepclone((EObject)v.getType()));
            return rslt;
        }
        if (entry instanceof LocationDeclWrap) {
            Location l = (Location)((LocationDeclWrap)entry).getObject();
            BoolType t = CifConstructors.newBoolType();
            t.setPosition(PositionUtils.copyPosition((Position)position));
            LocationExpression rslt = CifConstructors.newLocationExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setLocation(l);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof TypeDeclWrap) {
            throw new RuntimeException("Can't ref type decl in expr.");
        }
        if (entry instanceof AutDefScope) {
            throw new RuntimeException("Can't ref aut def in expr.");
        }
        if (entry instanceof AutScope) {
            Component c = (Component)((AutScope)entry).getObject();
            ComponentType t = CifConstructors.newComponentType();
            t.setComponent(c);
            t.setPosition(PositionUtils.copyPosition((Position)position));
            ComponentExpression rslt = CifConstructors.newComponentExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setComponent(c);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof CompInstScope) {
            Component c = (Component)((CompInstScope)entry).getObject();
            ComponentType t = CifConstructors.newComponentType();
            t.setComponent(c);
            t.setPosition(PositionUtils.copyPosition((Position)position));
            ComponentExpression rslt = CifConstructors.newComponentExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setComponent(c);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof GroupDefScope) {
            throw new RuntimeException("Can't ref group def in expr.");
        }
        if (entry instanceof GroupScope) {
            Component c = (Component)((GroupScope)entry).getObject();
            ComponentType t = CifConstructors.newComponentType();
            t.setComponent(c);
            t.setPosition(PositionUtils.copyPosition((Position)position));
            ComponentExpression rslt = CifConstructors.newComponentExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setComponent(c);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof CompParamScope) {
            throw new RuntimeException("Can't ref comp param in expr.");
        }
        if (entry instanceof FunctionScope) {
            Function f = (Function)((FunctionScope)entry).getObject();
            CifType returnType = ((FunctionScope)entry).getReturnType();
            FuncType t = CifConstructors.newFuncType();
            t.setReturnType((CifType)EMFHelper.deepclone((EObject)returnType));
            t.setPosition(PositionUtils.copyPosition((Position)position));
            for (FunctionParameter param : f.getParameters()) {
                CifType paramType = param.getParameter().getType();
                t.getParamTypes().add((Object)((CifType)EMFHelper.deepclone((EObject)paramType)));
            }
            FunctionExpression rslt = CifConstructors.newFunctionExpression();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setFunction(f);
            rslt.setType((CifType)t);
            return rslt;
        }
        if (entry instanceof SpecScope) {
            throw new RuntimeException("Can't ref spec scope anywhere.");
        }
        throw new RuntimeException("Unknown symbol table entry: " + entry);
    }

    public CifType resolveAsType(String name, Position position, String done, CifTypeChecker tchecker) {
        if (name.startsWith("^")) {
            Assert.check((boolean)done.isEmpty());
            if (this.isRootScope()) {
                return this.resolveAsType(name.substring(1), position, "^", tchecker);
            }
            return this.parent.resolveAsType(name, position, "", tchecker);
        }
        if (name.startsWith(".")) {
            Assert.check((boolean)done.isEmpty());
            if (!this.isSubScope()) {
                return this.resolveAsType(name.substring(1), position, ".", tchecker);
            }
            return this.parent.resolveAsType(name, position, "", tchecker);
        }
        int idx = name.indexOf(46);
        String id = idx == -1 ? name : name.substring(0, idx);
        SymbolTableEntry entry = this.resolve1(null, id, done, tchecker, null);
        if (idx != -1) {
            CompInstWrapType wrap;
            name = name.substring(idx + 1);
            done = String.valueOf(done) + id + ".";
            SymbolScope scope = (SymbolScope)entry;
            CifType rslt = scope.resolveAsType(name, position, done, tchecker);
            if ((scope instanceof CompInstScope || scope instanceof CompParamScope) && rslt instanceof CompParamWrapType) {
                int nextIdx = name.indexOf(46);
                String nextId = nextIdx == -1 ? name : name.substring(0, nextIdx);
                tchecker.addProblem(ErrMsg.COMP_PARAM_NOT_IN_SCOPE, position, String.valueOf(id) + '.' + nextId);
                throw new SemanticException();
            }
            if (scope instanceof CompInstScope) {
                CompInstScope iscope = (CompInstScope)scope;
                wrap = CifConstructors.newCompInstWrapType();
                wrap.setPosition(PositionUtils.copyPosition((Position)position));
                wrap.setInstantiation((ComponentInst)iscope.getObject());
                wrap.setReference(rslt);
                rslt = wrap;
            }
            if (scope instanceof CompParamScope) {
                CompParamScope pscope = (CompParamScope)scope;
                wrap = CifConstructors.newCompParamWrapType();
                wrap.setPosition(PositionUtils.copyPosition((Position)position));
                wrap.setParameter((ComponentParameter)pscope.getObject());
                wrap.setReference(rslt);
                rslt = wrap;
            }
            return rslt;
        }
        if (entry instanceof AlgVariableDeclWrap) {
            throw new RuntimeException("Can't ref alg variable in type.");
        }
        if (entry instanceof ConstDeclWrap) {
            throw new RuntimeException("Can't ref constant in type.");
        }
        if (entry instanceof ContVariableDeclWrap) {
            throw new RuntimeException("Can't ref cont variable in type.");
        }
        if (entry instanceof DiscVariableDeclWrap) {
            throw new RuntimeException("Can't ref disc variable in type.");
        }
        if (entry instanceof EnumDeclWrap) {
            EnumDecl e = (EnumDecl)((EnumDeclWrap)entry).getObject();
            EnumType rslt = CifConstructors.newEnumType();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setEnum(e);
            return rslt;
        }
        if (entry instanceof EnumLiteralDeclWrap) {
            throw new RuntimeException("Can't ref enum literal in type.");
        }
        if (entry instanceof EventDeclWrap) {
            throw new RuntimeException("Can't ref event in type.");
        }
        if (entry instanceof FormalAlgDeclWrap) {
            throw new RuntimeException("Can't ref formal alg in type.");
        }
        if (entry instanceof FormalEventDeclWrap) {
            throw new RuntimeException("Can't ref formal event in type.");
        }
        if (entry instanceof FormalLocationDeclWrap) {
            throw new RuntimeException("Can't ref formal location in type.");
        }
        if (entry instanceof FuncParamDeclWrap) {
            throw new RuntimeException("Can't ref func param in type.");
        }
        if (entry instanceof FuncVariableDeclWrap) {
            throw new RuntimeException("Can't ref func local var in type.");
        }
        if (entry instanceof InputVariableDeclWrap) {
            throw new RuntimeException("Can't ref input var in type.");
        }
        if (entry instanceof LocationDeclWrap) {
            throw new RuntimeException("Can't ref location in type.");
        }
        if (entry instanceof TypeDeclWrap) {
            TypeDecl t = (TypeDecl)((TypeDeclWrap)entry).getObject();
            TypeRef rslt = CifConstructors.newTypeRef();
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            rslt.setType(t);
            return rslt;
        }
        if (entry instanceof AutDefScope) {
            ComponentDef d = (ComponentDef)((AutDefScope)entry).getObject();
            ComponentDefType rslt = CifConstructors.newComponentDefType();
            rslt.setDefinition(d);
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            return rslt;
        }
        if (entry instanceof AutScope) {
            Component c = (Component)((AutScope)entry).getObject();
            ComponentType rslt = CifConstructors.newComponentType();
            rslt.setComponent(c);
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            return rslt;
        }
        if (entry instanceof CompInstScope) {
            Component c = (Component)((CompInstScope)entry).getObject();
            ComponentType rslt = CifConstructors.newComponentType();
            rslt.setComponent(c);
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            return rslt;
        }
        if (entry instanceof GroupDefScope) {
            ComponentDef d = (ComponentDef)((GroupDefScope)entry).getObject();
            ComponentDefType rslt = CifConstructors.newComponentDefType();
            rslt.setDefinition(d);
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            return rslt;
        }
        if (entry instanceof GroupScope) {
            Component c = (Component)((GroupScope)entry).getObject();
            ComponentType rslt = CifConstructors.newComponentType();
            rslt.setComponent(c);
            rslt.setPosition(PositionUtils.copyPosition((Position)position));
            return rslt;
        }
        if (entry instanceof CompParamScope) {
            throw new RuntimeException("Can't ref comp param in type.");
        }
        if (entry instanceof FunctionScope) {
            throw new RuntimeException("Can't ref user-defined func in type.");
        }
        if (entry instanceof SpecScope) {
            throw new RuntimeException("Can't ref spec scope anywhere.");
        }
        throw new RuntimeException("Unknown symbol table entry: " + entry);
    }

    protected void checkName() {
        if (this instanceof SpecScope) {
            return;
        }
        String name = this.getName();
        if (name.startsWith("e_") || name.startsWith("c_") || name.startsWith("u_")) {
            this.tchecker.addProblem(ErrMsg.RESERVED_NAME_PREFIX, this.getPosition(), this.getAbsName());
        }
    }

    public abstract void detectCompDefInstCycles(List<ParentScope<?>> var1);
}

