/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class FormatDecoder {
    private static final String FLAGS = "-+ 0,";
    private static final String[] FLAG_CHARS = new String[]{"-", "+", " ", "0", ","};
    private static final char EOF = '\uffff';
    private String text;
    private List<FormatDescription> result;
    private String parsed = "";
    private String index;
    private String flags = "";
    private String width = "";
    private String precision = "";
    private String conversion;
    private int idx = 0;
    private int offset = -1;
    private int length = 0;

    public List<FormatDescription> decode(String text) {
        char c;
        this.text = text;
        this.result = Lists.list();
        this.parsed = "";
        this.idx = 0;
        this.offset = 0;
        this.length = 0;
        block10: while ((c = this.readChar()) != '\uffff') {
            if (c != '%') {
                if (c == '\\' || c == '\"' || c == '\n' || c == '\t') {
                    ++this.length;
                }
                this.parsed = String.valueOf(this.parsed) + String.valueOf(c);
                continue;
            }
            --this.length;
            if (this.length > 0) {
                this.addLiteral();
            }
            this.length = 1;
            c = this.readChar();
            this.index = "";
            this.width = "";
            boolean indexMissing = false;
            while (c >= '1' && c <= '9' || !this.index.isEmpty() && c == '0') {
                this.index = String.valueOf(this.index) + String.valueOf(c);
                c = this.readChar();
            }
            if (c == '$') {
                c = this.readChar();
                if (this.index.isEmpty()) {
                    indexMissing = true;
                }
            } else if (!this.index.isEmpty()) {
                this.width = this.index;
                this.index = "";
            }
            this.flags = "";
            if (this.width.isEmpty()) {
                while (StringUtils.contains((String)FLAGS, (char)c)) {
                    this.flags = String.valueOf(this.flags) + String.valueOf(c);
                    c = this.readChar();
                }
            }
            if (this.width.isEmpty()) {
                while (c >= '1' && c <= '9' || !this.width.isEmpty() && c == '0') {
                    this.width = String.valueOf(this.width) + String.valueOf(c);
                    c = this.readChar();
                }
            }
            this.precision = "";
            boolean precisionMissing = false;
            if (c == '.') {
                c = this.readChar();
                while (c >= '0' && c <= '9') {
                    this.precision = String.valueOf(this.precision) + String.valueOf(c);
                    c = this.readChar();
                }
                if (this.precision.isEmpty()) {
                    precisionMissing = true;
                }
            }
            if (indexMissing) {
                this.addError("Invalid format specifier: missing explicit index before \"$\".");
                continue;
            }
            if (precisionMissing) {
                this.addError("Invalid format specifier: missing format precision after \".\".");
                continue;
            }
            String scanFlags = this.flags;
            this.flags = "";
            int i = 0;
            while (i < FLAG_CHARS.length) {
                int cnt = StringUtils.countMatches((String)scanFlags, (String)FLAG_CHARS[i]);
                if (cnt > 1) {
                    this.addError(Strings.fmt("Invalid format specifier: duplicate \"%s\" flag.", FLAG_CHARS[i]));
                    continue block10;
                }
                if (cnt == 1) {
                    this.flags = String.valueOf(this.flags) + FLAG_CHARS[i];
                }
                ++i;
            }
            if (this.flags.contains("-") && this.flags.contains("0")) {
                this.addError("Invalid format specifier: flags \"-\" and \"0\" cannot be combined.");
                continue;
            }
            if (this.flags.contains("+") && this.flags.contains(" ")) {
                this.addError("Invalid format specifier: flags \"+\" and \" \" (space) cannot be combined.");
                continue;
            }
            if (this.flags.contains("-") && this.width.isEmpty()) {
                this.addError("Invalid format specifier: flag \"-\" requires a width.");
                continue;
            }
            if (this.flags.contains("0") && this.width.isEmpty()) {
                this.addError("Invalid format specifier: flag \"0\" requires a width.");
                continue;
            }
            this.conversion = String.valueOf(c);
            switch (c) {
                case '\uffff': {
                    this.addError("Invalid format specifier: the specifier is incomplete.");
                    continue block10;
                }
                case 'B': 
                case 'b': {
                    char ch;
                    char[] cArray = this.flags.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ch = cArray[n2];
                        if (ch != '-') {
                            this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a \"%c\" flag.", Character.valueOf(c), Character.valueOf(ch)));
                            continue block10;
                        }
                        ++n2;
                    }
                    if (!this.precision.isEmpty()) {
                        this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a formatting precision.", Character.valueOf(c)));
                        continue block10;
                    }
                    this.addBoolean();
                    continue block10;
                }
                case 'S': 
                case 's': {
                    char ch;
                    char[] cArray = this.flags.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ch = cArray[n2];
                        if (ch != '-') {
                            this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a \"%c\" flag.", Character.valueOf(c), Character.valueOf(ch)));
                            continue block10;
                        }
                        ++n2;
                    }
                    if (!this.precision.isEmpty()) {
                        this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a formatting precision.", Character.valueOf(c)));
                        continue block10;
                    }
                    this.addString();
                    continue block10;
                }
                case 'X': 
                case 'x': {
                    char ch;
                    char[] cArray = this.flags.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ch = cArray[n2];
                        if (ch != '-' && ch != '0') {
                            this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a \"%c\" flag.", Character.valueOf(c), Character.valueOf(ch)));
                            continue block10;
                        }
                        ++n2;
                    }
                    if (!this.precision.isEmpty()) {
                        this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a formatting precision.", Character.valueOf(c)));
                        continue block10;
                    }
                    this.addInteger();
                    continue block10;
                }
                case 'd': {
                    if (!this.precision.isEmpty()) {
                        this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a formatting precision.", Character.valueOf(c)));
                        continue block10;
                    }
                    this.addInteger();
                    continue block10;
                }
                case 'E': 
                case 'e': {
                    char ch;
                    char[] cArray = this.flags.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ch = cArray[n2];
                        if (ch == ',') {
                            this.addError(Strings.fmt("Invalid format specifier: a \"%%%c\" specifier can not have a \"%c\" flag.", Character.valueOf(c), Character.valueOf(ch)));
                            continue block10;
                        }
                        ++n2;
                    }
                    this.addReal();
                    continue block10;
                }
                case 'G': 
                case 'f': 
                case 'g': {
                    this.addReal();
                    continue block10;
                }
                case '%': {
                    if (!this.index.isEmpty()) {
                        this.addError("Invalid format specifier: a \"%%\" specifier can not have an index.");
                        continue block10;
                    }
                    if (!this.flags.isEmpty()) {
                        this.addError("Invalid format specifier: a \"%%\" specifier can not have a formatting flag.");
                        continue block10;
                    }
                    if (!this.width.isEmpty()) {
                        this.addError("Invalid format specifier: a \"%%\" specifier can not have a formatting width.");
                        continue block10;
                    }
                    if (!this.precision.isEmpty()) {
                        this.addError("Invalid format specifier: a \"%%\" specifier can not have a formatting precision.");
                        continue block10;
                    }
                    this.parsed = "%";
                    this.addLiteral();
                    continue block10;
                }
            }
            this.addError(Strings.fmt("Invalid format specifier: unknown \"%%%c\" formatting conversion.", Character.valueOf(c)));
        }
        if (this.length > 0) {
            this.addLiteral();
        }
        return this.result;
    }

    private char readChar() {
        if (this.idx >= this.text.length()) {
            return '\uffff';
        }
        char c = this.text.charAt(this.idx);
        ++this.idx;
        ++this.length;
        return c;
    }

    private void add(FormatDescription description) {
        this.result.add(description);
        this.parsed = "";
        this.offset += this.length;
        this.length = 0;
    }

    private void addLiteral() {
        FormatDescription rslt = new FormatDescription(FormatDescription.Conversion.LITERAL, null, null, this.parsed, null, null, this.offset, this.length);
        this.add(rslt);
    }

    private void addBoolean() {
        FormatDescription rslt = new FormatDescription(FormatDescription.Conversion.BOOLEAN, this.index, this.flags, this.conversion, this.width, null, this.offset, this.length);
        this.add(rslt);
    }

    private void addString() {
        FormatDescription rslt = new FormatDescription(FormatDescription.Conversion.STRING, this.index, this.flags, this.conversion, this.width, null, this.offset, this.length);
        this.add(rslt);
    }

    private void addInteger() {
        FormatDescription rslt = new FormatDescription(FormatDescription.Conversion.INTEGER, this.index, this.flags, this.conversion, this.width, null, this.offset, this.length);
        this.add(rslt);
    }

    private void addReal() {
        FormatDescription rslt = new FormatDescription(FormatDescription.Conversion.REAL, this.index, this.flags, this.conversion, this.width, this.precision, this.offset, this.length);
        this.add(rslt);
    }

    private void addError(String text) {
        FormatDescription rslt = new FormatDescription(FormatDescription.Conversion.ERROR, null, null, text, null, null, this.offset, this.length);
        this.add(rslt);
    }
}

