/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.spec;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class SynthesisTypedVariable
extends SynthesisVariable {
    public final PositionObject obj;
    public final CifType type;

    public SynthesisTypedVariable(PositionObject obj, CifType type, int count, int lower, int upper) {
        super(obj, count, lower, upper);
        this.obj = obj;
        this.type = type;
    }

    @Override
    public int getDomainSize() {
        if (this.type instanceof BoolType) {
            Assert.check((this.count == 2 ? 1 : 0) != 0);
            return this.count;
        }
        if (this.type instanceof IntType) {
            Assert.check((this.lower >= 0 ? 1 : 0) != 0);
            Assert.check((this.lower <= this.upper ? 1 : 0) != 0);
            return this.upper + 1;
        }
        if (this.type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)this.type).getEnum();
            Assert.check((this.count > 0 ? 1 : 0) != 0);
            Assert.check((this.count == enumDecl.getLiterals().size() ? 1 : 0) != 0);
            return this.count;
        }
        throw new RuntimeException("Unexpected type: " + this.type);
    }

    @Override
    protected String toStringInternal() {
        return Strings.fmt((String)"%s \"%s\" of type \"%s\"", (Object[])new Object[]{this.getKindText(), this.name, this.getTypeText()});
    }

    @Override
    public String getTypeText() {
        return CifTextUtils.typeToStr((CifType)this.type);
    }
}

