/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.bdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.datasynth.spec.SynthesisAutomaton;
import org.eclipse.escet.cif.datasynth.spec.SynthesisDiscVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisInputVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisLocPtrVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisTypedVariable;
import org.eclipse.escet.cif.datasynth.spec.SynthesisVariable;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class BddToCif {
    private BddToCif() {
    }

    public static Expression bddToCifPred(BDD bdd, SynthesisAutomaton aut) {
        Expression predDnf = BddToCif.bddToCifPred(bdd, aut, true);
        Expression predCnf = BddToCif.bddToCifPred(bdd, aut, false);
        int sizeDnf = BddToCif.exprNodeSize(predDnf);
        int sizeCnf = BddToCif.exprNodeSize(predCnf);
        return sizeCnf <= sizeDnf ? predCnf : predDnf;
    }

    private static Expression bddToCifPred(BDD bdd, SynthesisAutomaton aut, boolean dnf) {
        if (bdd.isZero()) {
            return CifValueUtils.makeFalse();
        }
        if (bdd.isOne()) {
            return CifValueUtils.makeTrue();
        }
        byte[] valuation = new byte[aut.factory.varNum()];
        Arrays.fill(valuation, (byte)-1);
        List paths = Lists.list();
        BddToCif.bddToCifPred(bdd, aut, valuation, paths, dnf);
        Expression rslt = dnf ? CifValueUtils.createDisjunction((List)paths, (boolean)true) : CifValueUtils.createConjunction((List)paths, (boolean)true);
        return rslt;
    }

    private static void bddToCifPred(BDD bdd, SynthesisAutomaton aut, byte[] valuation, List<Expression> paths, boolean dnf) {
        if (bdd.isZero() && dnf) {
            return;
        }
        if (bdd.isOne() && !dnf) {
            return;
        }
        if (bdd.isZero() || bdd.isOne()) {
            List parts = Lists.list();
            SynthesisVariable[] synthesisVariableArray = aut.variables;
            int n = aut.variables.length;
            int n2 = 0;
            while (n2 < n) {
                SynthesisVariable var = synthesisVariableArray[n2];
                BDDDomain domain = var.domain;
                byte[] domainValuation = new byte[domain.varNum()];
                int[] varIdxs = domain.vars();
                int i = 0;
                while (i < varIdxs.length) {
                    int varIdx = varIdxs[i];
                    domainValuation[i] = valuation[varIdx];
                    ++i;
                }
                Expression pred = BddToCif.valuationToCif(var, domainValuation, dnf);
                parts.add(pred);
                ++n2;
            }
            Expression path = dnf ? CifValueUtils.createConjunction((List)parts, (boolean)true) : CifValueUtils.createDisjunction((List)parts, (boolean)true);
            paths.add(path);
        } else {
            int varIdx = bdd.var();
            valuation[varIdx] = 0;
            BDD lowBdd = bdd.low();
            BddToCif.bddToCifPred(lowBdd, aut, valuation, paths, dnf);
            lowBdd.free();
            valuation[varIdx] = 1;
            BDD highBdd = bdd.high();
            BddToCif.bddToCifPred(highBdd, aut, valuation, paths, dnf);
            highBdd.free();
            valuation[varIdx] = -1;
        }
    }

    private static Expression valuationToCif(SynthesisVariable var, byte[] valuation, boolean dnf) {
        boolean[] values = new boolean[var.count];
        if (!dnf) {
            Arrays.fill(values, true);
        }
        BddToCif.valuationToValues(valuation, 0, 0, values, var.lower, var.upper, dnf);
        return BddToCif.valuesToCif(var, values);
    }

    private static void valuationToValues(byte[] valuation, int offset, int value, boolean[] values, int min, int max, boolean dnf) {
        if (offset == valuation.length) {
            if (value >= min && value <= max) {
                values[value - min] = dnf;
            }
            return;
        }
        if (valuation[offset] == 0 || valuation[offset] == -1) {
            BddToCif.valuationToValues(valuation, offset + 1, value, values, min, max, dnf);
        }
        if (valuation[offset] == 1 || valuation[offset] == -1) {
            BddToCif.valuationToValues(valuation, offset + 1, value += 1 << offset, values, min, max, dnf);
        }
    }

    private static Expression valuesToCif(SynthesisVariable var, boolean[] possibles) {
        CifType type;
        int possibleCnt = 0;
        int impossibleCnt = 0;
        boolean[] blArray = possibles;
        int n = possibles.length;
        int n2 = 0;
        while (n2 < n) {
            boolean possible = blArray[n2];
            if (possible) {
                ++possibleCnt;
            }
            if (!possible) {
                ++impossibleCnt;
            }
            ++n2;
        }
        if (possibleCnt == possibles.length) {
            return CifValueUtils.makeTrue();
        }
        if (impossibleCnt == possibles.length) {
            return CifValueUtils.makeFalse();
        }
        if (possibleCnt == 1) {
            int trueIdx = ArrayUtils.indexOf((boolean[])possibles, (boolean)true);
            return BddToCif.createVarPred(var, trueIdx, BinaryOperator.EQUAL, true);
        }
        if (impossibleCnt == 1) {
            int falseIdx = ArrayUtils.indexOf((boolean[])possibles, (boolean)false);
            return BddToCif.createVarPred(var, falseIdx, BinaryOperator.UNEQUAL, true);
        }
        CifType cifType = type = var instanceof SynthesisTypedVariable ? ((SynthesisTypedVariable)var).type : null;
        if (type instanceof IntType) {
            boolean[] bits = possibles;
            List values = Lists.list();
            List indices = Lists.list();
            List counts = Lists.list();
            int i = 0;
            while (i < bits.length) {
                if (!values.isEmpty() && ((Boolean)Lists.last((List)values)).equals(bits[i])) {
                    counts.set(counts.size() - 1, (Integer)Lists.last((List)counts) + 1);
                } else {
                    values.add(bits[i]);
                    indices.add(i);
                    counts.add(1);
                }
                ++i;
            }
            int score0 = 1;
            int score1 = 0;
            int i2 = 0;
            while (i2 < values.size()) {
                int count = (Integer)counts.get(i2);
                if (((Boolean)values.get(i2)).booleanValue()) {
                    score1 += count == 1 ? 1 : 2;
                } else {
                    score0 += count == 1 ? 1 : 2;
                }
                ++i2;
            }
            boolean chosenValue = score1 <= score0;
            List rslts = Lists.list();
            int i3 = 0;
            while (i3 < values.size()) {
                if (((Boolean)values.get(i3)).equals(chosenValue)) {
                    if ((Integer)counts.get(i3) == 1) {
                        rslts.add(BddToCif.createVarPred(var, (Integer)indices.get(i3), BinaryOperator.EQUAL, true));
                    } else if ((Integer)counts.get(i3) == 2) {
                        rslts.add(BddToCif.createVarPred(var, (Integer)indices.get(i3), BinaryOperator.EQUAL, true));
                        rslts.add(BddToCif.createVarPred(var, (Integer)indices.get(i3) + 1, BinaryOperator.EQUAL, true));
                    } else {
                        Expression p1 = BddToCif.createVarPred(var, (Integer)indices.get(i3), BinaryOperator.LESS_EQUAL, false);
                        Expression p2 = BddToCif.createVarPred(var, (Integer)indices.get(i3) + (Integer)counts.get(i3) - 1, BinaryOperator.LESS_EQUAL, true);
                        rslts.add(CifValueUtils.createConjunction((List)Lists.list((Object[])new Expression[]{p1, p2})));
                    }
                }
                ++i3;
            }
            Expression rslt = CifValueUtils.createDisjunction((List)rslts);
            if (!chosenValue) {
                rslt = CifValueUtils.makeInverse((Expression)rslt);
            }
            return rslt;
        }
        if (type == null || type instanceof EnumType) {
            boolean[] bits = possibles;
            int count0 = 0;
            int count1 = 0;
            int i = 0;
            while (i < bits.length) {
                if (bits[i]) {
                    ++count1;
                } else {
                    ++count0;
                }
                ++i;
            }
            boolean chosenValue = count1 <= count0;
            BinaryOperator op = chosenValue ? BinaryOperator.EQUAL : BinaryOperator.UNEQUAL;
            List rslts = Lists.list();
            int i4 = 0;
            while (i4 < bits.length) {
                if (!bits[i4] != chosenValue) {
                    rslts.add(BddToCif.createVarPred(var, i4, op, true));
                }
                ++i4;
            }
            return chosenValue ? CifValueUtils.createDisjunction((List)rslts) : CifValueUtils.createConjunction((List)rslts);
        }
        throw new RuntimeException("Unexpected var type: " + type);
    }

    private static Expression createVarPred(SynthesisVariable var, int bitIdx, BinaryOperator op, boolean varLeft) {
        Expression valueExpr;
        if (var instanceof SynthesisLocPtrVariable) {
            Assert.check((op == BinaryOperator.EQUAL || op == BinaryOperator.UNEQUAL ? 1 : 0) != 0);
            SynthesisLocPtrVariable lpVar = (SynthesisLocPtrVariable)var;
            Location loc = (Location)lpVar.aut.getLocations().get(bitIdx);
            LocationExpression locRef = CifConstructors.newLocationExpression();
            locRef.setLocation(loc);
            locRef.setType((CifType)CifConstructors.newBoolType());
            LocationExpression rslt = locRef;
            if (op == BinaryOperator.UNEQUAL) {
                rslt = CifValueUtils.makeInverse((Expression)rslt);
            }
            return rslt;
        }
        SynthesisTypedVariable typedVar = (SynthesisTypedVariable)var;
        Expression varRef = BddToCif.createVarRef(typedVar);
        if (typedVar.type instanceof BoolType) {
            Assert.check((op == BinaryOperator.EQUAL || op == BinaryOperator.UNEQUAL ? 1 : 0) != 0);
            if (op == BinaryOperator.UNEQUAL) {
                bitIdx = 1 - bitIdx;
            }
            if (bitIdx == 1) {
                return varRef;
            }
            return CifValueUtils.makeInverse((Expression)varRef);
        }
        if (typedVar.type instanceof IntType) {
            int value = var.lower + bitIdx;
            valueExpr = CifValueUtils.makeInt((int)value);
        } else if (typedVar.type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)typedVar.type).getEnum();
            EnumLiteral lit = (EnumLiteral)enumDecl.getLiterals().get(bitIdx);
            EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
            litRef.setLiteral(lit);
            litRef.setType((CifType)EMFHelper.deepclone((EObject)typedVar.type));
            valueExpr = litRef;
        } else {
            throw new RuntimeException("Unexpected var type: " + typedVar.type);
        }
        BinaryExpression bin = CifConstructors.newBinaryExpression();
        bin.setOperator(op);
        bin.setLeft(varLeft ? varRef : valueExpr);
        bin.setRight(varLeft ? valueExpr : varRef);
        bin.setType((CifType)CifConstructors.newBoolType());
        return bin;
    }

    private static Expression createVarRef(SynthesisVariable var) {
        Assert.check((boolean)(var instanceof SynthesisTypedVariable));
        if (var instanceof SynthesisDiscVariable) {
            SynthesisDiscVariable discVar = (SynthesisDiscVariable)var;
            DiscVariableExpression discVarRef = CifConstructors.newDiscVariableExpression();
            discVarRef.setVariable(discVar.var);
            discVarRef.setType((CifType)EMFHelper.deepclone((EObject)discVar.type));
            return discVarRef;
        }
        if (var instanceof SynthesisInputVariable) {
            SynthesisInputVariable inputVar = (SynthesisInputVariable)var;
            InputVariableExpression inputVarRef = CifConstructors.newInputVariableExpression();
            inputVarRef.setVariable(inputVar.var);
            inputVarRef.setType((CifType)EMFHelper.deepclone((EObject)inputVar.type));
            return inputVarRef;
        }
        throw new RuntimeException("Unknown typed var: " + var);
    }

    private static int exprNodeSize(Expression expr) {
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            Expression left = bexpr.getLeft();
            Expression right = bexpr.getRight();
            return 1 + BddToCif.exprNodeSize(left) + BddToCif.exprNodeSize(right);
        }
        if (expr instanceof UnaryExpression) {
            return 1 + BddToCif.exprNodeSize(((UnaryExpression)expr).getChild());
        }
        if (expr instanceof BoolExpression) {
            return 1;
        }
        if (expr instanceof IntExpression) {
            return 1;
        }
        if (expr instanceof DiscVariableExpression) {
            return 1;
        }
        if (expr instanceof InputVariableExpression) {
            return 1;
        }
        if (expr instanceof EnumLiteralExpression) {
            return 1;
        }
        if (expr instanceof LocationExpression) {
            return 1;
        }
        throw new RuntimeException("Unexpected expr: " + expr);
    }

    public static Expression getBddVarPred(SynthesisVariable var, int idx) {
        CifType type;
        CifType cifType = type = var instanceof SynthesisTypedVariable ? ((SynthesisTypedVariable)var).type : null;
        if (type == null) {
            SynthesisLocPtrVariable synthLpVar = (SynthesisLocPtrVariable)var;
            EList locs = synthLpVar.aut.getLocations();
            List locRefs = Lists.list();
            int mask = 1 << idx;
            int i = 0;
            while (i < locs.size()) {
                if ((i & mask) != 0) {
                    LocationExpression locRef = CifConstructors.newLocationExpression();
                    locRef.setLocation((Location)locs.get(i));
                    locRef.setType((CifType)CifConstructors.newBoolType());
                    locRefs.add(locRef);
                }
                ++i;
            }
            return CifValueUtils.createDisjunction((List)locRefs);
        }
        if (type instanceof BoolType) {
            Assert.check((idx == 0 ? 1 : 0) != 0);
            return BddToCif.createVarRef(var);
        }
        if (type instanceof IntType) {
            Expression varRef = BddToCif.createVarRef(var);
            BinaryExpression divExpr = CifConstructors.newBinaryExpression();
            divExpr.setOperator(BinaryOperator.INTEGER_DIVISION);
            divExpr.setLeft(varRef);
            divExpr.setRight(CifValueUtils.makeInt((int)(1 << idx)));
            BinaryExpression modExpr = CifConstructors.newBinaryExpression();
            modExpr.setOperator(BinaryOperator.MODULUS);
            modExpr.setLeft((Expression)divExpr);
            modExpr.setRight(CifValueUtils.makeInt((int)2));
            BinaryExpression gtExpr = CifConstructors.newBinaryExpression();
            gtExpr.setOperator(BinaryOperator.GREATER_THAN);
            gtExpr.setLeft((Expression)modExpr);
            gtExpr.setRight(CifValueUtils.makeInt((int)0));
            return gtExpr;
        }
        if (type instanceof EnumType) {
            EnumDecl enumDecl = ((EnumType)type).getEnum();
            EList literals = enumDecl.getLiterals();
            List valuePreds = Lists.list();
            int mask = 1 << idx;
            int i = 0;
            while (i < literals.size()) {
                if ((i & mask) != 0) {
                    Expression varRef = BddToCif.createVarRef(var);
                    EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
                    litRef.setLiteral((EnumLiteral)literals.get(i));
                    litRef.setType((CifType)CifConstructors.newEnumType((EnumDecl)enumDecl, null));
                    BinaryExpression bexpr = CifConstructors.newBinaryExpression();
                    bexpr.setLeft(varRef);
                    bexpr.setRight((Expression)litRef);
                    bexpr.setOperator(BinaryOperator.EQUAL);
                    bexpr.setType((CifType)CifConstructors.newBoolType());
                    valuePreds.add(bexpr);
                }
                ++i;
            }
            return CifValueUtils.createDisjunction((List)valuePreds);
        }
        throw new RuntimeException("Unexpected type: " + type);
    }
}

