/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.escet.common.app.framework.exceptions.DependencyException;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.javacompiler.JavaClassFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.JavaInputFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeClassLoader;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompilerException;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaFileManager;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;

public class RuntimeJavaCompiler {
    public static final boolean DEBUG = false;
    private final JavaCompiler compiler;
    private final Iterable<String> options;
    private final DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector();
    private final RuntimeJavaFileManager fileManager;
    private final CharArrayWriter output = new CharArrayWriter();

    public RuntimeJavaCompiler() {
        this(RuntimeJavaCompiler.getJavaCompiler(null), RuntimeJavaCompiler.getDefaultCompilerOptions(), null);
    }

    public RuntimeJavaCompiler(JavaCompiler compiler) {
        this(compiler, RuntimeJavaCompiler.getDefaultCompilerOptions(), null);
    }

    public RuntimeJavaCompiler(ClassLoader classLoader) {
        this(RuntimeJavaCompiler.getJavaCompiler(null), RuntimeJavaCompiler.getDefaultCompilerOptions(), classLoader);
    }

    public RuntimeJavaCompiler(JavaCompiler compiler, ClassLoader classLoader) {
        this(compiler, RuntimeJavaCompiler.getDefaultCompilerOptions(), classLoader);
    }

    public RuntimeJavaCompiler(JavaCompiler compiler, Iterable<String> options, ClassLoader classLoader) {
        this.compiler = compiler;
        this.options = options;
        StandardJavaFileManager manager = compiler.getStandardFileManager(this.diagnostics, null, null);
        this.fileManager = new RuntimeJavaFileManager(manager, classLoader);
    }

    public static List<String> getDefaultCompilerOptions() {
        return Lists.list((Object[])new String[]{"-nowarn", "-source", "1.8", "-target", "1.8"});
    }

    public static JavaCompiler getJavaCompiler(String name) {
        if (name == null || name.equals("eclipse")) {
            return new EclipseCompiler();
        }
        if (name.equals("jdk")) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                String msg = Strings.fmt((String)"Failed to locate Java compiler. The current Java runtime appears to be a JRE (Java Runtime Environment), while a JDK (Java Development Kit) is required: \"%s\".", (Object[])new Object[]{System.getProperty("java.home")});
                throw new DependencyException(msg);
            }
            return compiler;
        }
        throw new RuntimeException("Unknown Java compiler name: " + name);
    }

    public void compile(Map<String, JavaInputFileObject> sources) throws RuntimeJavaCompilerException {
        for (Map.Entry<String, JavaInputFileObject> source : sources.entrySet()) {
            this.fileManager.addSourceFile(source.getKey(), source.getValue());
        }
        JavaCompiler.CompilationTask task = this.compiler.getTask(this.output, this.fileManager, this.diagnostics, this.options, null, sources.values());
        Boolean result = task.call();
        if (result == null || !result.booleanValue()) {
            throw new RuntimeJavaCompilerException(this, sources);
        }
    }

    public RuntimeClassLoader getClassLoader() {
        return this.fileManager.getClassLoader();
    }

    public DiagnosticCollector<JavaFileObject> getDiagnostics() {
        return this.diagnostics;
    }

    public CharArrayWriter getOutput() {
        return this.output;
    }

    public <T> Class<T> loadClass(String absClassName) {
        try {
            Class<?> rslt = this.getClassLoader().loadClass(absClassName);
            return rslt;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + absClassName, e);
        }
    }

    public static URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URI creation failed: " + uri, e);
        }
    }

    public static URI createMemoryURI(String absClassName, JavaFileObject.Kind kind) {
        String extension = kind.extension;
        Assert.check((extension != null && extension.length() > 0 ? 1 : 0) != 0);
        String uriName = "memory:///" + absClassName.replace('.', '/') + extension;
        return RuntimeJavaCompiler.createURI(uriName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeJarFile(String jarPath, String mainClass, Map<String, ByteArrayOutputStream> resources) {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (mainClass != null) {
            attrs.put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try {
                FileOutputStream stream = new FileOutputStream(jarPath);
                try {
                    try (JarOutputStream jarStream = new JarOutputStream((OutputStream)stream, manifest);){
                        for (Map.Entry<String, JavaClassFileObject> entry : this.getClassLoader().generatedClasses.entrySet()) {
                            String absClassName = entry.getKey();
                            byte[] byteCode = entry.getValue().getByteCodeArray();
                            String entryName = String.valueOf(absClassName.replace('.', '/')) + ".class";
                            Assert.check((boolean)entryName.equals(entry.getValue().getName()));
                            JarEntry jarEntry = new JarEntry(entryName);
                            try {
                                jarStream.putNextEntry(jarEntry);
                                jarStream.write(byteCode, 0, byteCode.length);
                                jarStream.closeEntry();
                            }
                            catch (IOException e) {
                                String msg = Strings.fmt((String)"Failed to write class file for class \"%s\".", (Object[])new Object[]{absClassName});
                                throw new IOException(msg, e);
                            }
                        }
                        if (resources != null) {
                            for (Map.Entry<String, Object> entry : resources.entrySet()) {
                                String resPath = entry.getKey();
                                byte[] resBytes = ((ByteArrayOutputStream)entry.getValue()).toByteArray();
                                JarEntry jarEntry = new JarEntry(resPath);
                                try {
                                    jarStream.putNextEntry(jarEntry);
                                    jarStream.write(resBytes, 0, resBytes.length);
                                    jarStream.closeEntry();
                                }
                                catch (IOException e) {
                                    String msg = Strings.fmt((String)"Failed to write resource data for resource \"%s\".", (Object[])new Object[]{resPath});
                                    throw new IOException(msg, e);
                                }
                            }
                        }
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            String msg = Strings.fmt((String)"Could not create JAR file \"%s\".", (Object[])new Object[]{jarPath});
            throw new InputOutputException(msg, e);
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Could not write JAR file \"%s\".", (Object[])new Object[]{jarPath});
            throw new InputOutputException(msg, e);
        }
    }
}

