/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser.ast.regex;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.setext.parser.ast.regex.RegEx;
import org.eclipse.escet.setext.parser.ast.regex.RegExChar;
import org.eclipse.escet.setext.parser.ast.regex.RegExChars;

public class RegExCharClass
extends RegEx {
    public final boolean negated;
    public final List<RegExChars> chars;

    public RegExCharClass(boolean negated, List<RegExChars> chars, Position position) {
        super(position);
        this.negated = negated;
        this.chars = chars;
        Assert.check((!chars.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    public boolean acceptsEmptyString() {
        return false;
    }

    @Override
    public Set<Integer> getCodePoints() {
        Set rslt = Sets.set();
        if (this.negated) {
            int i = 0;
            while (i <= 127) {
                rslt.add(i);
                ++i;
            }
            for (RegExChars part : this.chars) {
                rslt.removeAll(part.getCodePoints());
            }
        } else {
            for (RegExChars part : this.chars) {
                rslt.addAll(part.getCodePoints());
            }
        }
        return rslt;
    }

    @Override
    public Set<RegExChar> getChars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDescriptionText() {
        return false;
    }

    @Override
    public String getDescriptionText() {
        return null;
    }

    @Override
    public int getBindingStrength() {
        return 3;
    }

    @Override
    public String toString() {
        List txts = Lists.list();
        for (RegExChars cs : this.chars) {
            txts.add(cs.toString());
        }
        return Strings.fmt((String)"[%s%s]", (Object[])new Object[]{this.negated ? "^" : "", StringUtils.join((Collection)txts, (String)"")});
    }
}

