/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class JUnitWizard
extends Wizard
implements INewWizard {
    private IWorkbench fWorkbench;
    protected static final String DIALOG_SETTINGS_KEY = "JUnitWizards";
    private IStructuredSelection fSelection;

    public JUnitWizard() {
        this.setNeedsProgressMonitor(true);
        this.initializeDefaultPageImageDescriptor();
    }

    public abstract boolean performFinish();

    protected boolean finishPage(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            Shell shell = this.getShell();
            String title = WizardMessages.NewJUnitWizard_op_error_title;
            String message = WizardMessages.NewJUnitWizard_op_error_message;
            ExceptionHandler.handle(e, shell, title, message);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = JUnitPlugin.getActivePage()) != null && (display = Display.getDefault()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        JUnitPlugin.log(e);
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.fWorkbench = workbench;
        this.fSelection = currentSelection;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }

    protected void initDialogSettings() {
        IDialogSettings pluginSettings = JUnitPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = pluginSettings.getSection(DIALOG_SETTINGS_KEY);
        if (wizardSettings == null) {
            wizardSettings = new DialogSettings(DIALOG_SETTINGS_KEY);
            pluginSettings.addSection(wizardSettings);
        }
        this.setDialogSettings(wizardSettings);
    }

    protected abstract void initializeDefaultPageImageDescriptor();
}

