/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.show;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public class ShowKeysUI
implements IDisposable {
    private IPreferenceStore preferenceStore;
    private IServiceLocator serviceLocator;
    private ShowKeysPopup shortcutPopup;

    public ShowKeysUI(IServiceLocator serviceLocator, IPreferenceStore preferenceStore) {
        this.serviceLocator = serviceLocator;
        this.preferenceStore = preferenceStore;
    }

    public void open(String commandId, Event trigger) {
        this.open(commandId, null, trigger, false);
    }

    public void openForPreview(String commandId, String description) {
        this.open(commandId, description, null, true);
    }

    @Override
    public void dispose() {
        this.closePopup();
    }

    private void open(String commandId, String description, Event trigger, boolean force) {
        String formattedShortcut = this.getFormattedShortcut(trigger, commandId);
        if (formattedShortcut == null && !force) {
            return;
        }
        try {
            ICommandService cmdService = this.serviceLocator.getService(ICommandService.class);
            Command command = cmdService.getCommand(commandId);
            String name = command.getName();
            if (description == null) {
                description = command.getDescription();
            }
            this.openPopup(formattedShortcut, name, description);
        }
        catch (NotDefinedException notDefinedException) {}
    }

    private String getFormattedShortcut(Event trigger, String commandId) {
        if (trigger != null) {
            int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)trigger);
            KeyStroke keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
            if (this.preferenceStore.getBoolean("showCommandKeysForKeyboard") && keyStroke.getNaturalKey() != 0) {
                return SWTKeySupport.getKeyFormatterForPlatform().format(keyStroke);
            }
            if (this.preferenceStore.getBoolean("showCommandKeysForMouseEvents") && keyStroke.getNaturalKey() == 0) {
                return this.serviceLocator.getService(IBindingService.class).getBestActiveBindingFormattedFor(commandId);
            }
        }
        return null;
    }

    private void openPopup(String shortcut, String shortcutText, String shortcutDescription) {
        Display.getDefault().asyncExec(() -> {
            this.closePopup();
            int timeToClose = this.preferenceStore.getInt("showCommandKeys_timeToClose");
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            this.shortcutPopup = new ShowKeysPopup(shell, timeToClose);
            this.shortcutPopup.setShortcut(shortcut, shortcutText, shortcutDescription);
            this.shortcutPopup.open();
        });
    }

    private void closePopup() {
        if (this.shortcutPopup != null) {
            this.shortcutPopup.close();
            this.shortcutPopup = null;
        }
    }

    private static class ShowKeysPopup
    extends Window {
        private static final String POPUP_COLOR_BG = "org.eclipse.ui.showkeys.backgroundColor";
        private static final String POPUP_COLOR_FG = "org.eclipse.ui.showkeys.foregroundColor";
        private static final int POPUP_FONT_SIZEFACTOR_KEY_LABEL = 2;
        private static final int POPUP_FONT_SIZEFACTOR_KEY = 3;
        private static final int MARGIN_BOTTOM = 25;
        private final String keysPageId = "org.eclipse.ui.preferencePages.Keys";
        private final List<Resource> resources = new ArrayList<Resource>(3);
        private final int timeToClose;
        private String shortcut;
        private String shortcutText;
        private String shortcutDescription;
        private boolean readyToClose = true;

        public ShowKeysPopup(Shell parentShell, int timeToClose) {
            super(parentShell);
            this.timeToClose = timeToClose;
            this.setShellStyle(16396);
        }

        public void setShortcut(String shortcut, String shortcutText, String shortcutDescription) {
            this.shortcut = shortcut;
            this.shortcutText = shortcutText;
            this.shortcutDescription = shortcutDescription;
        }

        public int open() {
            this.scheduleClose();
            Shell shell = this.getShell();
            if (shell == null || shell.isDisposed()) {
                shell = null;
                this.create();
                shell = this.getShell();
            }
            this.constrainShellSize();
            shell.setVisible(true);
            return 0;
        }

        private void scheduleClose() {
            this.readyToClose = true;
            Display.getDefault().timerExec(this.timeToClose, () -> {
                if (this.readyToClose && this.getShell() != null && !this.getShell().isDisposed()) {
                    this.close();
                }
            });
        }

        public boolean close() {
            boolean closed = super.close();
            for (Resource resource : this.resources) {
                resource.dispose();
            }
            this.resources.clear();
            return closed;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            Color color = JFaceResources.getColorRegistry().get(POPUP_COLOR_BG);
            newShell.setBackground(color);
            newShell.setAlpha(170);
        }

        protected Control createContents(Composite parent) {
            Font shortcutFont;
            FontData fontData;
            Font font = JFaceResources.getDialogFont();
            FontData[] defaultFontData = font.getFontData();
            Color foregroundColor = JFaceResources.getColorRegistry().get(POPUP_COLOR_FG);
            Composite contents = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().applyTo(contents);
            contents.setBackground(parent.getBackground());
            this.hookDoubleClickListener((Control)contents);
            String primaryText = null;
            if (this.shortcut != null && this.shortcutText != null) {
                primaryText = String.valueOf(this.shortcut) + " \u2013 " + this.shortcutText;
            } else if (this.shortcut != null) {
                primaryText = this.shortcut;
            } else if (this.shortcutText != null) {
                primaryText = this.shortcutText;
            }
            if (primaryText != null) {
                Label shortcutLabel = new Label(contents, 0x1000000);
                GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)shortcutLabel);
                fontData = new FontData(defaultFontData[0].getName(), defaultFontData[0].getHeight() * 3, 1);
                shortcutFont = new Font((Device)this.getShell().getDisplay(), fontData);
                this.resources.add((Resource)shortcutFont);
                shortcutLabel.setBackground(parent.getBackground());
                shortcutLabel.setForeground(foregroundColor);
                shortcutLabel.setFont(shortcutFont);
                shortcutLabel.setText(primaryText);
                this.hookDoubleClickListener((Control)shortcutLabel);
            }
            if (this.shortcutDescription != null) {
                Label shortcutDescriptionLabel = new Label(contents, 0x1000000);
                GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)shortcutDescriptionLabel);
                fontData = new FontData(defaultFontData[0].getName(), (int)((double)defaultFontData[0].getHeight() * 1.3), 0);
                shortcutFont = new Font((Device)this.getShell().getDisplay(), fontData);
                this.resources.add((Resource)shortcutFont);
                shortcutDescriptionLabel.setFont(shortcutFont);
                shortcutDescriptionLabel.setBackground(parent.getBackground());
                shortcutDescriptionLabel.setForeground(foregroundColor);
                shortcutDescriptionLabel.setText(this.shortcutDescription);
                this.hookDoubleClickListener((Control)shortcutDescriptionLabel);
            }
            return contents;
        }

        private void hookDoubleClickListener(Control control) {
            control.addListener(8, e -> PreferencesUtil.createPreferenceDialogOn(this.getParentShell(), "org.eclipse.ui.preferencePages.Keys", null, null).open());
        }

        protected Point getInitialLocation(Point initialSize) {
            Composite parent = this.getShell().getParent();
            Rectangle parentBounds = parent.getBounds();
            Monitor monitor = parent.getMonitor();
            Rectangle monitorBounds = monitor.getClientArea();
            Point centerPoint = Geometry.centerPoint((Rectangle)parent.getBounds());
            return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, parentBounds.y + parentBounds.height - initialSize.y - 25));
        }
    }
}

