/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class NameMaps {
    private Set<String> names;
    private static final String[] RESERVED = new String[]{"act", "allow", "block", "comm", "cons", "delay", "div", "end", "eqn", "exists", "forall", "glob", "hide", "if", "in", "init", "lambda", "map", "mod", "mu", "nu", "pbes", "proc", "rename", "sort", "struct", "sum", "val", "var", "whr", "yaled", "Bag", "Bool", "Int", "List", "Nat", "Pos", "Real", "Set", "delta", "false", "nil", "tau", "true"};
    private static final String AUT_EFSM = "BehProc_";
    private static final String AUT_LOCSORT = "LocSort_";
    private static final String AUT_LOCVAR = "Locvar_";
    private static final String AUT_LOCATION = "loc_";
    private static final String[] AUT_PREFIXES = new String[]{"BehProc_", "LocSort_", "Locvar_", "loc_"};
    private Map<Automaton, String> automatonMap = Maps.map();
    private static final String VAR_EFSM = "VarProc_";
    private static final String VAR_AREAD = "aread_";
    private static final String VAR_AWRITE = "awrite_";
    private static final String VAR_VREAD = "vread_";
    private static final String VAR_VWRITE = "vwrite_";
    private static final String VAR_SYNC = "sync_";
    private static final String VAR_VALUE = "value_";
    private static final String VAR_NAME = "";
    private static final String[] VAR_PREFIXES = new String[]{"VarProc_", "", "sync_", "value_", "aread_", "awrite_", "vread_", "vwrite_"};
    private Map<DiscVariable, String> variableMap = Maps.map();
    private static final String EVT_NAME = "";
    private static final String EVT_RENAMED = "renamed_";
    private static final String[] EVT_PREFIXES = new String[]{"", "renamed_"};
    private Map<Event, String> eventMap = Maps.map();

    public NameMaps() {
        this.names = Sets.set();
        String[] stringArray = RESERVED;
        int n = RESERVED.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            this.names.add(r);
            ++n2;
        }
    }

    private boolean testNames(String name, String[] prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (this.names.contains(String.valueOf(prefix) + name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void addNames(String name, String[] prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            this.names.add(String.valueOf(prefix) + name);
            ++n2;
        }
    }

    private String makeName(String baseName, String[] prefixes) {
        if (this.testNames(baseName, prefixes)) {
            this.addNames(baseName, prefixes);
            return baseName;
        }
        int i = 2;
        while (true) {
            String name;
            if (this.testNames(name = String.valueOf(baseName) + String.valueOf(i), prefixes)) {
                this.addNames(name, prefixes);
                return name;
            }
            ++i;
        }
    }

    private String getAutomaton(Automaton aut) {
        String name = this.automatonMap.get(aut);
        if (name != null) {
            return name;
        }
        name = this.makeName(aut.getName(), AUT_PREFIXES);
        this.automatonMap.put(aut, name);
        return name;
    }

    public String getBehaviorProcess(Automaton behavior) {
        return AUT_EFSM + this.getAutomaton(behavior);
    }

    public String getLocationSortName(Automaton behavior) {
        return AUT_LOCSORT + this.getAutomaton(behavior);
    }

    public String getLocationVariableName(Automaton behavior) {
        return AUT_LOCVAR + this.getAutomaton(behavior);
    }

    public String getLocationName(Location loc, Automaton aut) {
        String prefix = AUT_LOCATION + this.getAutomaton(aut);
        if (loc.getName() == null) {
            return prefix;
        }
        return String.valueOf(prefix) + "_" + loc.getName();
    }

    private String getVariable(DiscVariable var) {
        String name = this.variableMap.get(var);
        if (name != null) {
            return name;
        }
        name = this.makeName(var.getName(), VAR_PREFIXES);
        this.variableMap.put(var, name);
        return name;
    }

    public String getVariableName(DiscVariable var) {
        return this.getVariable(var);
    }

    public String getBehRead(DiscVariable var) {
        return VAR_AREAD + this.getVariable(var);
    }

    public String getBehWrite(DiscVariable var) {
        return VAR_AWRITE + this.getVariable(var);
    }

    public String getVarRead(DiscVariable var) {
        return VAR_VREAD + this.getVariable(var);
    }

    public String getVarWrite(DiscVariable var) {
        return VAR_VWRITE + this.getVariable(var);
    }

    public String getVarSync(DiscVariable var) {
        return VAR_SYNC + this.getVariable(var);
    }

    public String getVariableProcess(DiscVariable var) {
        return VAR_EFSM + this.getVariable(var);
    }

    public String getVariableValue(DiscVariable var) {
        return VAR_VALUE + this.getVariable(var);
    }

    private String getEvent(Event evt) {
        String name = this.eventMap.get(evt);
        if (name != null) {
            return name;
        }
        name = this.makeName(evt.getName(), EVT_PREFIXES);
        this.eventMap.put(evt, name);
        return name;
    }

    public String getEventName(Event evt) {
        return this.getEvent(evt);
    }

    public String getRenamedEventName(Event evt) {
        return EVT_RENAMED + this.getEvent(evt);
    }

    public String getTypeName(CifType tp) {
        return (tp = CifTypeUtils.normalizeType((CifType)tp)) instanceof BoolType ? "Bool" : "Int";
    }
}

