/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.box;

import java.util.List;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class HBox
extends Box {
    private final List<Box> subBoxes = Lists.list();
    private final String separator;

    public HBox() {
        this("");
    }

    public HBox(String separator) {
        this.separator = separator;
    }

    public HBox(Object ... items) {
        Assert.check((items.length > 0 ? 1 : 0) != 0);
        this.separator = "";
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Assert.notNull((Object)item);
            if (item instanceof Box) {
                this.add((Box)item);
            } else {
                this.add(new TextBox(item.toString()));
            }
            ++n2;
        }
    }

    public void add(Box box) {
        Assert.notNull((Object)box);
        this.subBoxes.add(box);
    }

    public void add(String line) {
        Assert.notNull((Object)line);
        this.add(new TextBox(line));
    }

    public void add(Object ... items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Assert.notNull((Object)item);
            if (item instanceof Box) {
                this.add((Box)item);
            } else {
                this.add(new TextBox(item.toString()));
            }
            ++n2;
        }
    }

    @Override
    public List<String> getLines() {
        List<String> rslt = null;
        for (Box b : this.subBoxes) {
            List<String> bLines = b.getLines();
            List<String> list = rslt = rslt == null ? bLines : this.concatLines(rslt, bLines);
        }
        if (rslt == null) {
            rslt = Lists.list();
        }
        return rslt;
    }

    private List<String> concatLines(List<String> lines1, List<String> lines2) {
        if (lines1.isEmpty()) {
            return lines2;
        }
        if (lines2.isEmpty()) {
            return lines1;
        }
        int indent = ((String)Lists.last(lines1)).length() + this.separator.length();
        String indentTxt = null;
        List rslt = Lists.list();
        int i = 0;
        while (i < lines1.size() - 1) {
            rslt.add(lines1.get(i));
            ++i;
        }
        rslt.add(String.valueOf((String)Lists.last(lines1)) + this.separator + (String)Lists.first(lines2));
        i = 1;
        while (i < lines2.size()) {
            String line = lines2.get(i);
            if (indentTxt == null) {
                indentTxt = Strings.spaces((int)indent);
            }
            rslt.add(String.valueOf(indentTxt) + line);
            ++i;
        }
        return rslt;
    }
}

