/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IWriteAccess;

public interface IXtextDocument
extends IDocument,
IDocumentExtension3,
IReadAccess<XtextResource>,
IReadAccess.Priority<XtextResource>,
IWriteAccess<XtextResource> {
    default public <T> T getAdapter(Class<T> adapterType) {
        URI resourceURI;
        if (adapterType.isInstance(this)) {
            return adapterType.cast(this);
        }
        if (URI.class.equals(adapterType)) {
            return adapterType.cast(this.getResourceURI());
        }
        if ((IFile.class.equals(adapterType) || IResource.class.equals(adapterType)) && (resourceURI = this.getResourceURI()).isPlatformResource()) {
            return adapterType.cast(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceURI.toPlatformString(true))));
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    default public URI getResourceURI() {
        return (URI)this.tryReadOnly(r -> r.getURI());
    }

    public void addModelListener(IXtextModelListener var1);

    public void removeModelListener(IXtextModelListener var1);

    public void addXtextDocumentContentObserver(IXtextDocumentContentObserver var1);

    public void removeXtextDocumentContentObserver(IXtextDocumentContentObserver var1);
}

