/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.rpm.core.RPMProjectLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class NewProjectCreationPage
extends WizardNewProjectCreationPage {
    private ComboViewer typeCombo;
    private final WorkingSetGroup wsGroup = new WorkingSetGroup();
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];

    public NewProjectCreationPage(String pageName) {
        super(pageName);
        this.setWorkingSets(EMPTY_WORKING_SET_ARRAY);
    }

    public void init(IStructuredSelection selection) {
        this.setWorkingSets(this.getSelectedWorkingSet(selection));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        Composite projectTypeGroup = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectTypeGroup.setLayout((Layout)layout);
        projectTypeGroup.setLayoutData((Object)new GridData(768));
        Label typeLabel = new Label(projectTypeGroup, 0);
        typeLabel.setText(Messages.getString("SRPMImportPage.4"));
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.typeCombo = new ComboViewer(projectTypeGroup, 8);
        this.typeCombo.getControl().setLayoutData((Object)data);
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setInput((Object)RPMProjectLayout.values());
        this.typeCombo.getCombo().select(0);
        Control workingSetControl = this.wsGroup.createControl(control);
        workingSetControl.setLayoutData((Object)new GridData(768));
    }

    public RPMProjectLayout getSelectedLayout() {
        return RPMProjectLayout.valueOf((String)this.typeCombo.getCombo().getItem(this.typeCombo.getCombo().getSelectionIndex()));
    }

    public IWorkingSet[] getWorkingSets() {
        return this.wsGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null) {
            this.wsGroup.setWorkingSets(EMPTY_WORKING_SET_ARRAY);
        }
        this.wsGroup.setWorkingSets(workingSets);
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1 || paths[0].getSegmentCount() == 0) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            Object candidate = paths[0].getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            IWorkingSet workingSetCandidate = (IWorkingSet)candidate;
            if (!workingSetCandidate.isAggregateWorkingSet()) {
                return new IWorkingSet[]{workingSetCandidate};
            }
            return EMPTY_WORKING_SET_ARRAY;
        }
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        for (Object element : elements) {
            IWorkingSet ws;
            if (!(element instanceof IWorkingSet) || (ws = (IWorkingSet)element).isAggregateWorkingSet()) continue;
            result.add((IWorkingSet)element);
        }
        if (!result.isEmpty()) {
            return result.toArray(new IWorkingSet[result.size()]);
        }
        return EMPTY_WORKING_SET_ARRAY;
    }

    private static final class WorkingSetGroup {
        private WorkingSetConfigurationBlock workingSetBlock;

        public WorkingSetGroup() {
            String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage"};
            this.workingSetBlock = new WorkingSetConfigurationBlock(workingSetIds, PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(NewProjectCreationPage.class)).getDialogSettings());
        }

        public Control createControl(Composite composite) {
            Group workingSetGroup = new Group(composite, 0);
            workingSetGroup.setFont(composite.getFont());
            workingSetGroup.setText(Messages.getString("NewProjectCreationPage.0"));
            workingSetGroup.setLayout((Layout)new GridLayout(1, false));
            this.workingSetBlock.createContent((Composite)workingSetGroup);
            return workingSetGroup;
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.workingSetBlock.setWorkingSets(workingSets);
        }

        public IWorkingSet[] getSelectedWorkingSets() {
            return this.workingSetBlock.getSelectedWorkingSets();
        }
    }
}

