/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.widgets;

import org.eclipse.linuxtools.systemtap.graphing.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;

public class GraphContinuousXControl
extends Composite {
    private static final int CLICK_INCREMENT = 10;
    private static final double TOLERANCE = 0.01;
    private AbstractChartBuilder builder;
    private Scale zoomScale;
    private Slider scrollBar;

    public GraphContinuousXControl(GraphComposite comp, int style) {
        super((Composite)comp, style);
        this.builder = comp.getCanvas();
        this.setLayout((Layout)new FormLayout());
        Font font = new Font((Device)comp.getDisplay(), "Arial", 10, 1);
        FormData thisData = new FormData();
        thisData.bottom = new FormAttachment(100, 0);
        thisData.left = new FormAttachment((Control)this.builder, 0, 16384);
        thisData.right = new FormAttachment((Control)this.builder, 0, 131072);
        this.setLayoutData(thisData);
        Button zoomOutButton = new Button((Composite)this, 0x1000000);
        zoomOutButton.setText(Messages.GraphContinuousControl_ZoomOutLabel);
        zoomOutButton.setToolTipText(Messages.GraphContinuousXControl_ZoomOutTooltip);
        zoomOutButton.setFont(font);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        zoomOutButton.setLayoutData((Object)data);
        zoomOutButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.zoomScale.setSelection(this.zoomScale.getSelection() - 10);
            this.updateScale();
        }));
        Button zoomInButton = new Button((Composite)this, 0x1000000);
        zoomInButton.setText(Messages.GraphContinuousControl_ZoomInLabel);
        zoomInButton.setToolTipText(Messages.GraphContinuousXControl_ZoomInTooltip);
        zoomInButton.setFont(font);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.bottom = ((FormData)zoomOutButton.getLayoutData()).bottom;
        zoomInButton.setLayoutData((Object)data);
        zoomInButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.zoomScale.setSelection(this.zoomScale.getSelection() + 10);
            this.updateScale();
        }));
        this.zoomScale = new Scale((Composite)this, 256);
        this.zoomScale.setMinimum(0);
        this.zoomScale.setMaximum(99);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(10);
        this.zoomScale.setSelection(0);
        this.zoomScale.setToolTipText(Messages.GraphContinuousXControl_ScaleMessage);
        data = new FormData();
        data.left = new FormAttachment((Control)zoomOutButton, 2);
        data.bottom = ((FormData)zoomInButton.getLayoutData()).bottom;
        data.right = new FormAttachment((Control)zoomInButton, -2);
        this.zoomScale.setLayoutData((Object)data);
        this.scrollBar = new Slider((Composite)this, 256);
        this.scrollBar.setMinimum(0);
        this.scrollBar.setMaximum(101);
        this.scrollBar.setThumb(100);
        this.scrollBar.setIncrement(1);
        this.scrollBar.setPageIncrement(1);
        this.scrollBar.setSelection(100);
        this.scrollBar.setToolTipText(Messages.GraphContinuousXControl_ScrollMessage);
        data = new FormData();
        data.left = new FormAttachment((Control)zoomOutButton, 0);
        data.bottom = new FormAttachment((Control)this.zoomScale, 0);
        data.right = new FormAttachment((Control)zoomInButton, 0);
        this.scrollBar.setLayoutData((Object)data);
        this.zoomScale.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateScale()));
        this.scrollBar.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateScroll()));
        this.updateScale();
        this.updateScroll();
    }

    private void updateScale() {
        double newscale = 1.0 - (double)this.zoomScale.getSelection() / 100.0;
        if (Math.abs(this.builder.getScale() - newscale) >= 0.01) {
            this.builder.setScale(newscale);
            this.scrollBar.setThumb((int)(newscale * 100.0));
            this.scrollBar.setSelection((int)(this.builder.getScroll() * (double)(101 - this.scrollBar.getThumb())));
        }
    }

    private void updateScroll() {
        double newscroll = (double)this.scrollBar.getSelection() / (101.0 - (double)this.scrollBar.getThumb());
        if (Math.abs(this.builder.getScroll() - newscroll) >= 0.01) {
            this.builder.setScroll(newscroll);
        }
    }
}

