/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.format.DOMAttributeFormatter;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.TextEdit;

public class DOMElementFormatter {
    private final XMLFormatterDocument formatterDocument;
    private final DOMAttributeFormatter attributeFormatter;

    public DOMElementFormatter(XMLFormatterDocument formatterDocument, DOMAttributeFormatter attributeFormatter) {
        this.formatterDocument = formatterDocument;
        this.attributeFormatter = attributeFormatter;
    }

    public void formatElement(DOMElement element, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        FormatElementCategory formatElementCategory = this.getFormatElementCategory(element, parentConstraints);
        XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements(element, formatElementCategory);
        int indentLevel = parentConstraints.getIndentLevel();
        int width = this.formatStartTagElement(element, parentConstraints, emptyElements, start, end, edits);
        parentConstraints.setAvailableLineWidth(parentConstraints.getAvailableLineWidth() - width);
        int mixedIndentLevel = parentConstraints.getMixedContentIndentLevel();
        if (mixedIndentLevel == 0 && parentConstraints.getFormatElementCategory() == FormatElementCategory.MixedContent) {
            parentConstraints.setMixedContentIndentLevel(indentLevel);
        }
        if (emptyElements == XMLFormattingOptions.EmptyElements.ignore) {
            XMLFormattingConstraints constraints = new XMLFormattingConstraints();
            constraints.copyConstraints(parentConstraints);
            if (element.isClosed()) {
                constraints.setIndentLevel(indentLevel + 1);
            }
            constraints.setFormatElementCategory(formatElementCategory);
            this.formatChildren(element, constraints, start, end, edits);
            if (element.hasEndTag()) {
                width = this.formatEndTagElement(element, parentConstraints, constraints, edits);
                parentConstraints.setAvailableLineWidth(constraints.getAvailableLineWidth() - width);
            }
        }
    }

    private int formatStartTagElement(DOMElement element, XMLFormattingConstraints parentConstraints, XMLFormattingOptions.EmptyElements emptyElements, int start, int end, List<TextEdit> edits) {
        if (!element.hasStartTag()) {
            return element.getEnd() - element.getStart();
        }
        int indentLevel = parentConstraints.getIndentLevel();
        int width = element.getTagName() != null ? element.getTagName().length() + 1 : 0;
        FormatElementCategory formatElementCategory = parentConstraints.getFormatElementCategory();
        int startTagOpenOffset = element.getStartTagOpenOffset();
        int startTagCloseOffset = element.getStartTagCloseOffset();
        if (end != -1 && startTagOpenOffset > end || start != -1 && startTagCloseOffset != -1 && startTagCloseOffset < start) {
            return 0;
        }
        switch (formatElementCategory) {
            case PreserveSpace: {
                break;
            }
            case MixedContent: {
                int parentStartCloseOffset;
                int n = parentStartCloseOffset = element.getParentElement() != null ? element.getParentElement().getStartTagCloseOffset() + 1 : 0;
                if (parentStartCloseOffset == startTagOpenOffset || !StringUtils.isWhitespace(this.formatterDocument.getText(), parentStartCloseOffset, startTagOpenOffset)) break;
                this.replaceLeftSpacesWithIndentationPreservedNewLines(parentStartCloseOffset, startTagOpenOffset, indentLevel, edits);
                parentConstraints.setAvailableLineWidth(this.getMaxLineWidth());
                width += indentLevel * this.getTabSize();
                break;
            }
            case IgnoreSpace: {
                if (element.getParentNode().isOwnerDocument() && element.getParentNode().getFirstChild() == element) {
                    this.replaceLeftSpacesWithIndentation(indentLevel, 0, startTagOpenOffset, false, edits);
                    break;
                }
                this.replaceLeftSpacesWithIndentationPreservedNewLines(0, startTagOpenOffset, indentLevel, edits);
                width += indentLevel * this.getTabSize();
                parentConstraints.setAvailableLineWidth(this.getMaxLineWidth());
                break;
            }
        }
        parentConstraints.setAvailableLineWidth(parentConstraints.getAvailableLineWidth() - width);
        if (formatElementCategory != FormatElementCategory.PreserveSpace) {
            this.formatAttributes(element, parentConstraints, edits);
            boolean formatted = false;
            width = 0;
            switch (emptyElements) {
                case expand: {
                    if (!element.isSelfClosed()) break;
                    StringBuilder tag = new StringBuilder();
                    tag.append(">");
                    tag.append("</");
                    tag.append(element.getTagName());
                    tag.append('>');
                    int from = DOMElementFormatter.getOffsetAfterStartTagOrLastAttribute(element);
                    int to = element.getEnd();
                    this.createTextEditIfNeeded(from, to, tag.toString(), edits);
                    formatted = true;
                    width += element.getTagName() != null ? element.getTagName().length() + 4 : 0;
                    break;
                }
                case collapse: {
                    if (element.isSelfClosed() || end != -1 && element.getEndTagOpenOffset() + 1 >= end || !this.shouldCollapseEmptyElement(element, this.formatterDocument.getSharedSettings())) break;
                    StringBuilder tag = new StringBuilder();
                    if (this.isSpaceBeforeEmptyCloseTag()) {
                        tag.append(" ");
                    }
                    tag.append("/>");
                    int from = DOMElementFormatter.getOffsetAfterStartTagOrLastAttribute(element);
                    int to = element.getEnd();
                    this.createTextEditIfNeeded(from, to, tag.toString(), edits);
                    formatted = true;
                    ++width;
                    break;
                }
                default: {
                    ++width;
                }
            }
            if (!formatted && (element.isStartTagClosed() || element.isSelfClosed())) {
                width = this.formatElementStartTagOrSelfClosed(element, parentConstraints, edits);
            }
        }
        return width;
    }

    private static int getOffsetAfterStartTagOrLastAttribute(DOMElement element) {
        DOMAttr attr = DOMElementFormatter.getLastAttribute(element);
        if (attr != null) {
            return attr.getEnd();
        }
        return element.getOffsetAfterStartTag();
    }

    private int formatAttributes(DOMElement element, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        if (element.hasAttributes()) {
            List<DOMAttr> attributes = element.getAttributeNodes();
            int prevOffset = element.getOffsetAfterStartTag();
            boolean singleAttribute = attributes.size() == 1;
            for (DOMAttr attr : attributes) {
                this.attributeFormatter.formatAttribute(attr, prevOffset, singleAttribute, true, parentConstraints, edits);
                prevOffset = attr.getEnd();
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int formatElementStartTagOrSelfClosed(DOMElement element, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        int startTagClose = element.getOffsetBeforeCloseOfStartTag();
        int startTagOpen = element.getOffsetAfterStartTag();
        String replace = "";
        boolean spaceBeforeEmptyCloseTag = this.isSpaceBeforeEmptyCloseTag();
        int width = 0;
        if (this.isPreserveAttributeLineBreaks() && element.hasAttributes() && this.hasLineBreak(DOMElementFormatter.getLastAttribute(element).getEnd(), startTagClose)) {
            spaceBeforeEmptyCloseTag = false;
            int indentLevel = parentConstraints.getIndentLevel();
            if (indentLevel != 0) {
                this.replaceLeftSpacesWithIndentation(indentLevel, startTagOpen, startTagClose, true, edits);
                return width;
            }
            replace = this.formatterDocument.getLineDelimiter();
        } else if (this.shouldFormatClosingBracketNewLine(element)) {
            int indentLevel = parentConstraints.getIndentLevel();
            this.replaceLeftSpacesWithIndentation(indentLevel + this.getSplitAttributesIndentSize(), startTagOpen, startTagClose, true, edits);
            return (indentLevel + this.getSplitAttributesIndentSize()) * this.getTabSize();
        }
        if (element.isSelfClosed()) {
            if (spaceBeforeEmptyCloseTag) {
                replace = replace + " ";
                ++width;
            }
            ++width;
        }
        this.replaceLeftSpacesWith(startTagOpen, startTagClose, replace, edits);
        return ++width;
    }

    private int formatEndTagElement(DOMElement element, XMLFormattingConstraints parentConstraints, XMLFormattingConstraints constraints, List<TextEdit> edits) {
        int indentLevel = parentConstraints.getIndentLevel();
        FormatElementCategory formatElementCategory = constraints.getFormatElementCategory();
        int endTagOpenOffset = element.getEndTagOpenOffset();
        int startTagCloseOffset = element.getStartTagCloseOffset();
        int width = element.getTagName() != null ? element.getTagName().length() + 2 : 0;
        switch (formatElementCategory) {
            case PreserveSpace: {
                break;
            }
            case MixedContent: {
                DOMNode lastChild = element.getLastChild();
                if (lastChild == null || !lastChild.isElement() && !lastChild.isComment() || !Character.isWhitespace(this.formatterDocument.getText().charAt(endTagOpenOffset - 1))) break;
                this.replaceLeftSpacesWithIndentationPreservedNewLines(startTagCloseOffset, endTagOpenOffset, indentLevel, edits);
                width += indentLevel * this.getTabSize();
                break;
            }
            case IgnoreSpace: {
                this.replaceLeftSpacesWithIndentationPreservedNewLines(startTagCloseOffset, endTagOpenOffset, indentLevel, edits);
                width += indentLevel * this.getTabSize();
                break;
            }
        }
        if (element.isEndTagClosed()) {
            int endTagCloseOffset = element.getEndTagCloseOffset();
            this.removeLeftSpaces(element.getEndTagOpenOffset(), endTagCloseOffset, edits);
            ++width;
        }
        return width;
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements(DOMElement element, FormatElementCategory formatElementCategory) {
        XMLFormattingOptions.EmptyElements emptyElements = this.getEmptyElements();
        if (emptyElements != XMLFormattingOptions.EmptyElements.ignore && element.isClosed() && element.isEmpty()) {
            switch (emptyElements) {
                case expand: 
                case collapse: {
                    if (formatElementCategory == FormatElementCategory.PreserveSpace && element.hasChildNodes()) {
                        return XMLFormattingOptions.EmptyElements.ignore;
                    }
                    return emptyElements;
                }
            }
            return emptyElements;
        }
        return XMLFormattingOptions.EmptyElements.ignore;
    }

    private boolean shouldFormatClosingBracketNewLine(DOMElement element) {
        boolean isSingleAttribute = element.getAttributeNodes() != null ? element.getAttributeNodes().size() == 1 : true;
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getClosingBracketNewLine() && this.isSplitAttributes() && !isSingleAttribute;
    }

    private void replaceLeftSpacesWith(int from, int to, String replace, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(from, to, replace, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private void replaceLeftSpacesWithIndentationPreservedNewLines(int spaceStart, int spaceEnd, int indentLevel, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithIndentationPreservedNewLines(spaceStart, spaceEnd, indentLevel, edits);
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private void createTextEditIfNeeded(int from, int to, String expectedContent, List<TextEdit> edits) {
        this.formatterDocument.createTextEditIfNeeded(from, to, expectedContent, edits);
    }

    private boolean hasLineBreak(int from, int to) {
        return this.formatterDocument.hasLineBreak(from, to);
    }

    private static DOMAttr getLastAttribute(DOMElement element) {
        if (!element.hasAttributes()) {
            return null;
        }
        List<DOMAttr> attributes = element.getAttributeNodes();
        return attributes.get(attributes.size() - 1);
    }

    private boolean isPreserveAttributeLineBreaks() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveAttributeLineBreaks();
    }

    private boolean isSplitAttributes() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSplitAttributes();
    }

    private int getSplitAttributesIndentSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getSplitAttributesIndentSize();
    }

    private boolean isSpaceBeforeEmptyCloseTag() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSpaceBeforeEmptyCloseTag();
    }

    private XMLFormattingOptions.EmptyElements getEmptyElements() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getEmptyElements();
    }

    private void formatChildren(DOMElement element, XMLFormattingConstraints constraints, int start, int end, List<TextEdit> edits) {
        this.formatterDocument.formatChildren(element, constraints, start, end, edits);
    }

    private FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints) {
        return this.formatterDocument.getFormatElementCategory(element, parentConstraints);
    }

    private boolean shouldCollapseEmptyElement(DOMElement element, SharedSettings settings) {
        return this.formatterDocument.shouldCollapseEmptyElement(element, settings);
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }
}

