/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.PrepareRenameRequest;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XMLPrepareRename {
    private static final Logger LOGGER = Logger.getLogger(XMLPrepareRename.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLPrepareRename(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public Either<Range, PrepareRenameResult> prepareRename(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        PrepareRenameRequest request = null;
        try {
            request = new PrepareRenameRequest(xmlDocument, position, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating prperare rename request", e);
            return null;
        }
        for (IRenameParticipant participant : this.extensionsRegistry.getRenameParticipants()) {
            try {
                Either<Range, PrepareRenameResult> result = participant.prepareRename(request, cancelChecker);
                if (result == null) continue;
                return result;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing prepare rename for the participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        DOMNode node = request.getNode();
        if (node == null) {
            return null;
        }
        int offset = request.getOffset();
        if (node.isElement()) {
            DOMElement element = (DOMElement)node;
            if (element.isInStartTag(offset)) {
                return Either.forLeft((Object)XMLPositionUtility.selectStartTagName(element));
            }
            if (element.isInEndTag(offset)) {
                return Either.forLeft((Object)XMLPositionUtility.selectEndTagName(element));
            }
        }
        return null;
    }
}

