/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.services.format.DOMAttributeFormatter;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMProcessingInstructionFormatter {
    private final XMLFormatterDocument formatterDocument;
    private final DOMAttributeFormatter attributeFormatter;

    public DOMProcessingInstructionFormatter(XMLFormatterDocument formatterDocument, DOMAttributeFormatter attributeFormatter) {
        this.formatterDocument = formatterDocument;
        this.attributeFormatter = attributeFormatter;
    }

    public void formatProcessingInstruction(DOMProcessingInstruction processingInstruction, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        int endPIOffset;
        int prevOffset = processingInstruction.getStartContent();
        DOMElement parentElement = processingInstruction.getParentElement();
        if (parentElement != null) {
            int indentLevel = parentConstraints.getIndentLevel();
            int parentStartCloseOffset = parentElement.getStartTagCloseOffset() + 1;
            this.replaceLeftSpacesWithIndentation(indentLevel, parentStartCloseOffset, processingInstruction.getStart(), true, edits);
        }
        if (processingInstruction.hasAttributes()) {
            List<DOMAttr> attributes = processingInstruction.getAttributeNodes();
            boolean singleAttribute = attributes.size() == 1;
            for (DOMAttr attr : attributes) {
                this.attributeFormatter.formatAttribute(attr, prevOffset, singleAttribute, false, parentConstraints, edits);
                prevOffset = attr.getEnd();
            }
        }
        if (processingInstruction.isClosed() && prevOffset != (endPIOffset = processingInstruction.getEnd() - 2)) {
            this.replaceLeftSpacesWith(prevOffset, endPIOffset, "", edits);
        }
    }

    private void replaceLeftSpacesWith(int leftLimit, int to, String replacement, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(leftLimit, to, replacement, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }
}

