/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.validator;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLModelUtils;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public enum RelaxNGErrorCode implements IXMLErrorCode
{
    unknown_element,
    unexpected_element_required_element_missing,
    unexpected_element_required_elements_missing,
    element_not_allowed_yet,
    out_of_context_element,
    no_attributes_allowed,
    invalid_attribute_name,
    invalid_attribute_value,
    required_attributes_missing_expected,
    required_attribute_missing,
    required_attributes_missing,
    incomplete_element_required_elements_missing_expected,
    incomplete_element_required_element_missing,
    incomplete_element_required_elements_missing,
    text_not_allowed,
    document_incomplete,
    invalid_element_value,
    blank_not_allowed,
    schema_allows_nothing,
    RelaxNGNotFound,
    to_implement;

    private final String code;
    private static final Map<String, RelaxNGErrorCode> codes;

    private RelaxNGErrorCode() {
        this(null);
    }

    private RelaxNGErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static RelaxNGErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, RelaxNGErrorCode rngCode, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (rngCode) {
            case unknown_element: 
            case out_of_context_element: 
            case incomplete_element_required_elements_missing_expected: 
            case unexpected_element_required_element_missing: 
            case incomplete_element_required_element_missing: 
            case required_attributes_missing_expected: 
            case required_attributes_missing: 
            case required_attribute_missing: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case no_attributes_allowed: 
            case invalid_attribute_name: {
                String attrName = (String)arguments[0];
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case invalid_attribute_value: {
                String attrName = (String)arguments[0];
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case RelaxNGNotFound: {
                String hrefLocation = (String)arguments[1];
                DOMRange locationRange = XMLModelUtils.getHrefNode(document, hrefLocation);
                if (locationRange == null) break;
                return XMLPositionUtility.createRange(locationRange);
            }
        }
        return null;
    }

    static {
        codes = new HashMap<String, RelaxNGErrorCode>();
        for (RelaxNGErrorCode errorCode : RelaxNGErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

