/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGCodeLensParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGCompletionParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGDefinitionParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGDocumentLinkParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGHighlightingParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGReferenceParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGRenameParticipant;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RelaxNGURIResolverExtension;
import org.eclipse.lemminx.extensions.relaxng.xml.contentmodel.CMRelaxNGContentModelProvider;
import org.eclipse.lemminx.services.extensions.IDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.services.extensions.IReferenceParticipant;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.InitializeParams;

public class RelaxNGPlugin
implements IXMLExtension {
    private ContentModelManager contentModelManager;
    private URIResolverExtension uiResolver;
    private final ICompletionParticipant completionParticipant = new RNGCompletionParticipant();
    private final IDefinitionParticipant definitionParticipant = new RNGDefinitionParticipant();
    private final IReferenceParticipant referenceParticipant = new RNGReferenceParticipant();
    private final ICodeLensParticipant codeLensParticipant = new RNGCodeLensParticipant();
    private final IHighlightingParticipant highlightingParticipant = new RNGHighlightingParticipant();
    private final IRenameParticipant renameParticipant = new RNGRenameParticipant();
    private final IDocumentLinkParticipant documentLinkParticipant = new RNGDocumentLinkParticipant();

    @Override
    public void doSave(ISaveContext context) {
        String documentURI = context.getUri();
        DOMDocument document = context.getDocument(documentURI);
        if (DOMUtils.isRelaxNG(document)) {
            context.collectDocumentToValidate(d -> {
                DOMDocument xml = context.getDocument(d.getDocumentURI());
                return this.contentModelManager.dependsOnGrammar(xml, context.getUri());
            });
        }
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        this.uiResolver = new RelaxNGURIResolverExtension();
        registry.getResolverExtensionManager().registerResolver(this.uiResolver);
        CMRelaxNGContentModelProvider modelProvider = new CMRelaxNGContentModelProvider(registry.getResolverExtensionManager());
        this.contentModelManager = (ContentModelManager)registry.getComponent(ContentModelManager.class);
        this.contentModelManager.registerModelProvider(modelProvider);
        registry.registerCompletionParticipant(this.completionParticipant);
        registry.registerDefinitionParticipant(this.definitionParticipant);
        registry.registerReferenceParticipant(this.referenceParticipant);
        registry.registerCodeLensParticipant(this.codeLensParticipant);
        registry.registerHighlightingParticipant(this.highlightingParticipant);
        registry.registerRenameParticipant(this.renameParticipant);
        registry.registerDocumentLinkParticipant(this.documentLinkParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.getResolverExtensionManager().unregisterResolver(this.uiResolver);
        registry.unregisterCompletionParticipant(this.completionParticipant);
        registry.unregisterDefinitionParticipant(this.definitionParticipant);
        registry.unregisterReferenceParticipant(this.referenceParticipant);
        registry.unregisterCodeLensParticipant(this.codeLensParticipant);
        registry.unregisterHighlightingParticipant(this.highlightingParticipant);
        registry.unregisterRenameParticipant(this.renameParticipant);
        registry.unregisterDocumentLinkParticipant(this.documentLinkParticipant);
    }

    public ContentModelManager getContentModelManager() {
        return this.contentModelManager;
    }
}

