/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.CMRelaxNGAttributeValuesCollector;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclaration;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.SimpleNameClass;
import com.thaiopensource.xml.util.Name;
import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;

public class CMRelaxNGAttributeDeclaration
implements CMAttributeDeclaration {
    private final CMRelaxNGElementDeclaration cmElement;
    private final AttributePattern pattern;
    private boolean required;
    private List<String> values;

    public CMRelaxNGAttributeDeclaration(CMRelaxNGElementDeclaration element, AttributePattern pattern) {
        this.cmElement = element;
        this.pattern = pattern;
    }

    @Override
    public String getLocalName() {
        return this.getJingName().getLocalName();
    }

    @Override
    public String getNamespace() {
        return this.getJingName().getNamespaceUri();
    }

    @Override
    public CMElementDeclaration getOwnerElementDeclaration() {
        return this.cmElement;
    }

    Name getJingName() {
        NameClass nameClass = this.pattern.getNameClass();
        if (nameClass instanceof SimpleNameClass) {
            return ((SimpleNameClass)nameClass).getName();
        }
        return null;
    }

    @Override
    public String getDefaultValue() {
        return this.pattern.getDefaultValue();
    }

    @Override
    public Collection<String> getEnumerationValues() {
        if (this.values == null) {
            this.values = new CMRelaxNGAttributeValuesCollector(this.pattern.getContent()).getValues();
        }
        return this.values;
    }

    @Override
    public String getAttributeNameDocumentation(ISharedSettingsRequest request) {
        return this.cmElement.getCMDocument().getDocumentation(this.pattern.getLocator());
    }

    @Override
    public String getAttributeValueDocumentation(String value, ISharedSettingsRequest request) {
        String documentation;
        if (!this.getEnumerationValues().isEmpty() && (documentation = this.cmElement.getCMDocument().getDocumentation(this.pattern.getLocator(), value)) != null) {
            return documentation;
        }
        return this.getAttributeNameDocumentation(request);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    void setRequired(boolean required) {
        this.required = required;
    }

    public AttributePattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<attribute");
        result.append(" name=\"");
        result.append(this.getJingName().getLocalName());
        result.append("\"");
        result.append(" namespaceUri=\"");
        result.append(this.getJingName().getNamespaceUri());
        result.append("\"");
        result.append(" />");
        return result.toString();
    }
}

