/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.text.Collator;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class cvc_attribute_3CodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        block8: {
            Diagnostic diagnostic = request.getDiagnostic();
            DOMDocument document = request.getDocument();
            Range range = request.getRange();
            try {
                Range diagnosticRange = diagnostic.getRange();
                int offset = document.offsetAt(range.getStart());
                DOMAttr attr = document.findAttrAt(offset);
                if (attr == null) break block8;
                DOMElement element = attr.getOwnerElement();
                String attributeName = attr.getName();
                ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
                Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(element);
                String attributeValue = attr.getValue();
                for (CMDocument cmDocument : cmDocuments) {
                    CMAttributeDeclaration cmAttribute = cmDocument.findCMAttribute(element, attributeName);
                    if (cmAttribute == null) continue;
                    Range rangeValue = new Range(new Position(diagnosticRange.getStart().getLine(), diagnosticRange.getStart().getCharacter() + 1), new Position(diagnosticRange.getEnd().getLine(), diagnosticRange.getEnd().getCharacter() - 1));
                    TreeSet<Object> similarValues = new TreeSet<Object>(Collator.getInstance());
                    TreeSet<Object> otherValues = new TreeSet<Object>(Collator.getInstance());
                    for (String string : cmAttribute.getEnumerationValues()) {
                        if (StringUtils.isSimilar(string, attributeValue)) {
                            similarValues.add(string);
                            continue;
                        }
                        otherValues.add(string);
                    }
                    if (!similarValues.isEmpty()) {
                        for (String string : similarValues) {
                            CodeAction similarCodeAction = CodeActionFactory.replace("Did you mean '" + string + "'?", rangeValue, string, document.getTextDocument(), diagnostic);
                            codeActions.add(similarCodeAction);
                        }
                        continue;
                    }
                    for (String string : otherValues) {
                        CodeAction otherCodeAction = CodeActionFactory.replace("Replace with '" + string + "'", rangeValue, string, document.getTextDocument(), diagnostic);
                        codeActions.add(otherCodeAction);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

