/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLCompletionSnippetsTest {
    @Test
    public void emptyXMLContent() throws BadLocationException {
        XMLAssert.testCompletionFor("|", 19, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 0, 0, 0), "<!DOCTYPE"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml-model"), XMLAssert.c("New XML bound with xsi:schemaLocation", "<root-element xmlns=\"https://github.com/eclipse/lemminx\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"" + System.lineSeparator() + "\t\thttps://github.com/eclipse/lemminx file.xsd\">" + System.lineSeparator() + "\t" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 0, 0, 0), "schemaLocation"), XMLAssert.c("New XML bound with xsi:noNamespaceSchemaLocation", "<root-element" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:noNamespaceSchemaLocation=\"file.xsd\">" + System.lineSeparator() + "\t" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 0, 0, 0), "noNamespaceSchemaLocation"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 0), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 0), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 0), "<catalog"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 0), "<!--"));
        XMLAssert.testCompletionFor("<|", 17, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 0, 0, 1), "<!DOCTYPE"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 1), "<?xml"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 0, 0, 1), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 0, 0, 1), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 1), "<!--"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 1), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 1), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 1), "<catalog"));
        XMLAssert.testCompletionFor("<|>", 17, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 0, 0, 2), "<!DOCTYPE"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 2), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 2), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 0, 0, 2), "<catalog"));
        XMLAssert.testCompletionFor("<!|", 17, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 0, 0, 2), "<!DOCTYPE"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"));
    }

    @Test
    public void afterComment() throws BadLocationException {
        XMLAssert.testCompletionFor("<!-- -->|", 17, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 8, 0, 8), "<!DOCTYPE"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 8, 0, 8), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 8, 0, 8), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 8, 0, 8), "<!--"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 8, 0, 8), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 8, 0, 8), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 8, 0, 8), "<catalog"));
    }

    @Test
    public void afterProlog() throws BadLocationException {
        XMLAssert.testCompletionFor("<?xml version=\"1.0\" encoding=\"UTF-8\"?>|", 15, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 38, 0, 38), "<!DOCTYPE"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 38, 0, 38), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 38, 0, 38), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 38, 0, 38), "<!--"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 38, 0, 38), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 38, 0, 38), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 38, 0, 38), "<catalog"));
        XMLAssert.testCompletionFor("<?xml version=\"1.0\" encoding=\"UTF-8\"?><|", 15, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 38, 0, 39), "<!DOCTYPE"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 38, 0, 39), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 38, 0, 39), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 38, 0, 39), "<!--"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 38, 0, 39), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 38, 0, 39), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(0, 38, 0, 39), "<catalog"));
        XMLAssert.testCompletionFor("<?xml version=\"1.0\" encoding=\"UTF-8\"?><|!", 15, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 38, 0, 39), "<!DOCTYPE"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 38, 0, 39), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 38, 0, 39), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 38, 0, 39), "<!--"));
        XMLAssert.testCompletionFor("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!|", 15, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(0, 38, 0, 40), "<!DOCTYPE"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 38, 0, 40), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 38, 0, 40), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 38, 0, 40), "<!--"));
        XMLAssert.testCompletionFor("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n|", 17, XMLAssert.c("New XML with SYSTEM DOCTYPE", "<!DOCTYPE root-element SYSTEM \"file.dtd\">" + System.lineSeparator() + "<root-element>" + System.lineSeparator() + "</root-element>", XMLAssert.r(1, 0, 1, 0), "<!DOCTYPE"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(1, 0, 1, 0), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(1, 0, 1, 0), "<?xml-model"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(1, 0, 1, 0), "<!--"), XMLAssert.c("New catalog bound using DTD", "<!DOCTYPE catalog" + System.lineSeparator() + "\tPUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\"" + System.lineSeparator() + "\t\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">" + System.lineSeparator() + "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(1, 0, 1, 0), "<catalog"), XMLAssert.c("New catalog bound using XSD", "<catalog" + System.lineSeparator() + "\txmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"" + System.lineSeparator() + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + "\txsi:schemaLocation=\"urn:oasis:names:tc:entity:xmlns:xml:catalog" + System.lineSeparator() + "\t\thttp://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd\"" + System.lineSeparator() + "\tprefer=\"public\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(1, 0, 1, 0), "<catalog"), XMLAssert.c("New catalog", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">" + System.lineSeparator() + "\t<public publicId=\"\" uri=\"\" />" + System.lineSeparator() + "</catalog>", XMLAssert.r(1, 0, 1, 0), "<catalog"));
    }

    @Test
    public void emptyXSDContent() throws BadLocationException {
        XMLAssert.testCompletionFor("|", null, "test.xsd", 6, XMLAssert.c("New XML Schema", "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "\t<xs:element name=\"root-element\">" + System.lineSeparator() + "\t\t" + System.lineSeparator() + "\t</xs:element>" + System.lineSeparator() + "</xs:schema>", XMLAssert.r(0, 0, 0, 0), "<schema"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 0), "<!--"));
        XMLAssert.testCompletionFor("<|", null, "test.xsd", 4, XMLAssert.c("New XML Schema", "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "\t<xs:element name=\"root-element\">" + System.lineSeparator() + "\t\t" + System.lineSeparator() + "\t</xs:element>" + System.lineSeparator() + "</xs:schema>", XMLAssert.r(0, 0, 0, 1), "<schema"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 1), "<?xml"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 1), "<!--"));
        XMLAssert.testCompletionFor("<|>", null, "test.xsd", 4, XMLAssert.c("New XML Schema", "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">" + System.lineSeparator() + "\t<xs:element name=\"root-element\">" + System.lineSeparator() + "\t\t" + System.lineSeparator() + "\t</xs:element>" + System.lineSeparator() + "</xs:schema>", XMLAssert.r(0, 0, 0, 2), "<schema"), XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"));
    }

    @Test
    public void commentsOnEmptyContent() throws BadLocationException {
        XMLAssert.testCompletionFor("|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 0), "<!--"));
        XMLAssert.testCompletionFor("<|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 1), "<!--"));
        XMLAssert.testCompletionFor("<!|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"));
        XMLAssert.testCompletionFor("<!-|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 3), "<!--"));
        XMLAssert.testCompletionFor("<!--|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 4), "<!--"));
        XMLAssert.testCompletionFor("<!--| ", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 4), "<!--"));
    }

    @Test
    public void commentsBeforeTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"));
        XMLAssert.testCompletionFor("<a>|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 3, 0, 3), "<!--"));
        XMLAssert.testCompletionFor("<a><|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 3, 0, 4), "<!--"));
        XMLAssert.testCompletionFor("<a><!|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 3, 0, 5), "<!--"));
        XMLAssert.testCompletionFor("<a> |", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 4, 0, 4), "<!--"));
        XMLAssert.testCompletionFor("<a> <|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 4, 0, 5), "<!--"));
        XMLAssert.testCompletionFor("<a> <!|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 4, 0, 6), "<!--"));
    }

    @Test
    public void commentsInsideTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a>|</a>", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 3, 0, 3), "<!--"));
        XMLAssert.testCompletionFor("<a> |</a>", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 4, 0, 4), "<!--"));
        XMLAssert.testCompletionFor("<a> | </a>", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 4, 0, 4), "<!--"));
        XMLAssert.testCompletionFor("<a><|/a>", 0, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a></|a>", 0, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a></a|>", 0, new CompletionItem[0]);
    }

    @Test
    public void commentsInStartTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a|></a>", 0, new CompletionItem[0]);
    }

    @Test
    public void commentsAfterTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a>|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 3, 0, 3), "<!--"));
        XMLAssert.testCompletionFor("<a></a>|", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 7, 0, 7), "<!--"));
    }

    @Test
    public void commentsFollowedBy() throws BadLocationException {
        XMLAssert.testCompletionFor("<!|abcd", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"));
        XMLAssert.testCompletionFor("<|-abcd", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 2), "<!--"));
        XMLAssert.testCompletionFor("<|--abcd", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 3), "<!--"));
        XMLAssert.testCompletionFor("<|-->abcd", XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 4), "<!--"));
    }

    @Test
    public void cdataBeforeTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a|", 1, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a>|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 3, 0, 3), "<![CDATA["));
        XMLAssert.testCompletionFor("<a><|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 3, 0, 4), "<![CDATA["));
        XMLAssert.testCompletionFor("<a><!|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 3, 0, 5), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> |", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 4), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> <|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 5), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> <!|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 6), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> <![CDATA|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 12), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> <![CDATA[|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 13), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> <![CDATA[| ", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 13), "<![CDATA["));
    }

    @Test
    public void cdataInsideTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a>|</a>", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 3, 0, 3), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> |</a>", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 4), "<![CDATA["));
        XMLAssert.testCompletionFor("<a> | </a>", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 4, 0, 4), "<![CDATA["));
    }

    @Test
    public void cdataAfterTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<a>|", XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>", XMLAssert.r(0, 3, 0, 3), "<![CDATA["));
        XMLAssert.testCompletionFor("<a></a>|", 1, new CompletionItem[0]);
    }

    @Test
    public void doctype() throws BadLocationException {
        XMLAssert.testCompletionFor("|<foo>", 12, XMLAssert.c("Insert SYSTEM DOCTYPE", "<!DOCTYPE foo SYSTEM \"file.dtd\">", XMLAssert.r(0, 0, 0, 0), "<!DOCTYPE"));
        XMLAssert.testCompletionFor("<!-- -->|<foo>", 12, XMLAssert.c("Insert SYSTEM DOCTYPE", "<!DOCTYPE foo SYSTEM \"file.dtd\">", XMLAssert.r(0, 8, 0, 8), "<!DOCTYPE"));
        XMLAssert.testCompletionFor("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!-- -->\r\n|<foo>", 12, XMLAssert.c("Insert SYSTEM DOCTYPE", "<!DOCTYPE foo SYSTEM \"file.dtd\">", XMLAssert.r(2, 0, 2, 0), "<!DOCTYPE"));
    }

    @Test
    public void prolog() throws BadLocationException {
        XMLAssert.testCompletionFor("<?|", 7, XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 2), "<?xml"));
    }

    @Test
    public void emptyCompletionInsideComment() throws BadLocationException {
        XMLAssert.testCompletionFor("<!-- |-->", 0, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<!-- |--><foo>", 0, new CompletionItem[0]);
    }

    @Test
    public void emptyCompletionInsideDOCTYPE() throws BadLocationException {
        XMLAssert.testCompletionFor("<!DOCTYPE |root-element SYSTEM \"file.dtd\">", 0, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<!DOCTYPE root-element |SYSTEM \"file.dtd\">", 0, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<!DOCTYPE root-element SYSTEM |\"file.dtd\">", 0, new CompletionItem[0]);
    }

    @Test
    public void atBeginningOfFile() throws BadLocationException {
        String xml = "|<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        XMLAssert.testCompletionFor(xml, 0, new CompletionItem[0]);
        xml = "| <?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        XMLAssert.testCompletionFor(xml, 2, new CompletionItem[0]);
        xml = " |<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
        XMLAssert.testCompletionFor(xml, 2, new CompletionItem[0]);
        xml = "|<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root/>";
        XMLAssert.testCompletionFor(xml, 0, new CompletionItem[0]);
        xml = "| <?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root/>";
        XMLAssert.testCompletionFor(xml, 2, new CompletionItem[0]);
        xml = " |<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root/>";
        XMLAssert.testCompletionFor(xml, 2, new CompletionItem[0]);
        xml = "|\r\n<root/>";
        XMLAssert.testCompletionFor(xml, 14, XMLAssert.c("Insert XML Declaration", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml"), XMLAssert.c("Insert XML Schema association", "<?xml-model href=\"file.xsd\" type=\"application/xml\" schematypens=\"http://www.w3.org/2001/XMLSchema\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml-model"), XMLAssert.c("Insert DTD association", "<?xml-model href=\"file.dtd\" type=\"application/xml-dtd\"?>", XMLAssert.r(0, 0, 0, 0), "<?xml-model"), XMLAssert.c("Insert SYSTEM DOCTYPE", "<!DOCTYPE root SYSTEM \"file.dtd\">", XMLAssert.r(0, 0, 0, 0), "<!DOCTYPE"), XMLAssert.c("<!--", "<!-- -->", XMLAssert.r(0, 0, 0, 0), "<!--"));
    }
}

