/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.uriresolver.FileServer;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Test;

public class XMLValidationCommandTest
extends BaseFileTempTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void validationFileCommand() throws Exception {
        Path baseDir = XMLValidationCommandTest.getTempDirPath().resolve("_lemminx_commands");
        FileServer httpServer = new FileServer(baseDir);
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        try {
            httpServer.start();
            String xsdPath = baseDir.resolve("tag.xsd").toString();
            String xsdURL = httpServer.getUri("tag.xsd");
            String xsd = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n  <xs:element name=\"root\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"tag\"/>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
            XMLValidationCommandTest.createFile(xsdPath, xsd);
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"" + xsdURL + "\">\r\n  <tags />\r\n</root>";
            TextDocumentIdentifier xmlIdentifier = languageServer.didOpen("test.xml", xml);
            Thread.sleep(1000L);
            List<PublishDiagnosticsParams> actualDiagnostics = languageServer.getPublishDiagnostics();
            XMLAssert.assertPublishDiagnostics(actualDiagnostics, XMLAssert.pd(xmlIdentifier.getUri(), XMLAssert.d(1, 1, 1, 5, null, "The resource '" + xsdURL + "' is downloading.", "xml", DiagnosticSeverity.Information)), XMLAssert.pd(xmlIdentifier.getUri(), XMLAssert.d(4, 3, 4, 7, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a, "Invalid element name:\n - tags\n\nOne of the following is expected:\n - tag\n\nError indicated by:\n {the schema}\nwith code:", "xml", DiagnosticSeverity.Error)));
            actualDiagnostics.clear();
            CompletionList list = XMLValidationCommandTest.completion(languageServer, xmlIdentifier);
            XMLAssert.assertCompletion(list, XMLAssert.c("tag", "<tag></tag>"), 5);
            xsd = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n  <xs:element name=\"root\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"tags\"/>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
            XMLValidationCommandTest.updateFile(xsdPath, xsd);
            list = XMLValidationCommandTest.completion(languageServer, xmlIdentifier);
            XMLAssert.assertCompletion(list, XMLAssert.c("tag", "<tag></tag>"), 5);
            languageServer.executeCommand("xml.validation.current.file", xmlIdentifier).get();
            Thread.sleep(1000L);
            actualDiagnostics = languageServer.getPublishDiagnostics();
            XMLAssert.assertPublishDiagnostics(actualDiagnostics, XMLAssert.pd(xmlIdentifier.getUri(), XMLAssert.d(1, 1, 1, 5, null, "The resource '" + xsdURL + "' is downloading.", "xml", DiagnosticSeverity.Information)), XMLAssert.pd(xmlIdentifier.getUri(), new Diagnostic[0]));
            actualDiagnostics.clear();
            list = XMLValidationCommandTest.completion(languageServer, xmlIdentifier);
            XMLAssert.assertCompletion(list, XMLAssert.c("tags", "<tags></tags>"), 5);
        }
        finally {
            httpServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void validationAllFilesCommand() throws Exception {
        Path baseDir = XMLValidationCommandTest.getTempDirPath().resolve("_lemminx_commands");
        FileServer httpServer = new FileServer(baseDir);
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        try {
            httpServer.start();
            String xsdPath = baseDir.resolve("tag.xsd").toString();
            String xsdURL = httpServer.getUri("tag.xsd");
            String xsd = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n  <xs:element name=\"root\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"tag\"/>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
            XMLValidationCommandTest.createFile(xsdPath, xsd);
            String dtdPath = baseDir.resolve("tag.dtd").toString();
            String dtdURL = httpServer.getUri("tag.dtd");
            String dtd = "<!ELEMENT root (tag)>\r\n<!ELEMENT tag EMPTY>";
            XMLValidationCommandTest.createFile(dtdPath, dtd);
            String xml1 = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"" + xsdURL + "\">\r\n  <tags />\r\n</root>";
            TextDocumentIdentifier xml1Identifier = languageServer.didOpen("test1.xml", xml1);
            Thread.sleep(2000L);
            String xml2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE root SYSTEM \"" + dtdURL + "\">\r\n<root>\r\n  <tags />\r\n</root>";
            TextDocumentIdentifier xml2Identifier = languageServer.didOpen("test2.xml", xml2);
            Thread.sleep(1000L);
            List<PublishDiagnosticsParams> actualDiagnostics = languageServer.getPublishDiagnostics();
            XMLAssert.assertPublishDiagnostics(actualDiagnostics, XMLAssert.pd(xml1Identifier.getUri(), XMLAssert.d(1, 1, 1, 5, null, "The resource '" + xsdURL + "' is downloading.", "xml", DiagnosticSeverity.Information)), XMLAssert.pd(xml1Identifier.getUri(), XMLAssert.d(4, 3, 4, 7, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a, "Invalid element name:\n - tags\n\nOne of the following is expected:\n - tag\n\nError indicated by:\n {the schema}\nwith code:", "xml", DiagnosticSeverity.Error)), XMLAssert.pd(xml2Identifier.getUri(), XMLAssert.d(2, 1, 2, 5, null, "The resource '" + dtdURL + "' is downloading.", "xml", DiagnosticSeverity.Information)), XMLAssert.pd(xml2Identifier.getUri(), XMLAssert.d(3, 3, 3, 7, (IXMLErrorCode)DTDErrorCode.MSG_ELEMENT_NOT_DECLARED, "Element type \"tags\" must be declared.", "xml", DiagnosticSeverity.Error), XMLAssert.d(2, 1, 2, 5, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INVALID, "The content of element type \"root\" must match \"(tag)\".", "xml", DiagnosticSeverity.Error)));
            actualDiagnostics.clear();
            CompletionList list1 = XMLValidationCommandTest.completion(languageServer, xml1Identifier);
            XMLAssert.assertCompletion(list1, XMLAssert.c("tag", "<tag></tag>"), 5);
            CompletionList list2 = XMLValidationCommandTest.completion(languageServer, xml2Identifier);
            XMLAssert.assertCompletion(list2, XMLAssert.c("tag", "<tag />"), 5);
            xsd = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n  <xs:element name=\"root\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"tags\"/>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
            XMLValidationCommandTest.updateFile(xsdPath, xsd);
            dtd = "<!ELEMENT root (tags)>\r\n<!ELEMENT tags EMPTY>";
            XMLValidationCommandTest.updateFile(dtdPath, dtd);
            list1 = XMLValidationCommandTest.completion(languageServer, xml1Identifier);
            XMLAssert.assertCompletion(list1, XMLAssert.c("tag", "<tag></tag>"), 5);
            list2 = XMLValidationCommandTest.completion(languageServer, xml2Identifier);
            XMLAssert.assertCompletion(list2, XMLAssert.c("tag", "<tag />"), 5);
            languageServer.executeCommand("xml.validation.all.files", new Object[0]).get();
            Thread.sleep(1000L);
            actualDiagnostics = languageServer.getPublishDiagnostics();
            Collections.sort(actualDiagnostics, (d1, d2) -> d1.getUri().compareTo(d2.getUri()));
            XMLAssert.assertPublishDiagnostics(actualDiagnostics, XMLAssert.pd(xml1Identifier.getUri(), XMLAssert.d(1, 1, 1, 5, null, "The resource '" + xsdURL + "' is downloading.", "xml", DiagnosticSeverity.Information)), XMLAssert.pd(xml1Identifier.getUri(), new Diagnostic[0]), XMLAssert.pd(xml2Identifier.getUri(), XMLAssert.d(2, 1, 2, 5, null, "The resource '" + dtdURL + "' is downloading.", "xml", DiagnosticSeverity.Information)), XMLAssert.pd(xml2Identifier.getUri(), new Diagnostic[0]));
            actualDiagnostics.clear();
            list1 = XMLValidationCommandTest.completion(languageServer, xml1Identifier);
            XMLAssert.assertCompletion(list1, XMLAssert.c("tags", "<tags></tags>"), 5);
            list2 = XMLValidationCommandTest.completion(languageServer, xml2Identifier);
            XMLAssert.assertCompletion(list2, XMLAssert.c("tags", "<tags />"), 5);
        }
        finally {
            httpServer.stop();
        }
    }

    private static CompletionList completion(MockXMLLanguageServer languageServer, TextDocumentIdentifier xmlIdentifier) throws BadLocationException, InterruptedException, ExecutionException {
        DOMDocument document = languageServer.getDocument(xmlIdentifier.getUri());
        int offset = document.getText().indexOf("<tags />");
        Position position = document.positionAt(offset);
        CompletionParams completionParams = new CompletionParams();
        completionParams.setTextDocument(xmlIdentifier);
        completionParams.setPosition(position);
        Either result = (Either)languageServer.getTextDocumentService().completion(completionParams).get();
        CompletionList list = (CompletionList)result.getRight();
        return list;
    }
}

