/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.IRenameRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class XSDRenameParticipant
implements IRenameParticipant {
    @Override
    public void doRename(IRenameRequest request, List<TextEdit> locations) {
        DOMDocument xmlDocument = request.getXMLDocument();
        if (!DOMUtils.isXSD(xmlDocument)) {
            return;
        }
        for (TextEdit textEdit : this.getRenameTextEdits(request)) {
            locations.add(textEdit);
        }
    }

    private List<TextEdit> getRenameTextEdits(IRenameRequest request) {
        DOMDocument document = request.getXMLDocument();
        DOMNode node = request.getNode();
        if (!node.isAttribute()) {
            return Collections.emptyList();
        }
        DOMAttr attr = (DOMAttr)node;
        DOMElement ownerElement = attr.getOwnerElement();
        if (ownerElement == null) {
            return Collections.emptyList();
        }
        String newText = request.getNewText();
        if ((XSDUtils.isXSComplexType(ownerElement) || XSDUtils.isXSSimpleType(ownerElement)) && attr.getName().equals("name")) {
            List<Location> locations = this.getReferenceLocations(ownerElement);
            return this.renameAttributeValueTextEdits(document, attr, newText, locations);
        }
        return Collections.emptyList();
    }

    private List<Location> getReferenceLocations(DOMNode node) {
        ArrayList<Location> locations = new ArrayList<Location>();
        XSDUtils.searchXSOriginAttributes(node, (origin, target) -> locations.add(XMLPositionUtility.createLocation(origin.getNodeAttrValue())), null);
        return locations;
    }

    private List<TextEdit> renameAttributeValueTextEdits(DOMDocument document, DOMAttr attribute, String newText, List<Location> locations) {
        DOMNode attrValue = attribute.getNodeAttrValue();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        int valueStart = attrValue.getStart();
        int valueEnd = attrValue.getEnd();
        Range range = XMLPositionUtility.createRange(valueStart, valueEnd, document);
        this.reduceRangeFromBothEnds(range, 1);
        textEdits.add(new TextEdit(range, newText));
        for (Location location : locations) {
            String oldAttrValue;
            Range textEditRange = location.getRange();
            this.reduceRangeFromBothEnds(textEditRange, 1);
            try {
                oldAttrValue = this.getAttrTextValueFromPosition(document, location.getRange().getStart());
            }
            catch (BadLocationException e1) {
                return Collections.emptyList();
            }
            int colonIndex = oldAttrValue.indexOf(":");
            if (colonIndex > 0) {
                this.increaseStartRange(textEditRange, colonIndex + 1);
            }
            TextEdit textEdit = new TextEdit(textEditRange, newText);
            textEdits.add(textEdit);
        }
        return textEdits;
    }

    private void reduceRangeFromBothEnds(Range range, int reduce) {
        this.increaseStartRange(range, reduce);
        this.decreaseEndRange(range, reduce);
    }

    private void increaseStartRange(Range range, int increase) {
        int startCharacter = range.getStart().getCharacter();
        range.getStart().setCharacter(startCharacter + increase);
    }

    private void decreaseEndRange(Range range, int decrease) {
        int endCharacter = range.getEnd().getCharacter();
        range.getEnd().setCharacter(endCharacter - decrease);
    }

    private String getAttrTextValueFromPosition(DOMDocument document, Position position) throws BadLocationException {
        int offset = document.offsetAt(position);
        return document.findAttrAt(offset).getValue();
    }
}

