/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lsp4j.Position;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextDocumentTest {
    @Test
    public void testEmptyDocument() throws BadLocationException {
        TextDocument document = new TextDocument("", "");
        Position position = document.positionAt(0);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        position = new Position(0, 0);
        int offset = document.offsetAt(position);
        Assertions.assertEquals((int)0, (int)offset);
    }

    @Test
    public void testPositionAt() throws BadLocationException {
        TextDocument document = new TextDocument("abcd\nefgh", "");
        Position position = document.positionAt(0);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        position = document.positionAt(4);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        position = document.positionAt(5);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        position = document.positionAt(9);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        BadLocationException ex = null;
        try {
            position = document.positionAt(10);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
    }

    @Test
    public void testPositionAtEndLine() throws BadLocationException {
        TextDocument document = new TextDocument("abcd\n", "");
        Position position = document.positionAt(4);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        position = document.positionAt(5);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        BadLocationException ex = null;
        try {
            position = document.positionAt(6);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
        document = new TextDocument("abcd\nefgh\n", "");
        position = document.positionAt(9);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        position = document.positionAt(10);
        Assertions.assertEquals((int)2, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        ex = null;
        try {
            position = document.positionAt(11);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
    }

    @Test
    public void testOffsetAt() throws BadLocationException {
        TextDocument document = new TextDocument("abcd\nefgh", "");
        Position position = new Position(0, 0);
        int offset = document.offsetAt(position);
        Assertions.assertEquals((int)0, (int)offset);
        position = new Position(0, 4);
        offset = document.offsetAt(position);
        Assertions.assertEquals((int)4, (int)offset);
        position = new Position(1, 0);
        offset = document.offsetAt(position);
        Assertions.assertEquals((int)5, (int)offset);
        position = new Position(1, 4);
        offset = document.offsetAt(position);
        Assertions.assertEquals((int)9, (int)offset);
        BadLocationException ex = null;
        try {
            position = new Position(1, 5);
            document.offsetAt(position);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
    }

    @Test
    public void testEmptyDocumentInc() throws BadLocationException {
        TextDocument document = new TextDocument("", "");
        document.setIncremental(true);
        Position position = document.positionAt(0);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        position = new Position(0, 0);
        int offset = document.offsetAt(position);
        Assertions.assertEquals((int)0, (int)offset);
    }

    @Test
    public void testPositionAtInc() throws BadLocationException {
        TextDocument document = new TextDocument("abcd\nefgh", "");
        document.setIncremental(true);
        Position position = document.positionAt(0);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        position = document.positionAt(4);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        position = document.positionAt(5);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        position = document.positionAt(9);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        BadLocationException ex = null;
        try {
            position = document.positionAt(10);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
    }

    @Test
    public void testPositionAtEndLineInc() throws BadLocationException {
        TextDocument document = new TextDocument("abcd\n", "");
        document.setIncremental(true);
        Position position = document.positionAt(4);
        Assertions.assertEquals((int)0, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        position = document.positionAt(5);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        BadLocationException ex = null;
        try {
            position = document.positionAt(6);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
        document = new TextDocument("abcd\nefgh\n", "");
        position = document.positionAt(9);
        Assertions.assertEquals((int)1, (int)position.getLine());
        Assertions.assertEquals((int)4, (int)position.getCharacter());
        position = document.positionAt(10);
        Assertions.assertEquals((int)2, (int)position.getLine());
        Assertions.assertEquals((int)0, (int)position.getCharacter());
        ex = null;
        try {
            position = document.positionAt(11);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
    }

    @Test
    public void testOffsetAtInc() throws BadLocationException {
        TextDocument document = new TextDocument("abcd\nefgh", "");
        document.setIncremental(true);
        Position position = new Position(0, 0);
        int offset = document.offsetAt(position);
        Assertions.assertEquals((int)0, (int)offset);
        position = new Position(0, 4);
        offset = document.offsetAt(position);
        Assertions.assertEquals((int)4, (int)offset);
        position = new Position(1, 0);
        offset = document.offsetAt(position);
        Assertions.assertEquals((int)5, (int)offset);
        position = new Position(1, 4);
        offset = document.offsetAt(position);
        Assertions.assertEquals((int)9, (int)offset);
        BadLocationException ex = null;
        try {
            position = new Position(1, 5);
            document.offsetAt(position);
        }
        catch (BadLocationException e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)((Object)ex));
    }
}

