/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.SingleInputBroadcastIterator;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class SingleInputBroadcastIteratorTest {
    @Test
    public void testBroadcastWithNoOutput() {
        int j;
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)2.0, (double)8.0, (double)1.0);
        SingleInputBroadcastIterator it = new SingleInputBroadcastIterator(a, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{6}, (int[])it.getShape());
        DoubleDataset c = DatasetFactory.zeros((int[])it.getShape());
        int j2 = 0;
        while (j2 < 6) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)it.aDouble, j2);
            Assert.assertEquals((double)a.getDouble(j2), (double)it.aDouble, (double)1.0E-15);
            ++j2;
        }
        Assert.assertFalse((boolean)it.hasNext());
        a = DatasetFactory.createFromObject((Object)1);
        it = new SingleInputBroadcastIterator(a, null);
        it.setOutputDouble(true);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[0], (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        Assert.assertTrue((boolean)it.hasNext());
        c.set((Object)it.aDouble);
        Assert.assertEquals((double)a.getDouble(), (double)it.aDouble, (double)1.0E-15);
        Assert.assertFalse((boolean)it.hasNext());
        a = DatasetFactory.createRange(DoubleDataset.class, (double)2.0, (double)8.0, (double)1.0);
        Dataset b = a.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        j2 = 0;
        while (j2 < 3) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)it.aDouble, j2);
            Assert.assertEquals((double)b.getDouble(j2), (double)it.aDouble, (double)1.0E-15);
            Assert.assertEquals((double)c.getDouble(j2), (double)((double)(2 * j2) + 2.0), (double)1.0E-15);
            ++j2;
        }
        Assert.assertFalse((boolean)it.hasNext());
        b = a.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-2))});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        j2 = 0;
        while (j2 < 3) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)it.aDouble, j2);
            Assert.assertEquals((double)b.getDouble(j2), (double)it.aDouble, (double)1.0E-15);
            Assert.assertEquals((double)c.getDouble(j2), (double)((double)(-2 * j2) + 7.0), (double)1.0E-15);
            ++j2;
        }
        Assert.assertFalse((boolean)it.hasNext());
        b = a = ((DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)2.0, (double)14.0, (double)1.0)).reshape(new int[]{3, 4});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3, 4}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 4) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)it.aDouble, i, j);
                Assert.assertEquals((double)b.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(i * 4 + j) + 2.0), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        b = a.getSliceView(new Slice[]{null, new Slice(null, null, Integer.valueOf(2))});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3, 2}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 2) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)it.aDouble, i, j);
                Assert.assertEquals((double)a.getDouble(i, 2 * j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(i * 4 + j * 2) + 2.0), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        b = a.getSliceView(new Slice[]{null, new Slice(null, null, Integer.valueOf(-2))});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3, 2}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 2) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)it.aDouble, i, j);
                Assert.assertEquals((double)a.getDouble(i, 3 - 2 * j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(i * 4) + 3.0 - (double)(2 * j) + 2.0), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        a = a.reshape(new int[]{12}).getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))});
        b = a.reshape(new int[]{3, 4});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3, 4}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 4) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)it.aDouble, i, j);
                Assert.assertEquals((double)b.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(8 - i * 4 + 3 - j) + 2.0), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        b = b.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))});
        it = new SingleInputBroadcastIterator(b, null);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{3, 4}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 4) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)it.aDouble, i, j);
                Assert.assertEquals((double)b.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(i * 4 + 3 - j) + 2.0), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testBroadcastWithOutput() {
        int j;
        Dataset a = DatasetFactory.createFromObject((Object)1.0);
        DoubleDataset c = DatasetFactory.zeros((int[])new int[]{10});
        SingleInputBroadcastIterator it = new SingleInputBroadcastIterator(a, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10}, (int[])it.getShape());
        int i = 0;
        while (i < 10) {
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((double)a.getDouble(), (double)it.aDouble, (double)1.0E-15);
            c.setObjectAbs(it.oIndex, (Object)it.aDouble);
            Assert.assertEquals((double)c.getDouble(i), (double)1.0, (double)1.0E-15);
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        a = DatasetFactory.createRange((double)10.0);
        c = DatasetFactory.zeros((int[])new int[]{10});
        it = new SingleInputBroadcastIterator(a, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertEquals((double)a.getDouble(i), (double)it.aDouble, (double)1.0E-15);
            c.setObjectAbs(it.oIndex, (Object)it.aDouble);
            Assert.assertEquals((double)c.getDouble(i), (double)i, (double)1.0E-15);
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        a = DatasetFactory.createRange((double)120.0).reshape(new int[]{10, 12});
        c = a;
        it = new SingleInputBroadcastIterator(a, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i, j), (double)(i * 12 + j), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        a = DatasetFactory.createRange((double)240.0).reshape(new int[]{20, 12}).getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        c = a;
        it = new SingleInputBroadcastIterator(a, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i, j), (double)(24 * i + j), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        a = DatasetFactory.createRange((double)12.0);
        c = DatasetFactory.zeros((int[])new int[]{10, 12});
        it = new SingleInputBroadcastIterator(a, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(j), (double)it.aDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)c.getDouble(i, j), (double)j, (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
        CompoundDataset cc = DatasetFactory.compoundZeros((int)3, CompoundDoubleDataset.class, (int[])new int[]{10, 12});
        it = new SingleInputBroadcastIterator(a, (Dataset)cc);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        int isc = cc.getElementsPerItem();
        double[] ca = new double[isc];
        int i2 = 0;
        while (i2 < 10) {
            int j2 = 0;
            while (j2 < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(j2), (double)it.aDouble, (double)1.0E-15);
                cc.setObjectAbs(it.oIndex, (Object)it.aDouble);
                Assert.assertEquals((double)cc.getDouble(i2, j2), (double)j2, (double)1.0E-15);
                cc.getDoubleArray(ca, i2, j2);
                int k = 1;
                while (k < isc) {
                    Assert.assertEquals((double)ca[k], (double)ca[0], (double)1.0E-15);
                    ++k;
                }
                ++j2;
            }
            ++i2;
        }
        Assert.assertFalse((boolean)it.hasNext());
    }
}

