/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.Stats;

public class CollectionStats {
    public static Dataset mean(List<IDataset> sets) throws Exception {
        return CollectionStats.process(sets, new StatFunction(){

            @Override
            public double evaluate(Dataset set) {
                return (Double)set.mean(new boolean[0]);
            }
        });
    }

    public static Dataset median(List<IDataset> sets) throws Exception {
        return CollectionStats.process(sets, new StatFunction(){

            @Override
            public double evaluate(Dataset set) {
                return (Double)Stats.median(set);
            }
        });
    }

    private static Dataset process(List<IDataset> sets, StatFunction function) throws Exception {
        int[] shape = CollectionStats.assertShapes(sets);
        DoubleDataset result = DatasetFactory.zeros(DoubleDataset.class, shape);
        double[] rData = result.getData();
        PositionIterator iter = new PositionIterator(shape);
        int[] pos = ((IndexIterator)iter).getPos();
        int len = sets.size();
        DoubleDataset pixel = DatasetFactory.zeros(DoubleDataset.class, len);
        double[] pData = pixel.getData();
        int i = 0;
        while (((IndexIterator)iter).hasNext()) {
            int ipix = 0;
            while (ipix < len) {
                pData[ipix] = sets.get(ipix).getDouble(pos);
                ++ipix;
            }
            pixel.setDirty();
            rData[i] = function.evaluate(pixel);
            ++i;
        }
        return result;
    }

    private static int[] assertShapes(Collection<IDataset> sets) throws Exception {
        if (sets.size() < 2) {
            throw new IllegalArgumentException("You must take the median of at least two sets!");
        }
        Iterator<IDataset> it = sets.iterator();
        int[] shape = it.next().getShape();
        while (it.hasNext()) {
            IDataset d = it.next();
            int[] nextShape = d.getShape();
            if (Arrays.equals(shape, nextShape)) continue;
            throw new IllegalArgumentException("All data sets should be the same shape!");
        }
        return shape;
    }

    private static interface StatFunction {
        public double evaluate(Dataset var1);
    }
}

