/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class IntegerDatasetTest {
    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new IntegerDataset().getSize());
        Assert.assertEquals((long)0L, (long)DatasetFactory.createFromObject((Object)1).getRank());
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        int[] da = nArray;
        IntegerDataset a = new IntegerDataset(da, null);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i, (long)a.getElementLongAbs(it.index));
            ++i;
        }
        IntegerDataset b = new IntegerDataset(da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i2, (long)b.getElementLongAbs(it.index));
            ++i2;
        }
        a.hashCode();
        b.hashCode();
        Class<?> clazz = a.getClass();
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isElemental(clazz));
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isCompound(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isInteger(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isNumerical(clazz));
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isFloating(clazz));
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isComplex(clazz));
    }

    @Test
    public void testStats() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)12.0);
        Assert.assertEquals((Object)11, (Object)a.max(new boolean[0]));
        Assert.assertEquals((double)0.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
    }

    @Test
    public void testPosition() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        Assert.assertEquals((long)6L, (long)a.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)0L, (long)a.minPos(new boolean[0])[0]);
        Dataset b = DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{100, 200});
        b.set((Object)100, new int[]{50, 100});
        b.set((Object)-100, new int[]{51, 101});
        Assert.assertEquals((long)50L, (long)b.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)100L, (long)b.maxPos(new boolean[0])[1]);
        Assert.assertEquals((long)51L, (long)b.minPos(new boolean[0])[0]);
        Assert.assertEquals((long)101L, (long)b.minPos(new boolean[0])[1]);
    }

    @Test
    public void testInplaceMethods() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)6.0);
        Dataset b = DatasetFactory.createRange(IntegerDataset.class, (double)6.0);
        Dataset bl = DatasetFactory.createRange(LongDataset.class, (double)6.0);
        Dataset c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.iadd((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.iadd((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)3), (Dataset)c.iadd((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)3L), (Dataset)c.iadd((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        c.iadd((Object)b);
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)b), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)2), (Dataset)c);
        c = a.clone();
        c.iadd((Object)bl);
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)bl).cast(IntegerDataset.class), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)2L).cast(IntegerDataset.class), (Dataset)c);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.isubtract((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.isubtract((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.subtract((Object)a, (Object)3), (Dataset)c.isubtract((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.subtract((Object)a, (Object)3L).cast(IntegerDataset.class), (Dataset)c.isubtract((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        c.isubtract((Object)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)0), (Dataset)c);
        c = a.clone();
        c.isubtract((Object)bl);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)0), (Dataset)c);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.imultiply((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.imultiply((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)3), (Dataset)c.imultiply((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)3L).cast(IntegerDataset.class), (Dataset)c.imultiply((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)b), (Dataset)c.imultiply((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)bl).cast(IntegerDataset.class), (Dataset)c.imultiply((Object)bl));
        c = a.clone();
        c.imultiply((Object)b);
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)2), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.square((Object)a).cast(IntegerDataset.class), (Dataset)c);
        c = a.clone();
        c.imultiply((Object)bl);
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)2L), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.square((Object)a).cast(IntegerDataset.class), (Dataset)c);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.idivide((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.idivide((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.idivide((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.idivide((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.divide((Object)a, (Object)3), (Dataset)c.idivide((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.divide((Object)a, (Object)3L), (Dataset)c.idivide((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        Dataset t = DatasetFactory.ones((Dataset)a);
        t.set((Object)Double.NaN, 0);
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.idivide((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.idivide((Object)bl));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.iremainder((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.iremainder((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.iremainder((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.iremainder((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.remainder((Object)a, (Object)3), (Dataset)c.iremainder((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.remainder((Object)a, (Object)3L), (Dataset)c.iremainder((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        t = DatasetFactory.zeros((Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.iremainder((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.iremainder((Object)bl));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)3));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)-3), (Dataset)c.ipower((Object)-3));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)b), (Dataset)c.ipower((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)bl).cast(IntegerDataset.class), (Dataset)c.ipower((Object)bl));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)b), (Dataset)c.ipower((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)bl).cast(IntegerDataset.class), (Dataset)c.ipower((Object)bl));
        c = a.clone();
        t = Maths.negative((Object)Maths.add((Object)b, (Object)1));
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)t).cast(IntegerDataset.class), (Dataset)c.ipower((Object)t));
        ComplexDoubleDataset z = (ComplexDoubleDataset)DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)a, (Object)DatasetFactory.zeros((Dataset)a));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)z).getRealView().cast(IntegerDataset.class), (Dataset)c.ipower((Object)z));
        z = (ComplexDoubleDataset)DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)Maths.negative((Object)a), (Object)DatasetFactory.zeros((Dataset)a));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.reciprocal((Object)a), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)-3), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)z).getRealView().cast(IntegerDataset.class), (Dataset)c.ipower((Object)z));
        z = (ComplexDoubleDataset)DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)a, (Object)a);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)new Complex(1.0, 1.0)).getRealView().cast(IntegerDataset.class), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)new Complex(3.0, 3.0)).getRealView().cast(IntegerDataset.class), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)z).getRealView().cast(IntegerDataset.class), (Dataset)c.ipower((Object)z));
        a = Maths.multiply((Object)a, (Object)1.5);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.floor((Object)a), (Dataset)c.ifloor());
    }
}

